/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.pdf.converter;

import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.NotNullValueSupplier;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.misc.Utils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;

public class PdfConverterExtension {
    public static final NullableDataKey<BaseRendererBuilder.TextDirection> DEFAULT_TEXT_DIRECTION = new NullableDataKey("DEFAULT_TEXT_DIRECTION");
    public static final NullableDataKey<ProtectionPolicy> PROTECTION_POLICY = new NullableDataKey("PROTECTION_POLICY");
    public static final String DEFAULT_CSS_RESOURCE_PATH = "/default.css";
    public static final String DEFAULT_TOC_LIST_CLASS = "toc";
    public static final DataKey<String> DEFAULT_CSS = new DataKey<NotNullValueSupplier<String>>("DEFAULT_CSS", () -> Utils.getResourceAsString(PdfConverterExtension.class, DEFAULT_CSS_RESOURCE_PATH));

    public static String embedCss(String html, String css) {
        if (css != null && !css.isEmpty()) {
            int pos = html.indexOf("</head>");
            Object prefix = "<style>\n";
            Object suffix = "\n</style>";
            String tail = "";
            if (pos == -1) {
                pos = html.indexOf("<html>");
                if (pos != -1) {
                    pos += 6;
                    prefix = "<head>" + (String)prefix;
                    suffix = (String)suffix + "</head>";
                } else {
                    pos = html.indexOf("<body>");
                    if (pos != -1) {
                        prefix = "<html><head>" + (String)prefix;
                        suffix = (String)suffix + "</head>";
                        tail = "</html>\n";
                    } else {
                        pos = 0;
                        prefix = "<html><head>" + (String)prefix;
                        suffix = (String)suffix + "</head><body>\n";
                        tail = "</body></html>\n";
                    }
                }
            }
            return html.subSequence(0, pos) + (String)prefix + css + (String)suffix + html.subSequence(pos, html.length()) + tail;
        }
        return html;
    }

    public static void exportToPdf(String out, String html, String url, DataHolder options) {
        String css = DEFAULT_CSS.get(options);
        html = PdfConverterExtension.embedCss(html, css);
        PdfConverterExtension.exportToPdf(out, html, url, DEFAULT_TEXT_DIRECTION.get(options), PROTECTION_POLICY.get(options));
    }

    public static void exportToPdf(String out, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection) {
        PdfConverterExtension.exportToPdf(out, html, url, defaultTextDirection, null);
    }

    public static void exportToPdf(String out, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection, ProtectionPolicy protectionPolicy) {
        try {
            FileOutputStream os = new FileOutputStream(out);
            PdfConverterExtension.exportToPdf(os, html, url, defaultTextDirection, protectionPolicy);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void exportToPdf(OutputStream os, String html, String url, DataHolder options) {
        PdfConverterExtension.exportToPdf(os, html, url, DEFAULT_TEXT_DIRECTION.get(options), PROTECTION_POLICY.get(options));
    }

    public static void exportToPdf(OutputStream os, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection) {
        PdfConverterExtension.exportToPdf(os, html, url, defaultTextDirection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToPdf(OutputStream os, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection, ProtectionPolicy protectionPolicy) {
        PdfBoxRenderer renderer = null;
        try {
            PdfRendererBuilder builder = new PdfRendererBuilder();
            PdfConverterExtension.handleTextDirection(defaultTextDirection, builder);
            PdfConverterExtension.handleW3cDocument(html, url, builder);
            builder.toStream(os);
            renderer = builder.buildPdfRenderer();
            PDDocument document2 = renderer.getPdfDocument();
            if (protectionPolicy != null) {
                document2.protect(protectionPolicy);
            }
            renderer.layout();
            renderer.createPDF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (renderer != null) {
                    renderer.close();
                }
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void handleW3cDocument(String html, String url, PdfRendererBuilder builder) {
        Document doc = Jsoup.parse((String)html);
        org.w3c.dom.Document dom = new W3CDom().fromJsoup(doc);
        builder.withW3cDocument(dom, url);
    }

    private static void handleTextDirection(BaseRendererBuilder.TextDirection defaultTextDirection, PdfRendererBuilder builder) {
        if (defaultTextDirection != null) {
            builder.useUnicodeBidiSplitter(new ICUBidiSplitter.ICUBidiSplitterFactory());
            builder.useUnicodeBidiReorderer(new ICUBidiReorderer());
            builder.defaultTextDirection(defaultTextDirection);
        }
    }
}

