/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/images/editor/impl/jcef/CefStreamResourceHandler;", "Lorg/cef/handler/CefResourceHandler;", "Lcom/intellij/openapi/Disposable;", "myStream", "Ljava/io/InputStream;", "myMimeType", "", "parent", "headers", "", "(Ljava/io/InputStream;Ljava/lang/String;Lcom/intellij/openapi/Disposable;Ljava/util/Map;)V", "cancel", "", "dispose", "getResponseHeaders", "response", "Lorg/cef/network/CefResponse;", "responseLength", "Lorg/cef/misc/IntRef;", "redirectUrl", "Lorg/cef/misc/StringRef;", "processRequest", "", "request", "Lorg/cef/network/CefRequest;", "callback", "Lorg/cef/callback/CefCallback;", "readResponse", "dataOut", "", "bytesToRead", "", "bytesRead", "intellij.platform.images"})
public final class CefStreamResourceHandler
implements CefResourceHandler,
Disposable {
    @NotNull
    private final InputStream myStream;
    @NotNull
    private final String myMimeType;
    @NotNull
    private final Map<String, String> headers;

    public CefStreamResourceHandler(@NotNull InputStream myStream, @NotNull String myMimeType, @NotNull Disposable parent, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)myStream, (String)"myStream");
        Intrinsics.checkNotNullParameter((Object)myMimeType, (String)"myMimeType");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.myStream = myStream;
        this.myMimeType = myMimeType;
        this.headers = headers;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public /* synthetic */ CefStreamResourceHandler(InputStream inputStream, String string, Disposable disposable, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        this(inputStream, string, disposable, map);
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(@NotNull CefResponse response, @NotNull IntRef responseLength, @NotNull StringRef redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)responseLength, (String)"responseLength");
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        response.setMimeType(this.myMimeType);
        response.setStatus(200);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            response.setHeaderByName(header.getKey(), header.getValue(), true);
        }
    }

    public boolean readResponse(@NotNull byte[] dataOut, int bytesToRead, @NotNull IntRef bytesRead, @NotNull CefCallback callback) {
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter((Object)bytesRead, (String)"bytesRead");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            bytesRead.set(this.myStream.read(dataOut, 0, bytesToRead));
            if (bytesRead.get() != -1) {
                return true;
            }
        }
        catch (IOException e) {
            callback.cancel();
        }
        bytesRead.set(0);
        Disposer.dispose((Disposable)this);
        return false;
    }

    public void cancel() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        try {
            this.myStream.close();
        }
        catch (IOException e) {
            Logger.getInstance(CefStreamResourceHandler.class).warn("Failed to close the stream", (Throwable)e);
        }
    }
}

