/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenParentRelativePathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, @NotNull ConvertContext context2) {
        if (context2 == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        VirtualFile contextFile = context2.getFile().getVirtualFile();
        if (contextFile == null) {
            return null;
        }
        VirtualFile parent = contextFile.getParent();
        if (parent == null) {
            return null;
        }
        VirtualFile f = parent.findFileByRelativePath(s);
        if (f == null) {
            return null;
        }
        if (f.isDirectory()) {
            f = f.findChild("pom.xml");
        }
        if (f == null) {
            return null;
        }
        return context2.getPsiManager().findFile(f);
    }

    public String toString(@Nullable PsiFile f, @NotNull ConvertContext context2) {
        if (context2 == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(1);
        }
        if (f == null) {
            return null;
        }
        VirtualFile currentFile = context2.getFile().getOriginalFile().getVirtualFile();
        if (currentFile == null) {
            return null;
        }
        return MavenDomUtil.calcRelativePath(currentFile.getParent(), f.getVirtualFile());
    }

    @NotNull
    public Collection<PsiFile> getVariants(@NotNull ConvertContext context2) {
        if (context2 == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(2);
        }
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiFile currentFile = context2.getFile().getOriginalFile();
        for (DomFileElement<MavenDomProjectModel> each : MavenDomUtil.collectProjectModels(context2.getFile().getProject())) {
            XmlFile file = each.getOriginalFile();
            if (file == currentFile) continue;
            result2.add((PsiFile)file);
        }
        ArrayList<PsiFile> arrayList = result2;
        if (arrayList == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public LocalQuickFix[] getQuickFixes(@NotNull ConvertContext context2) {
        if (context2 == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(4);
        }
        return (LocalQuickFix[])ArrayUtil.append((Object[])super.getQuickFixes(context2), (Object)new RelativePathFix(context2));
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context2) {
        Project project2 = element.getProject();
        Condition condition = item -> item.isDirectory() || MavenUtil.isPomFile(project2, item.getVirtualFile());
        PsiReference[] psiReferenceArray = new MavenPathReferenceConverter((Condition<PsiFileSystemItem>)condition).createReferences(genericDomValue, element, context2);
        if (psiReferenceArray == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static class RelativePathFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final ConvertContext myContext;

        RelativePathFix(ConvertContext context2) {
            this.myContext = context2;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.parent.path", new Object[0]);
            if (string == null) {
                RelativePathFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                RelativePathFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                RelativePathFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                RelativePathFix.$$$reportNull$$$0(3);
            }
            MavenId id = MavenArtifactCoordinatesHelper.getId(this.myContext);
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
            MavenProject parentFile = manager.findProject(id);
            if (parentFile != null) {
                VirtualFile currentFile = this.myContext.getFile().getVirtualFile();
                String relativePath = MavenDomUtil.calcRelativePath(currentFile.getParent(), parentFile.getFile());
                XmlTag xmlTag = (XmlTag)descriptor2.getPsiElement();
                xmlTag.getValue().setText(relativePath);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

