/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.lang.JavaVersion;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelQuickFix;
import org.jetbrains.idea.maven.importing.MavenProjectModelModifier;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class TargetLevelPluginQuickFix
extends LanguageLevelQuickFix {
    public TargetLevelPluginQuickFix(@NotNull Project project2, @NotNull MavenProject mavenProject2) {
        if (project2 == null) {
            TargetLevelPluginQuickFix.$$$reportNull$$$0(0);
        }
        if (mavenProject2 == null) {
            TargetLevelPluginQuickFix.$$$reportNull$$$0(1);
        }
        super(project2, mavenProject2);
    }

    @Override
    protected void runLiveTemplate(@NotNull Document document, @NotNull MavenDomProjectModel model, @NotNull LanguageLevel level) {
        if (document == null) {
            TargetLevelPluginQuickFix.$$$reportNull$$$0(2);
        }
        if (model == null) {
            TargetLevelPluginQuickFix.$$$reportNull$$$0(3);
        }
        if (level == null) {
            TargetLevelPluginQuickFix.$$$reportNull$$$0(4);
        }
        XmlTag tag = MavenProjectModelModifier.getCompilerPlugin(model).getConfiguration().ensureTagExists();
        String option = JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion());
        String prevTargetValue = TargetLevelPluginQuickFix.setChildTagIfAbsent(tag, "target", option);
        String targetValue2 = Optional.ofNullable(tag.findFirstSubTag("source")).map(sourceTag -> sourceTag.getValue()).map(t -> t.getText()).orElse(option);
        PsiDocumentManager.getInstance((Project)this.project).doPostponedOperationsAndUnblockDocument(document);
        FileDocumentManager.getInstance().saveDocument(document);
        tag = MavenProjectModelModifier.getCompilerPlugin(model).getConfiguration().ensureTagExists();
        Template template = TargetLevelPluginQuickFix.getTemplate(tag, prevTargetValue, targetValue2);
        this.runTemplate(template, tag);
    }

    @Nullable
    private static Template getTemplate(XmlTag tagProperty, String prevTarget, String option) {
        XmlTag tagTarget = tagProperty.findFirstSubTag("target");
        PsiElement psiTarget = TargetLevelPluginQuickFix.getXmlTagPsiValue(tagTarget);
        if (psiTarget == null) {
            return null;
        }
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl((PsiElement)tagProperty);
        builder2.replaceElement(psiTarget, "variableTarget", (Expression)TargetLevelPluginQuickFix.getExpression(prevTarget, option), true);
        return builder2.buildInlineTemplate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/TargetLevelPluginQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runLiveTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

