/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.util.PairConsumer;
import java.util.List;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.plugins.groovy.GroovyPluginConfiguratorKt;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class GroovyImporter
extends MavenImporter {
    public GroovyImporter(String pluginGroupID, String pluginArtifactID) {
        super(pluginGroupID, pluginArtifactID);
    }

    @Override
    public void collectSourceRoots(MavenProject mavenProject2, PairConsumer<String, JpsModuleSourceRootType<?>> result2) {
        MavenPlugin plugin = mavenProject2.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        if (plugin != null) {
            GroovyPluginConfiguratorKt.collectGroovyFolders(plugin, true).forEach(path2 -> result2.consume(path2, (Object)JavaSourceRootType.SOURCE));
            GroovyPluginConfiguratorKt.collectGroovyFolders(plugin, false).forEach(path2 -> result2.consume(path2, (Object)JavaSourceRootType.TEST_SOURCE));
        }
    }

    @Override
    public void collectExcludedFolders(MavenProject mavenProject2, List<String> result2) {
        MavenPlugin plugin = mavenProject2.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        if (plugin != null) {
            result2.addAll(GroovyPluginConfiguratorKt.collectIgnoredFolders(mavenProject2, plugin));
        }
    }
}

