/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.DependencyScope;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependency;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityAndExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.impl.LegacyBridgeJpsEntitySourceFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenProjectShadingData;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfigurator;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J@\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 *\u00020\u001e2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00170\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001e0$H\u0002J\u0018\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\"*\u00020\u001eH\u0002J\f\u0010'\u001a\u00020\u0011*\u00020\u0011H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "()V", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "Lorg/jetbrains/annotations/NotNull;", "addJarDependency", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "dependencyMavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "dependencyJarPath", "", "addLibraryEntity", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "libraryRootsProvider", "Lkotlin/Function0;", "", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "beforeModelApplied", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "getUberJarPath", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "collectDependentMavenProjects", "", "mavenProjectToModules", "", "moduleIdToMavenProject", "Ljava/util/HashMap;", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "getRelocationMap", "replaceDots", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenShadePluginConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n766#2:306\n857#2,2:307\n800#2,11:309\n800#2,11:320\n*S KotlinDebug\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator\n*L\n68#1:306\n68#1:307,2\n72#1:309,11\n99#1:320,11\n*E\n"})
public final class MavenShadePluginConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    private final ProjectModelExternalSource externalSource;

    public MavenShadePluginConfigurator() {
        ProjectModelExternalSource projectModelExternalSource = ExternalProjectSystemRegistry.getInstance().getSourceById(WorkspaceModuleImporter.Companion.getEXTERNAL_SOURCE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"getSourceById(...)");
        this.externalSource = projectModelExternalSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        void $this$filterTo$iv$iv;
        Object module22;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Registry.is((String)"maven.shade.plugin.create.uber.jar.dependency")) {
            return;
        }
        Map mavenProjectToModules2 = MapsKt.toMap((Sequence)SequencesKt.map(context2.getMavenProjectsWithModules(), (Function1)beforeModelApplied.mavenProjectToModules.1.INSTANCE));
        Map shadedProjectsToRelocations2 = MapsKt.toMap((Sequence)SequencesKt.mapNotNull(context2.getMavenProjectsWithModules(), (Function1)((Function1)new Function1<MavenWorkspaceConfigurator.MavenProjectWithModules<ModuleEntity>, Pair<? extends MavenProject, ? extends Map<String, ? extends String>>>(this){
            final /* synthetic */ MavenShadePluginConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<MavenProject, Map<String, String>> invoke(@NotNull MavenWorkspaceConfigurator.MavenProjectWithModules<ModuleEntity> p) {
                Intrinsics.checkNotNullParameter(p, (String)"p");
                MavenProject mavenProject2 = p.getMavenProject();
                Map relocationMap = MavenShadePluginConfigurator.access$getRelocationMap(this.this$0, mavenProject2);
                return !relocationMap.isEmpty() ? TuplesKt.to((Object)mavenProject2, (Object)relocationMap) : null;
            }
        })));
        Set shadedProjects = shadedProjectsToRelocations2.keySet();
        if (shadedProjects.isEmpty()) {
            return;
        }
        Map shadedMavenProjectsToBuildUberJar = new LinkedHashMap();
        HashMap<ModuleId, MavenProject> moduleIdToMavenProject = new HashMap<ModuleId, MavenProject>();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules mavenProjectWithModules : context2.getMavenProjectsWithModules()) {
            for (Object module22 : mavenProjectWithModules.getModules()) {
                ((Map)moduleIdToMavenProject).put(((ModuleEntity)module22.getModule()).getSymbolicId(), mavenProjectWithModules.getMavenProject());
            }
        }
        Set set2 = moduleIdToMavenProject.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        module22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModuleId it = (ModuleId)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)shadedProjects, moduleIdToMavenProject.get(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List shadedModuleIds = (List)destination$iv$iv;
        for (ModuleEntity module3 : ((MutableEntityStorage)context2.getStorage()).entities(ModuleEntity.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = module3.getDependencies();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleDependency)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (ModuleDependency dependency : (List)destination$iv$iv2) {
                ModuleId dependencyModuleId = dependency.getModule();
                if (!shadedModuleIds.contains(dependencyModuleId)) continue;
                Object v = moduleIdToMavenProject.get(dependencyModuleId);
                Intrinsics.checkNotNull(v);
                MavenProject mavenProject2 = (MavenProject)v;
                String uberJarPath = this.getUberJarPath(mavenProject2);
                MutableEntityStorage mutableEntityStorage = (MutableEntityStorage)context2.getStorage();
                Project project2 = context2.getProject();
                MavenId mavenId2 = mavenProject2.getMavenId();
                Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"getMavenId(...)");
                this.addJarDependency(mutableEntityStorage, project2, module3, mavenId2, uberJarPath);
                if (shadedMavenProjectsToBuildUberJar.containsKey(mavenProject2)) continue;
                Object v2 = shadedProjectsToRelocations2.get(mavenProject2);
                Intrinsics.checkNotNull(v2);
                Map relocationMap = (Map)v2;
                Collection<MavenProject> dependentMavenProjects = this.collectDependentMavenProjects(mavenProject2, mavenProjectToModules2, moduleIdToMavenProject);
                shadedMavenProjectsToBuildUberJar.put(mavenProject2, new MavenProjectShadingData(relocationMap, uberJarPath, dependentMavenProjects));
            }
        }
        context2.putUserDataIfAbsent(MavenShadePluginConfiguratorKt.access$getSHADED_MAVEN_PROJECTS$p(), shadedMavenProjectsToBuildUberJar);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<MavenProject> collectDependentMavenProjects(MavenProject $this$collectDependentMavenProjects, Map<MavenProject, ? extends List<? extends ModuleEntity>> mavenProjectToModules2, HashMap<ModuleId, MavenProject> moduleIdToMavenProject) {
        Set dependentMavenProjects = new LinkedHashSet();
        List<? extends ModuleEntity> list = mavenProjectToModules2.get($this$collectDependentMavenProjects);
        Intrinsics.checkNotNull(list);
        List<? extends ModuleEntity> modules = list;
        for (ModuleEntity moduleEntity2 : modules) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = moduleEntity2.getDependencies();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDependencies = (List)destination$iv$iv;
            for (ModuleDependency moduleDependency : moduleDependencies) {
                MavenProject mavenProject2 = moduleIdToMavenProject.get(moduleDependency.getModule());
                MavenProject mavenProject3 = mavenProject2;
                if (mavenProject3 == null) continue;
                dependentMavenProjects.add(mavenProject3);
            }
        }
        return dependentMavenProjects;
    }

    private final Map<String, String> getRelocationMap(MavenProject $this$getRelocationMap) {
        Map map;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        List list;
        MavenPlugin mavenPlugin = $this$getRelocationMap.findPlugin("org.apache.maven.plugins", "maven-shade-plugin");
        return mavenPlugin != null && (list = mavenPlugin.getExecutions()) != null && (sequence4 = CollectionsKt.asSequence((Iterable)list)) != null && (sequence3 = SequencesKt.mapNotNull((Sequence)sequence4, (Function1)getRelocationMap.1.INSTANCE)) != null && (sequence2 = SequencesKt.flatMap((Sequence)sequence3, (Function1)getRelocationMap.2.INSTANCE)) != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence2, (Function1)((Function1)new Function1<Element, Pair<? extends String, ? extends String>>(this){
            final /* synthetic */ MavenShadePluginConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<String, String> invoke(Element it) {
                String pattern = it.getChildText("pattern");
                String shadedPattern = it.getChildText("shadedPattern");
                return pattern != null && shadedPattern != null ? TuplesKt.to((Object)MavenShadePluginConfigurator.access$replaceDots(this.this$0, pattern), (Object)MavenShadePluginConfigurator.access$replaceDots(this.this$0, shadedPattern)) : null;
            }
        }))) != null && (map = MapsKt.toMap((Sequence)sequence)) != null ? map : MapsKt.emptyMap();
    }

    private final String replaceDots(String $this$replaceDots) {
        return StringsKt.replace$default((String)$this$replaceDots, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    private final String getUberJarPath(MavenProject mavenProject2) {
        MavenId mavenId2 = mavenProject2.getMavenId();
        Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"getMavenId(...)");
        MavenId mavenId3 = mavenId2;
        String fileName = mavenId3.getArtifactId() + "-" + mavenId3.getVersion() + ".jar";
        String[] stringArray = new String[]{fileName};
        Path path2 = Path.of(mavenProject2.getBuildDirectory(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return ((Object)path2).toString();
    }

    private final void addJarDependency(MutableEntityStorage builder2, Project project2, ModuleEntity module2, MavenId dependencyMavenId, String dependencyJarPath) {
        String libraryName = "Maven Shade: " + dependencyMavenId.getDisplayString();
        LibraryId libraryId = new LibraryId(libraryName, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE);
        VirtualFileUrl jarUrl = WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager().getOrCreateFromUrl("jar://" + dependencyJarPath + "!/");
        this.addLibraryEntity(builder2, project2, libraryId, (Function0<? extends List<LibraryRoot>>)((Function0)new Function0<List<? extends LibraryRoot>>(jarUrl){
            final /* synthetic */ VirtualFileUrl $jarUrl;
            {
                this.$jarUrl = $jarUrl;
                super(0);
            }

            @NotNull
            public final List<LibraryRoot> invoke() {
                return CollectionsKt.listOf((Object)new LibraryRoot(this.$jarUrl, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
            }
        }));
        DependencyScope scope = DependencyScope.COMPILE;
        LibraryDependency libraryDependency = new LibraryDependency(libraryId, false, scope);
        ModuleEntityAndExtensions.modifyModuleEntity((MutableEntityStorage)builder2, (ModuleEntity)module2, (Function1)((Function1)new Function1<ModuleEntity.Builder, Unit>(libraryDependency){
            final /* synthetic */ LibraryDependency $libraryDependency;
            {
                this.$libraryDependency = $libraryDependency;
                super(1);
            }

            public final void invoke(@NotNull ModuleEntity.Builder $this$modifyModuleEntity) {
                Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
                $this$modifyModuleEntity.getDependencies().add(this.$libraryDependency);
            }
        }));
    }

    private final void addLibraryEntity(MutableEntityStorage builder2, Project project2, LibraryId libraryId, Function0<? extends List<LibraryRoot>> libraryRootsProvider2) {
        if (builder2.contains((SymbolicEntityId)libraryId)) {
            return;
        }
        EntitySource librarySource = LegacyBridgeJpsEntitySourceFactory.createEntitySourceForProjectLibrary$default((LegacyBridgeJpsEntitySourceFactory)LegacyBridgeJpsEntitySourceFactory.INSTANCE, (Project)project2, (ProjectModelExternalSource)this.externalSource, null, null, (int)12, null);
        builder2.addEntity((WorkspaceEntity.Builder)LibraryEntity.Companion.create$default((LibraryEntity.Companion)LibraryEntity.Companion, (String)libraryId.getName(), (LibraryTableId)libraryId.getTableId(), (List)((List)libraryRootsProvider2.invoke()), (EntitySource)librarySource, null, (int)16, null));
    }

    public static final /* synthetic */ Map access$getRelocationMap(MavenShadePluginConfigurator $this, MavenProject $receiver) {
        return $this.getRelocationMap($receiver);
    }

    public static final /* synthetic */ String access$replaceDots(MavenShadePluginConfigurator $this, String $receiver) {
        return $this.replaceDots($receiver);
    }
}

