/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.idea.maven.indices.MavenClassSearchResult;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.indices.searcher.MavenLuceneIndexer;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

public final class MavenClassSearcher
extends MavenSearcher<MavenClassSearchResult> {
    public static final String TERM = "c";

    @Override
    protected List<MavenClassSearchResult> searchImpl(Project project2, String pattern, int maxResult) {
        List<MavenRepositoryInfo> repos = MavenIndexUtils.getAllRepositories(project2);
        return MavenLuceneIndexer.getInstance().searchSync(pattern, repos, maxResult);
    }

    public static String preparePattern(String pattern) {
        if ((pattern = pattern.toLowerCase()).trim().isEmpty()) {
            return "";
        }
        List parts = StringUtil.split((String)pattern, (String)".");
        StringBuilder newPattern = new StringBuilder();
        for (int i2 = 0; i2 < parts.size() - 1; ++i2) {
            String each = (String)parts.get(i2);
            newPattern.append(each.trim());
            newPattern.append("*.");
        }
        String className = (String)parts.get(parts.size() - 1);
        boolean exactSearch = className.endsWith(" ");
        newPattern.append(className.trim());
        if (!exactSearch) {
            newPattern.append("*");
        }
        return newPattern.toString();
    }

    public static Collection<MavenClassSearchResult> processResults(Set<MavenArtifactInfo> infos, String pattern, int maxResult) {
        Pattern p;
        if (((String)pattern).isEmpty() || ((String)pattern).equals("*")) {
            pattern = "^/(.*)$";
        } else {
            int lastDot = ((String)(pattern = ((String)pattern).replace(".", "/"))).lastIndexOf("/");
            String packagePattern = lastDot == -1 ? "" : ((String)pattern).substring(0, lastDot) + "/";
            String classNamePattern = lastDot == -1 ? pattern : ((String)pattern).substring(lastDot + 1);
            packagePattern = packagePattern.replaceAll("\\*", ".*?");
            classNamePattern = classNamePattern.replaceAll("\\*", "[^/]*?");
            pattern = packagePattern + classNamePattern;
            pattern = ".*?/" + (String)pattern;
            pattern = "^(" + (String)pattern + ")$";
        }
        try {
            p = Pattern.compile((String)pattern, 10);
        }
        catch (PatternSyntaxException e) {
            return Collections.emptyList();
        }
        HashMap<String, MavenClassSearchResult> result2 = new HashMap<String, MavenClassSearchResult>();
        block2: for (MavenArtifactInfo each : infos) {
            if (each.getClassNames() == null) continue;
            Matcher matcher = p.matcher(each.getClassNames());
            while (matcher.find()) {
                String classFQName = matcher.group(1);
                classFQName = classFQName.replace("/", ".");
                String key = classFQName = StringUtil.trimStart((String)classFQName, (String)".");
                MavenClassSearchResult classResult = (MavenClassSearchResult)result2.get(key);
                if (classResult == null) {
                    int pos = classFQName.lastIndexOf(".");
                    artifactInfo = new MavenRepositoryArtifactInfo(each.getGroupId(), each.getArtifactId(), Collections.singletonList(each.getVersion()));
                    if (pos == -1) {
                        result2.put(key, new MavenClassSearchResult(artifactInfo, classFQName, "default package"));
                    } else {
                        result2.put(key, new MavenClassSearchResult(artifactInfo, classFQName.substring(pos + 1), classFQName.substring(0, pos)));
                    }
                } else {
                    List versions = ContainerUtil.append((List)ContainerUtil.map((Object[])classResult.getSearchResults().getItems(), i2 -> i2.getVersion()), (Object[])new String[]{each.getVersion()});
                    artifactInfo = new MavenRepositoryArtifactInfo(each.getGroupId(), each.getArtifactId(), (Collection)versions);
                    result2.put(key, new MavenClassSearchResult(artifactInfo, classResult.getClassName(), classResult.getPackageName()));
                }
                if (result2.size() <= maxResult) continue;
                continue block2;
            }
        }
        result2.values().forEach(a -> Arrays.sort(a.getSearchResults().getItems(), Comparator.comparing(MavenId::getVersion, VersionComparatorUtil.COMPARATOR).reversed()));
        return result2.values();
    }
}

