/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;

public final class MavenArtifactIndex {
    private static final MavenArtifactIndex EMPTY_INDEX = new MavenArtifactIndex(Collections.emptyMap());
    private final Map<String, Map<String, List<MavenArtifact>>> myData;

    private MavenArtifactIndex(Map<String, Map<String, List<MavenArtifact>>> data2) {
        this.myData = data2;
    }

    public Map<String, Map<String, List<MavenArtifact>>> getData() {
        return this.myData;
    }

    public boolean hasArtifact(@Nullable String groupId, @Nullable String artifactId) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            return false;
        }
        return groupMap.containsKey(artifactId);
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable String groupId, @Nullable String artifactId) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<MavenArtifact> res = groupMap.get(artifactId);
        List<Object> list = res == null ? Collections.emptyList() : res;
        if (list == null) {
            MavenArtifactIndex.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable MavenId mavenId2) {
        if (mavenId2 == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<MavenArtifact> list = this.findArtifacts(mavenId2.getGroupId(), mavenId2.getArtifactId(), mavenId2.getVersion());
        if (list == null) {
            MavenArtifactIndex.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public MavenArtifact findArtifacts(@NotNull DependencyConflictId id) {
        if (id == null) {
            MavenArtifactIndex.$$$reportNull$$$0(4);
        }
        for (MavenArtifact artifact : this.findArtifacts(id.getGroupId(), id.getArtifactId())) {
            if (!id.equals(DependencyConflictId.create(artifact))) continue;
            return artifact;
        }
        return null;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable String groupId, @Nullable String artifactId, @Nullable String version2) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<MavenArtifact> artifacts = groupMap.get(artifactId);
        if (artifacts == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList res = new SmartList();
        for (MavenArtifact artifact : artifacts) {
            if (!Objects.equals(version2, artifact.getVersion())) continue;
            res.add(artifact);
        }
        SmartList smartList = res;
        if (smartList == null) {
            MavenArtifactIndex.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    public static MavenArtifactIndex build(@NotNull List<? extends MavenArtifact> dependencies) {
        if (dependencies == null) {
            MavenArtifactIndex.$$$reportNull$$$0(8);
        }
        if (dependencies.isEmpty()) {
            return EMPTY_INDEX;
        }
        HashMap<String, Map<String, List<MavenArtifact>>> map = new HashMap<String, Map<String, List<MavenArtifact>>>();
        for (MavenArtifact mavenArtifact : dependencies) {
            List artifactList;
            String artifactId;
            String groupId = mavenArtifact.getGroupId();
            if (groupId == null || (artifactId = mavenArtifact.getArtifactId()) == null) continue;
            HashMap<String, List> groupMap = (HashMap<String, List>)map.get(groupId);
            if (groupMap == null) {
                groupMap = new HashMap<String, List>();
                map.put(groupId, groupMap);
            }
            if ((artifactList = (List)groupMap.get(artifactId)) == null) {
                artifactList = new SmartList();
                groupMap.put(artifactId, artifactList);
            }
            artifactList.add(mavenArtifact);
        }
        return new MavenArtifactIndex(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenArtifactIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenArtifactIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 8 -> new IllegalArgumentException(string);
        };
    }
}

