/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/project/actions/RemoveManagedFilesAction;", "Lorg/jetbrains/idea/maven/utils/actions/MavenAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isVisible", "", "Companion", "intellij.maven"})
public final class RemoveManagedFilesAction
extends MavenAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!super.isVisible(e)) {
            return false;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context2 = dataContext;
        Project project2 = MavenActionUtil.getProject(context2);
        if (project2 == null) {
            return false;
        }
        List<VirtualFile> selectedFiles = MavenActionUtil.getMavenProjectsFiles(context2);
        if (selectedFiles.size() == 0) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        Iterator<VirtualFile> iterator = selectedFiles.iterator();
        while (iterator.hasNext()) {
            VirtualFile pomXml;
            VirtualFile virtualFile = pomXml = iterator.next();
            Intrinsics.checkNotNull((Object)virtualFile);
            MavenProject mavenProject2 = projectsManager.findProject(virtualFile);
            if (mavenProject2 == null) {
                return false;
            }
            MavenProject aggregator = projectsManager.findAggregator(mavenProject2);
            while (aggregator != null && !projectsManager.isManagedFile(aggregator.getFile())) {
                aggregator = projectsManager.findAggregator(aggregator);
            }
            if (aggregator == null || selectedFiles.contains(aggregator.getFile())) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context2 = dataContext;
        Project project2 = MavenActionUtil.getProject(context2);
        if (project2 == null) {
            return;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        List<VirtualFile> selectedFiles = MavenActionUtil.getMavenProjectsFiles(context2);
        projectsManager.removeManagedFiles(selectedFiles, arg_0 -> RemoveManagedFilesAction.actionPerformed$lambda$0(projectsManager, selectedFiles, context2, arg_0), RemoveManagedFilesAction::actionPerformed$lambda$1);
    }

    private static final void actionPerformed$lambda$0(MavenProjectsManager $projectsManager, List $selectedFiles, DataContext $context, MavenProject mavenProject2) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        if (mavenProject2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        MavenProject aggregator = $projectsManager.findAggregator(mavenProject2);
        while (aggregator != null && !$projectsManager.isManagedFile(aggregator.getFile())) {
            aggregator = $projectsManager.findAggregator(aggregator);
        }
        if (aggregator != null && !$selectedFiles.contains(aggregator.getFile())) {
            RemoveManagedFilesAction.Companion.notifyUser($context, mavenProject2, aggregator);
        }
    }

    private static final boolean actionPerformed$lambda$1(List names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        Object[] objectArray = new Object[]{"Maven", names.size(), names};
        int returnCode = Messages.showOkCancelDialog((String)ExternalSystemBundle.message((String)"action.detach.external.confirmation.prompt", (Object[])objectArray), (String)RemoveManagedFilesAction.Companion.getActionTitle(names), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        return returnCode == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/project/actions/RemoveManagedFilesAction$Companion;", "", "()V", "getActionTitle", "", "Lorg/jetbrains/annotations/Nls;", "names", "", "notifyUser", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "aggregator", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final String getActionTitle(List<String> names) {
            Object[] objectArray = new Object[]{"Maven"};
            return StringUtil.pluralize((String)ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])objectArray), (int)names.size());
        }

        private final void notifyUser(DataContext context2, MavenProject mavenProject2, MavenProject aggregator) {
            String aggregatorDescription = " (" + aggregator.getMavenId().getDisplayString() + ")";
            Object[] objectArray = new Object[]{mavenProject2.getDisplayName(), aggregatorDescription};
            Notification notification = new Notification("Maven", MavenProjectBundle.message("maven.module.remove.failed", new Object[0]), MavenProjectBundle.message("maven.module.remove.failed.explanation", objectArray), NotificationType.ERROR);
            notification.setImportant(true);
            notification.notify(MavenActionUtil.getProject(context2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

