/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.util.containers.HashingStrategy;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public abstract class GitReference
implements Comparable<GitReference> {
    public static final HashingStrategy<String> BRANCH_NAME_HASHING_STRATEGY = SystemInfoRt.isFileSystemCaseSensitive ? HashingStrategy.canonical() : HashingStrategy.caseInsensitive();
    public static final Comparator<@NotNull String> REFS_NAMES_COMPARATOR = (name1, name2) -> {
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        return NaturalComparator.naturalCompare((String)name1, (String)name2, (boolean)ignoreCase, (boolean)false);
    };
    @NotNull
    protected final String myName;

    public GitReference(@NotNull String name) {
        if (name == null) {
            GitReference.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GitReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public abstract String getFullName();

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitReference reference = (GitReference)o;
        return BRANCH_NAME_HASHING_STRATEGY.equals((Object)this.myName, (Object)reference.myName);
    }

    public int hashCode() {
        return BRANCH_NAME_HASHING_STRATEGY.hashCode((Object)this.myName);
    }

    @Override
    public int compareTo(GitReference o) {
        return o == null ? 1 : REFS_NAMES_COMPARATOR.compare(this.getFullName(), o.getFullName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

