/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitDownloadAndInstallKt;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0000\u00a2\u0006\u0002\b\rJ&\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J&\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lgit4idea/config/WindowsExecutableProblemHandler;", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "downloadAndInstall", "", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "onErrorResolved", "Lkotlin/Function0;", "downloadAndInstall$intellij_vcs_git", "installGit", "exeFile", "Ljava/io/File;", "showError", "exception", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nWindowsExecutableProblemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsExecutableProblemHandler.kt\ngit4idea/config/WindowsExecutableProblemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n13#2:76\n*S KotlinDebug\n*F\n+ 1 WindowsExecutableProblemHandler.kt\ngit4idea/config/WindowsExecutableProblemHandler\n*L\n17#1:76\n*E\n"})
public final class WindowsExecutableProblemHandler
implements GitExecutableProblemHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public WindowsExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        String string = GitBundle.message("executable.error.git.not.installed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitExecutableProblemHandlersKt.getHumanReadableErrorFor(exception);
        String string3 = GitBundle.message("install.download.and.install.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        errorNotifier.showError(string, string2, new ErrorNotifier.FixOption.Standard(string3, (Function0<Unit>)((Function0)new Function0<Unit>(this, errorNotifier, onErrorResolved){
            final /* synthetic */ WindowsExecutableProblemHandler this$0;
            final /* synthetic */ ErrorNotifier $errorNotifier;
            final /* synthetic */ Function0<Unit> $onErrorResolved;
            {
                this.this$0 = $receiver;
                this.$errorNotifier = $errorNotifier;
                this.$onErrorResolved = $onErrorResolved;
                super(0);
            }

            public final void invoke() {
                this.this$0.downloadAndInstall$intellij_vcs_git(this.$errorNotifier, this.$onErrorResolved);
            }
        })));
    }

    public final void downloadAndInstall$intellij_vcs_git(@NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        String string = GitBundle.message("install.downloading.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.executeTask(string, true, (Function0<Unit>)((Function0)new Function0<Unit>(errorNotifier, this, onErrorResolved){
            final /* synthetic */ ErrorNotifier $errorNotifier;
            final /* synthetic */ WindowsExecutableProblemHandler this$0;
            final /* synthetic */ Function0<Unit> $onErrorResolved;
            {
                this.$errorNotifier = $errorNotifier;
                this.this$0 = $receiver;
                this.$onErrorResolved = $onErrorResolved;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                GitInstaller installer2 = GitDownloadAndInstallKt.fetchInstaller(this.$errorNotifier, (Function1<? super GitInstaller, Boolean>)((Function1)downloadAndInstall.installer.1.INSTANCE));
                if (installer2 != null) {
                    String fileName = installer2.getFileName();
                    File exeFile = new File(PathManager.getTempPath(), fileName);
                    try {
                        if (GitDownloadAndInstallKt.downloadGit(installer2, exeFile, this.this$0.getProject(), this.$errorNotifier)) {
                            String string = GitBundle.message("install.installing.progress", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.$errorNotifier.changeProgressTitle(string);
                            WindowsExecutableProblemHandler.access$installGit(this.this$0, exeFile, this.$errorNotifier, this.$onErrorResolved);
                        }
                    }
                    finally {
                        FileUtil.delete((File)exeFile);
                    }
                }
            }
        }));
    }

    private final void installGit(File exeFile, ErrorNotifier errorNotifier, Function0<Unit> onErrorResolved) {
        String[] stringArray = new String[]{"/verysilent"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(exeFile.getPath()).withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            if (!output.checkSuccess(LOG)) {
                String string = GitBundle.message("install.general.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
            } else {
                LOG.info("Installed Git. " + GitExecutableProblemHandlersKt.dumpToString(output));
                String string = GitBundle.message("install.success.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                errorNotifier.showMessage(string);
                errorNotifier.resetGitExecutable();
                onErrorResolved.invoke();
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't run " + commandLine);
            String string = GitBundle.message("install.general.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
        }
    }

    public static final /* synthetic */ void access$installGit(WindowsExecutableProblemHandler $this, File exeFile, ErrorNotifier errorNotifier, Function0 onErrorResolved) {
        $this.installGit(exeFile, errorNotifier, (Function0<Unit>)onErrorResolved);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WindowsExecutableProblemHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/config/WindowsExecutableProblemHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "archMatches", "", "arch", "", "archMatches$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean archMatches$intellij_vcs_git(@NotNull String arch) {
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            CpuArch cpuArch = CpuArch.CURRENT;
            return switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
                case 1 -> Intrinsics.areEqual((Object)arch, (Object)"x86_32");
                case 2 -> Intrinsics.areEqual((Object)arch, (Object)"x86_64");
                default -> false;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CpuArch.values().length];
                try {
                    nArray[CpuArch.X86.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CpuArch.X86_64.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

