/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import git4idea.history.GitCompressedRecord;
import git4idea.history.GitLogRecordCollector;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class GitLogUnorderedRecordCollector
extends GitLogRecordCollector<GitCompressedRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogUnorderedRecordCollector.class);
    private static final int STATUS_LINES_THRESHOLD = 200000;
    @NotNull
    private final MultiMap<String, GitCompressedRecord> myHashToIncompleteRecords;
    private int myIncompleteStatusLinesCount;

    GitLogUnorderedRecordCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super List<GitCompressedRecord>> consumer2) {
        if (project == null) {
            GitLogUnorderedRecordCollector.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogUnorderedRecordCollector.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            GitLogUnorderedRecordCollector.$$$reportNull$$$0(2);
        }
        super(project, root, consumer2);
        this.myHashToIncompleteRecords = MultiMap.createLinked();
        this.myIncompleteStatusLinesCount = 0;
    }

    @Override
    protected void processCollectedRecords() {
        this.processCollectedRecords(false);
    }

    private void processCollectedRecords(boolean processIncompleteRecords) {
        super.processCollectedRecords();
        if (!this.myHashToIncompleteRecords.isEmpty() && (processIncompleteRecords || this.myIncompleteStatusLinesCount >= 200000)) {
            try {
                this.processIncompleteRecords(this.myHashToIncompleteRecords, this.myProject, this.myRoot, this.myConsumer);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myHashToIncompleteRecords.clear();
                this.myIncompleteStatusLinesCount = 0;
            }
        }
    }

    @Override
    protected void processIncompleteRecord(@NotNull String hash, @NotNull List<GitCompressedRecord> records) {
        if (hash == null) {
            GitLogUnorderedRecordCollector.$$$reportNull$$$0(3);
        }
        if (records == null) {
            GitLogUnorderedRecordCollector.$$$reportNull$$$0(4);
        }
        this.myHashToIncompleteRecords.put((Object)hash, records);
        records.forEach(r -> this.myIncompleteStatusLinesCount += r.getChanges().size() + r.getRenames().size());
    }

    @Override
    protected GitCompressedRecord createEmptyCopy(@NotNull GitCompressedRecord record) {
        if (record == null) {
            GitLogUnorderedRecordCollector.$$$reportNull$$$0(5);
        }
        return new GitCompressedRecord(record.getOptions(), (Int2ObjectMap<Change.Type>)new Int2ObjectOpenHashMap(), (Int2IntMap)new Int2IntOpenHashMap(), record.isSupportsRawBody());
    }

    @Override
    public void finish() {
        this.processCollectedRecords(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
        }
        objectArray2[1] = "git4idea/history/GitLogUnorderedRecordCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processIncompleteRecord";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createEmptyCopy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

