/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitUntrackedDirtyScopeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    public static final Comparator<GitRepository> DEPENDENCY_COMPARATOR = (repo1, repo2) -> -VirtualFileHierarchicalComparator.getInstance().compare(repo1.getRoot(), repo2.getRoot());
    private final ExecutorService myUpdateExecutor;
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    public GitRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(0);
        }
        super(project, GitVcs.getKey(), ".git");
        this.myUpdateExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"GitRepositoryManager");
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)new GitUntrackedDirtyScopeListener(this), (Disposable)this);
    }

    @NotNull
    public static GitRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(1);
        }
        GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)((Object)project.getService(GitRepositoryManager.class));
        if (gitRepositoryManager == null) {
            GitRepositoryManager.$$$reportNull$$$0(2);
        }
        return gitRepositoryManager;
    }

    public boolean isSyncEnabled() {
        return GitVcsSettings.getInstance(this.getVcs().getProject()).getSyncSetting() == DvcsSyncSettings.Value.SYNC && !MultiRootBranches.diverged(this.getRepositories());
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        List list2 = this.getRepositories(GitRepository.class);
        if (list2 == null) {
            GitRepositoryManager.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public boolean shouldProposeSyncControl() {
        return !this.thereAreSubmodulesInProject() && super.shouldProposeSyncControl();
    }

    private boolean thereAreSubmodulesInProject() {
        return this.getRepositories().stream().anyMatch(repo2 -> !repo2.getSubmodules().isEmpty());
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }

    void notifyListenersAsync(@NotNull GitRepository repository) {
        if (repository == null) {
            GitRepositoryManager.$$$reportNull$$$0(4);
        }
        this.myUpdateExecutor.execute(() -> {
            if (!Disposer.isDisposed((Disposable)repository)) {
                ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), GitRepository.GIT_REPO_CHANGE)).repositoryChanged(repository);
            }
        });
    }

    @NotNull
    public List<GitRepository> sortByDependency(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitRepositoryManager.$$$reportNull$$$0(5);
        }
        List list2 = ContainerUtil.sorted(repositories2, DEPENDENCY_COMPARATOR);
        if (list2 == null) {
            GitRepositoryManager.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sortByDependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

