/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitLocalBranch;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitRepositoryUpdater
implements Disposable,
AsyncVfsEventsListener {
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final Collection<VirtualFile> myRootDirs;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final VirtualFile myRemotesDir;
    @Nullable
    private final VirtualFile myHeadsDir;
    @Nullable
    private final VirtualFile myTagsDir;
    @NotNull
    private final Set<LocalFileSystem.WatchRequest> myWatchRequests;

    GitRepositoryUpdater(@NotNull GitRepository repository, @NotNull GitRepositoryFiles gitFiles) {
        if (repository == null) {
            GitRepositoryUpdater.$$$reportNull$$$0(0);
        }
        if (gitFiles == null) {
            GitRepositoryUpdater.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
        this.myRootDirs = gitFiles.getRootDirs();
        this.myWatchRequests = LocalFileSystem.getInstance().addRootsToWatch((Collection)ContainerUtil.map(this.myRootDirs, VirtualFile::getPath), true);
        this.myRepositoryFiles = gitFiles;
        this.visitSubDirsInVfs();
        this.myHeadsDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsHeadsFile());
        this.myRemotesDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsRemotesFile());
        this.myTagsDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsTagsFile());
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)this);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
    }

    public void filesChanged(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            GitRepositoryUpdater.$$$reportNull$$$0(2);
        }
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        boolean configChanged = false;
        boolean indexChanged = false;
        boolean headChanged = false;
        boolean headMoved = false;
        boolean branchFileChanged = false;
        boolean currentBranchChanged = false;
        boolean packedRefsChanged = false;
        boolean rebaseFileChanged = false;
        boolean mergeFileChanged = false;
        boolean externallyCommitted = false;
        boolean tagChanged = false;
        boolean gitignoreChanged = false;
        HashSet toReloadVfs = new HashSet();
        for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            if (this.isRootDirChange(vFileEvent)) {
                if (this.myRepositoryFiles.isConfigFile(filePath)) {
                    configChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isIndexFile(filePath)) {
                    indexChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isHeadFile(filePath)) {
                    headChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isOrigHeadFile(filePath)) {
                    headMoved = true;
                    continue;
                }
                if (this.myRepositoryFiles.isBranchFile(filePath)) {
                    branchFileChanged = true;
                    ContainerUtil.addIfNotNull(toReloadVfs, (Object)this.myHeadsDir);
                    if (currentBranch == null || !this.myRepositoryFiles.isBranchFile(filePath, currentBranch.getFullName())) continue;
                    currentBranchChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isRemoteBranchFile(filePath)) {
                    branchFileChanged = true;
                    ContainerUtil.addIfNotNull(toReloadVfs, (Object)this.myRemotesDir);
                    continue;
                }
                if (this.myRepositoryFiles.isPackedRefs(filePath)) {
                    packedRefsChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                    rebaseFileChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isMergeFile(filePath)) {
                    mergeFileChanged = true;
                    continue;
                }
                if (this.myRepositoryFiles.isCommitMessageFile(filePath)) {
                    externallyCommitted = true;
                    continue;
                }
                if (this.myRepositoryFiles.isTagFile(filePath)) {
                    tagChanged = true;
                    ContainerUtil.addIfNotNull(toReloadVfs, (Object)this.myTagsDir);
                    continue;
                }
                if (!this.myRepositoryFiles.isExclude(filePath)) continue;
                gitignoreChanged = true;
                continue;
            }
            if (!filePath.endsWith(".gitignore")) continue;
            gitignoreChanged = true;
        }
        for (VirtualFile virtualFile : toReloadVfs) {
            VfsUtilCore.processFilesRecursively((VirtualFile)virtualFile, (Processor)CommonProcessors.alwaysTrue());
        }
        if (headChanged || configChanged || branchFileChanged || packedRefsChanged || rebaseFileChanged || mergeFileChanged) {
            this.myRepository.update();
        }
        if (tagChanged || packedRefsChanged) {
            this.myRepository.getTagHolder().reload();
            ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)this.myRepository.getProject(), GitRepository.GIT_REPO_CHANGE)).repositoryChanged(this.myRepository);
        }
        if (configChanged) {
            ((GitConfigListener)BackgroundTaskUtil.syncPublisher((Project)this.myRepository.getProject(), GitConfigListener.TOPIC)).notifyConfigChanged(this.myRepository);
        }
        if (indexChanged || externallyCommitted || headMoved || headChanged || currentBranchChanged || gitignoreChanged) {
            VcsDirtyScopeManager.getInstance((Project)this.myRepository.getProject()).dirDirtyRecursively(this.myRepository.getRoot());
            this.myRepository.getUntrackedFilesHolder().invalidate();
        }
        if (indexChanged) {
            GitIndexFileSystemRefresher.refreshRoots(this.myRepository.getProject(), Collections.singletonList(this.myRepository.getRoot()));
        }
    }

    private boolean isRootDirChange(@NotNull VFileEvent event) {
        VirtualFile file2;
        if (event == null) {
            GitRepositoryUpdater.$$$reportNull$$$0(3);
        }
        if ((file2 = event.getFile()) == null) {
            return true;
        }
        for (VirtualFile dir : this.myRootDirs) {
            if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void visitSubDirsInVfs() {
        for (VirtualFile rootDir : this.myRepositoryFiles.getRootDirs()) {
            rootDir.getChildren();
        }
        for (String path : this.myRepositoryFiles.getPathsToWatch()) {
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "git4idea/repo/GitRepositoryUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filesChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRootDirChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

