/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitTag;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchSyncStatus;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitCurrentBranchPresenter;
import icons.DvcsImplIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0004H\u0002\u001a\u0013\u0010\t\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\n*\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"calcText", "", "Lcom/intellij/openapi/util/NlsSafe;", "repository", "Lgit4idea/repo/GitRepository;", "getDefaultPresentation", "Lgit4idea/ui/branch/GitCurrentBranchPresenter$Presentation;", "calcIcon", "Ljavax/swing/Icon;", "calcTooltip", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.vcs.git"})
public final class GitCurrentBranchPresenterKt {
    private static final GitCurrentBranchPresenter.Presentation getDefaultPresentation(GitRepository repository) {
        return new GitCurrentBranchPresenter.PresentationData(GitCurrentBranchPresenterKt.calcIcon(repository), GitCurrentBranchPresenterKt.calcText(repository), GitCurrentBranchPresenterKt.calcTooltip(repository), GitBranchSyncStatus.Companion.calcForCurrentBranch(repository));
    }

    private static final String calcText(GitRepository repository) {
        String string = StringUtil.escapeMnemonics((String)GitBranchUtil.getDisplayableBranchText(repository, arg_0 -> GitCurrentBranchPresenterKt.calcText$lambda$0(repository, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeMnemonics(...)");
        return string;
    }

    private static final Icon calcIcon(GitRepository $this$calcIcon) {
        if ($this$calcIcon.getState() == Repository.State.NORMAL) {
            return null;
        }
        if ($this$calcIcon.getState() == Repository.State.DETACHED && GitRefUtil.getCurrentReference($this$calcIcon) instanceof GitTag) {
            return DvcsImplIcons.BranchLabel;
        }
        return AllIcons.General.Warning;
    }

    /*
     * WARNING - void declaration
     */
    private static final String calcTooltip(GitRepository $this$calcTooltip) {
        String string;
        GitRepoInfo gitRepoInfo = $this$calcTooltip.getInfo();
        Intrinsics.checkNotNullExpressionValue((Object)gitRepoInfo, (String)"getInfo(...)");
        GitRepoInfo repoInfo = gitRepoInfo;
        if (repoInfo.getState() == Repository.State.DETACHED) {
            string = GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
        } else if (repoInfo.getState() == Repository.State.REBASING) {
            string = GitBundle.message("git.status.bar.widget.tooltip.rebasing", new Object[0]);
        } else if (repoInfo.getCurrentBranch() != null) {
            void var2_3;
            Object[] objectArray = new Object[]{GitVcs.DISPLAY_NAME.get(), repoInfo.getCurrentBranch().getName()};
            String string2 = DvcsBundle.message((String)"tooltip.branch.widget.vcs.branch.name.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Object message = string2;
            if (!GitUtil.justOneGitRepository($this$calcTooltip.getProject())) {
                message = (String)message + "\n";
                Object[] objectArray2 = new Object[]{$this$calcTooltip.getRoot().getName()};
                message = (String)message + DvcsBundle.message((String)"tooltip.branch.widget.root.name.text", (Object[])objectArray2);
            }
            string = var2_3;
        } else {
            string = null;
        }
        return string;
    }

    private static final String calcText$lambda$0(GitRepository $repository, String branchName) {
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        return GitBranchPopupActions.truncateBranchName($repository.getProject(), branchName, 80, 5, 4);
    }

    public static final /* synthetic */ GitCurrentBranchPresenter.Presentation access$getDefaultPresentation(GitRepository repository) {
        return GitCurrentBranchPresenterKt.getDefaultPresentation(repository);
    }
}

