/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.collection.AbstractIterator;
import javaslang.collection.HashMap;
import javaslang.collection.HashSet;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Seq;
import javaslang.collection.Traversable;
import javaslang.control.Option;

final class Collections {
    Collections() {
    }

    static <C extends Traversable<T>, T> C removeAll(C collection, T element3) {
        Objects.requireNonNull(element3, "element is null");
        return Collections.removeAll(collection, List.of(element3));
    }

    static <C extends Traversable<T>, T> C removeAll(C collection, Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        HashSet removed = HashSet.ofAll(elements2);
        return (C)collection.filter(e -> !removed.contains(e));
    }

    static <C extends Traversable<T>, T> C retainAll(C collection, Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        HashSet<? extends T> removed = HashSet.ofAll(elements2);
        return (C)collection.filter(removed::contains);
    }

    public static <T, C, R extends Iterable<T>> Map<C, R> groupBy(Traversable<T> collection, Function<? super T, ? extends C> classifier, Function<? super Iterable<T>, R> mapper2) {
        Objects.requireNonNull(collection, "collection is null");
        Objects.requireNonNull(classifier, "classifier is null");
        Objects.requireNonNull(mapper2, "mapper is null");
        java.util.HashMap<Object, Collection> mutableResults = new java.util.HashMap<Object, Collection>();
        for (Object value2 : collection) {
            C key = classifier.apply(value2);
            mutableResults.computeIfAbsent(key, k -> new ArrayList()).add(value2);
        }
        Map results2 = HashMap.empty();
        for (Map.Entry entry : mutableResults.entrySet()) {
            results2 = results2.put(entry.getKey(), mapper2.apply(entry.getValue()));
        }
        return results2;
    }

    static Option<Integer> indexOption(int index) {
        return Option.when(index >= 0, index);
    }

    static boolean equals(Iterable<?> iterable1, Iterable<?> iterable2) {
        java.util.Iterator<?> iter1 = iterable1.iterator();
        java.util.Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    static int hash(Iterable<?> iterable) {
        int hashCode = 1;
        for (Object o : iterable) {
            hashCode = 31 * hashCode + Objects.hashCode(o);
        }
        return hashCode;
    }

    static <T, U, C extends Iterable<U>, R extends Traversable<U>> R scanLeft(Iterable<? extends T> elements2, U zero, BiFunction<? super U, ? super T, ? extends U> operation2, C cumulativeResult, BiFunction<C, U, C> combiner, Function<C, R> finisher) {
        U acc = zero;
        cumulativeResult = (Iterable)combiner.apply(cumulativeResult, acc);
        for (T a : elements2) {
            acc = operation2.apply(acc, a);
            cumulativeResult = (Iterable)combiner.apply(cumulativeResult, acc);
        }
        return (R)((Traversable)finisher.apply(cumulativeResult));
    }

    static <T, U, C extends Iterable<U>, R extends Traversable<U>> R scanRight(Iterable<? extends T> elements2, U zero, BiFunction<? super T, ? super U, ? extends U> operation2, C cumulativeResult, BiFunction<C, U, C> combiner, Function<C, R> finisher) {
        Iterator<? extends T> reversedElements = Collections.seq(elements2).reverseIterator();
        return Collections.scanLeft(reversedElements, zero, (u, t) -> operation2.apply(t, u), cumulativeResult, combiner, finisher);
    }

    static <T, S extends Seq<T>> Iterator<S> crossProduct(S empty, S seq, int power) {
        if (power < 0) {
            throw new IllegalArgumentException("negative power");
        }
        return Iterator.range(0, power).foldLeft(Iterator.of(empty), (product, ignored) -> product.flatMap(el -> seq.map(t -> el.append(t))));
    }

    static <C extends Traversable<T>, T> C tabulate(int n, Function<? super Integer, ? extends T> f2, C empty, Function<T[], C> of2) {
        Objects.requireNonNull(f2, "f is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of2, "of is null");
        if (n <= 0) {
            return empty;
        }
        Object[] elements2 = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            elements2[i2] = f2.apply(i2);
        }
        return (C)((Traversable)of2.apply((Object[][])elements2));
    }

    static <C extends Traversable<T>, T> C fill(int n, Supplier<? extends T> s, C empty, Function<T[], C> of2) {
        Objects.requireNonNull(s, "s is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of2, "of is null");
        return Collections.tabulate(n, anything -> s.get(), empty, of2);
    }

    static <T> Iterator<T> tabulate(final int n, final Function<? super Integer, ? extends T> f2) {
        Objects.requireNonNull(f2, "f is null");
        if (n <= 0) {
            return Iterator.empty();
        }
        return new AbstractIterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            protected T getNext() {
                return f2.apply(this.i++);
            }
        };
    }

    static <T> Iterator<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.tabulate(n, anything -> s.get());
    }

    private static <T> Seq<T> seq(Iterable<? extends T> iterable) {
        if (iterable instanceof Seq) {
            return (Seq)iterable;
        }
        return List.ofAll(iterable);
    }
}

