/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match.model;

import java.util.List;
import java.util.stream.Collectors;
import javaslang.match.model.MethodModel;
import javaslang.match.model.TypeParameterModel;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class ClassModel {
    private final Elements elementUtils;
    private final DeclaredType declaredType;

    public static ClassModel of(Elements elementUtils, TypeElement typeElement2) {
        return new ClassModel(elementUtils, (DeclaredType)typeElement2.asType());
    }

    public ClassModel(Elements elementUtils, DeclaredType declaredType) {
        this.elementUtils = elementUtils;
        this.declaredType = declaredType;
    }

    public TypeElement typeElement() {
        return (TypeElement)this.declaredType.asElement();
    }

    public String getClassName() {
        String fqn2 = this.getFullQualifiedName();
        return this.hasDefaultPackage() ? fqn2 : fqn2.substring(this.getPackageName().length() + 1);
    }

    public String getFullQualifiedName() {
        return this.typeElement().getQualifiedName().toString();
    }

    public List<MethodModel> getMethods() {
        return this.typeElement().getEnclosedElements().stream().filter(element3 -> {
            String name2 = element3.getSimpleName().toString();
            return element3 instanceof ExecutableElement && !name2.isEmpty() && !"<init>".equals(name2) && !"<clinit>".equals(name2);
        }).map(element3 -> new MethodModel(this.elementUtils, (ExecutableElement)element3)).collect(Collectors.toList());
    }

    public String getPackageName() {
        return this.elementUtils.getPackageOf(this.typeElement()).getQualifiedName().toString();
    }

    public List<TypeParameterModel> getTypeParameters() {
        return this.declaredType.getTypeArguments().stream().map(typeMirror -> new TypeParameterModel(this.elementUtils, (TypeMirror)typeMirror)).collect(Collectors.toList());
    }

    public boolean hasDefaultPackage() {
        return this.elementUtils.getPackageOf(this.typeElement()).isUnnamed();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ClassModel && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.declaredType.toString();
    }
}

