/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplColors;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.console.gutter.ConsoleErrorRenderer;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020$J\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020$J$\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u000e\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020$J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020$J\u000e\u00103\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020$J\u0018\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "historyDocument", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "Lorg/jetbrains/annotations/NotNull;", "historyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "historyMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "project", "Lcom/intellij/openapi/project/Project;", "getAttributesForSeverity", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "insightColors", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "start", "", "end", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "highlightCompilerErrors", "", "compilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "printBuildInfoWarningIfNeeded", "printHelp", "help", "", "printInitialPrompt", "command", "printInternalErrorMessage", "internalErrorText", "printOutput", "output", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "iconWithTooltip", "Lorg/jetbrains/kotlin/console/gutter/IconWithTooltip;", "printResultWithGutterIcon", "result", "printRuntimeError", "errorText", "printUserOutput", "printWarningMessage", "message", "isAddHyperlink", "", "kotlin.repl"})
@SourceDebugExtension(value={"SMAP\nReplOutputProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplOutputProcessor.kt\norg/jetbrains/kotlin/console/ReplOutputProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,175:1\n1#2:176\n73#3:177\n1109#4,2:178\n766#5:180\n857#5,2:181\n1477#5:183\n1502#5,3:184\n1505#5,3:194\n1549#5:197\n1620#5,2:198\n1549#5:200\n1620#5,3:201\n1622#5:204\n372#6,7:187\n*S KotlinDebug\n*F\n+ 1 ReplOutputProcessor.kt\norg/jetbrains/kotlin/console/ReplOutputProcessor\n*L\n66#1:177\n99#1:178,2\n103#1:180\n103#1:181,2\n105#1:183\n105#1:184,3\n105#1:194,3\n108#1:197\n108#1:198,2\n109#1:200\n109#1:201,3\n108#1:204\n105#1:187,7\n*E\n"})
public final class ReplOutputProcessor {
    @NotNull
    private final KotlinConsoleRunner runner;
    @NotNull
    private final Project project;
    @NotNull
    private final LanguageConsoleImpl consoleView;
    @NotNull
    private final EditorEx historyEditor;
    @NotNull
    private final DocumentEx historyDocument;
    @NotNull
    private final MarkupModelEx historyMarkup;

    public ReplOutputProcessor(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        Project project2 = this.runner.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
        LanguageConsoleView languageConsoleView = this.runner.getConsoleView();
        Intrinsics.checkNotNull((Object)languageConsoleView, (String)"null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
        this.consoleView = (LanguageConsoleImpl)languageConsoleView;
        EditorEx editorEx = this.consoleView.getHistoryViewer();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getHistoryViewer(...)");
        this.historyEditor = editorEx;
        DocumentEx documentEx = this.historyEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.historyDocument = documentEx;
        MarkupModelEx markupModelEx = this.historyEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        this.historyMarkup = markupModelEx;
    }

    private final void printOutput(String output, ConsoleViewContentType contentType, IconWithTooltip iconWithTooltip) {
        RangeHighlighter rangeHighlighter;
        this.consoleView.flushDeferredText();
        int startOffset = this.historyDocument.getTextLength();
        this.consoleView.print(output, contentType);
        this.consoleView.flushDeferredText();
        int endOffset2 = this.historyDocument.getTextLength();
        if (iconWithTooltip == null) {
            return;
        }
        RangeHighlighter $this$printOutput_u24lambda_u240 = rangeHighlighter = this.historyMarkup.addRangeHighlighter(startOffset, endOffset2, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        boolean bl = false;
        $this$printOutput_u24lambda_u240.setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer(iconWithTooltip));
    }

    static /* synthetic */ void printOutput$default(ReplOutputProcessor replOutputProcessor, String string, ConsoleViewContentType consoleViewContentType, IconWithTooltip iconWithTooltip, int n, Object object) {
        if ((n & 4) != 0) {
            iconWithTooltip = null;
        }
        replOutputProcessor.printOutput(string, consoleViewContentType, iconWithTooltip);
    }

    private final void printWarningMessage(String message2, boolean isAddHyperlink) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.printWarningMessage$lambda$2(this, message2, isAddHyperlink));
    }

    public final void printBuildInfoWarningIfNeeded() {
        boolean $i$f$isUnitTestMode2 = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.runner.getPreviousCompilationFailed$kotlin_repl()) {
            Object[] $i$f$isUnitTestMode2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.runner.getModule().getName(), (String)"getName(...)");
            this.printWarningMessage(KotlinIdeaReplBundle.message("there.were.compilation.errors.in.module.0", $i$f$isUnitTestMode2), false);
            return;
        }
        if (this.runner.getCompilerHelper().moduleIsUpToDate()) {
            return;
        }
        String compilerWarningMessage = KotlinIdeaReplBundle.message("you.re.running.the.repl.with.outdated.classes", new Object[0]);
        this.printWarningMessage(compilerWarningMessage, true);
    }

    public final void printInitialPrompt(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        this.consoleView.print(command2, ReplColors.INSTANCE.getINITIAL_PROMPT_CONTENT_TYPE());
    }

    public final void printHelp(@NotNull String help) {
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.printHelp$lambda$3(this, help));
    }

    public final void printUserOutput(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.printUserOutput$lambda$4(this, command2));
    }

    public final void printResultWithGutterIcon(@NotNull String result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.printResultWithGutterIcon$lambda$5(this, result2));
    }

    public final void highlightCompilerErrors(@NotNull List<SeverityDetails> compilerMessages) {
        Intrinsics.checkNotNullParameter(compilerMessages, (String)"compilerMessages");
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.highlightCompilerErrors$lambda$11(this, compilerMessages));
    }

    public final void printRuntimeError(@NotNull String errorText) {
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.printRuntimeError$lambda$12(this, errorText));
    }

    public final void printInternalErrorMessage(@NotNull String internalErrorText) {
        Intrinsics.checkNotNullParameter((Object)internalErrorText, (String)"internalErrorText");
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ReplOutputProcessor.printInternalErrorMessage$lambda$13(this, internalErrorText));
    }

    private final TextAttributes getAttributesForSeverity(int start2, int end, Severity severity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1 -> {
                HighlightInfoType v0 = HighlightInfoType.ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ERROR");
                HighlightSeverity v1 = HighlightSeverity.ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ERROR");
                TextAttributesKey v2 = CodeInsightColors.ERRORS_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ERRORS_ATTRIBUTES");
                yield this.getAttributesForSeverity(v0, v1, v2, start2, end);
            }
            case 2 -> {
                HighlightInfoType v4 = HighlightInfoType.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"WARNING");
                HighlightSeverity v5 = HighlightSeverity.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"WARNING");
                TextAttributesKey v6 = CodeInsightColors.WARNINGS_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"WARNINGS_ATTRIBUTES");
                yield this.getAttributesForSeverity(v4, v5, v6, start2, end);
            }
            case 3 -> {
                HighlightInfoType v7 = HighlightInfoType.WEAK_WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"WEAK_WARNING");
                HighlightSeverity v8 = HighlightSeverity.WEAK_WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"WEAK_WARNING");
                TextAttributesKey v9 = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"WEAK_WARNING_ATTRIBUTES");
                yield this.getAttributesForSeverity(v7, v8, v9, start2, end);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final TextAttributes getAttributesForSeverity(HighlightInfoType infoType, HighlightSeverity severity, TextAttributesKey insightColors, int start2, int end) {
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)infoType).range(start2, end).severity(severity).textAttributes(insightColors).create();
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)this.project).getPsiFile((Document)this.consoleView.getConsoleEditor().getDocument());
        EditorColorsScheme editorColorsScheme = this.consoleView.getConsoleEditor().getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme colorScheme = editorColorsScheme;
        HighlightInfo highlightInfo2 = highlightInfo;
        TextAttributes textAttributes = highlightInfo2 != null ? highlightInfo2.getTextAttributes((PsiElement)psiFile2, colorScheme) : null;
        if (textAttributes == null) {
            textAttributes = new TextAttributes();
        }
        return textAttributes;
    }

    private static final void printWarningMessage$lambda$2$lambda$1(ReplOutputProcessor this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.runner.getCompilerHelper().compileModule();
    }

    private static final void printWarningMessage$lambda$2(ReplOutputProcessor this$0, String $message, boolean $isAddHyperlink) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        ReplOutputProcessor.printOutput$default(this$0, "\n", consoleViewContentType, null, 4, null);
        this$0.printOutput($message, ReplColors.INSTANCE.getWARNING_INFO_CONTENT_TYPE(), ReplIcons.INSTANCE.getBUILD_WARNING_INDICATOR());
        if ($isAddHyperlink) {
            LanguageConsoleImpl languageConsoleImpl = this$0.consoleView;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this$0.runner.getModule().getName(), (String)"getName(...)");
            languageConsoleImpl.printHyperlink(KotlinIdeaReplBundle.message("build.module.0.and.restart1", objectArray), arg_0 -> ReplOutputProcessor.printWarningMessage$lambda$2$lambda$1(this$0, arg_0));
        }
        ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
        ReplOutputProcessor.printOutput$default(this$0, "\n\n", consoleViewContentType2, null, 4, null);
    }

    private static final void printHelp$lambda$3(ReplOutputProcessor this$0, String $help) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$help, (String)"$help");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"SYSTEM_OUTPUT");
        this$0.printOutput($help, consoleViewContentType, ReplIcons.INSTANCE.getSYSTEM_HELP());
    }

    private static final void printUserOutput$lambda$4(ReplOutputProcessor this$0, String $command) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        this$0.consoleView.print($command, ReplColors.INSTANCE.getUSER_OUTPUT_CONTENT_TYPE());
    }

    private static final void printResultWithGutterIcon$lambda$5(ReplOutputProcessor this$0, String $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        this$0.printOutput($result, consoleViewContentType, ReplIcons.INSTANCE.getRESULT());
    }

    /*
     * WARNING - void declaration
     */
    private static final void highlightCompilerErrors$lambda$11(ReplOutputProcessor this$0, List $compilerMessages) {
        void $this$mapTo$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object message2;
        Iterable $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        int lastCommandStartLine;
        int lastCommandStartOffset;
        block11: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$compilerMessages, (String)"$compilerMessages");
            CommandHistory commandHistory = this$0.runner.getCommandHistory();
            CommandHistory.Entry entry = commandHistory.lastUnprocessedEntry();
            if (entry == null) {
                RunExecuteActionsKt.logError$default(ReplOutputProcessor.class, "Processed more commands than were sent. Sent commands: " + commandHistory.getSize() + ". Processed: " + commandHistory.getProcessedEntriesCount(), null, 4, null);
                return;
            }
            CommandHistory.Entry lastUnprocessedHistoryEntry = entry;
            lastCommandStartOffset = lastUnprocessedHistoryEntry.getRangeInHistoryDocument().getStartOffset();
            lastCommandStartLine = this$0.historyDocument.getLineNumber(lastCommandStartOffset);
            RangeHighlighter[] rangeHighlighterArray = this$0.historyMarkup.getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
            Object[] $this$first$iv = rangeHighlighterArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv2;
                boolean bl = false;
                if (!(this$0.historyDocument.getLineNumber(it.getStartOffset()) == lastCommandStartLine && it.getGutterIconRenderer() != null)) {
                    continue;
                }
                break block11;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object object = element$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        RangeHighlighter historyCommandRunIndicator = (RangeHighlighter)object;
        Iterable $this$filter$iv = $compilerMessages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SeverityDetails it = (SeverityDetails)element$iv$iv;
            boolean bl = false;
            if (!(it.getSeverity() == Severity.ERROR || it.getSeverity() == Severity.WARNING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            message2 = (SeverityDetails)element$iv$iv;
            boolean bl = false;
            int cmdStart = lastCommandStartOffset + ((SeverityDetails)message2).getRange().getStartOffset();
            Integer key$iv$iv = this$0.historyEditor.getDocument().getLineNumber(cmdStart);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void messages;
            message2 = (List)item$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)messages;
            boolean $i$f$map2 = false;
            $this$getOrPut$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void message3;
                SeverityDetails severityDetails = (SeverityDetails)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                int cmdStart = lastCommandStartOffset + message3.getRange().getStartOffset();
                int cmdEnd = lastCommandStartOffset + Math.max(message3.getRange().getEndOffset(), message3.getRange().getStartOffset() + 1);
                TextAttributes textAttributes = this$0.getAttributesForSeverity(cmdStart, cmdEnd, message3.getSeverity());
                collection.add(this$0.historyMarkup.addRangeHighlighter(cmdStart, cmdEnd, 6000, textAttributes, HighlighterTargetArea.EXACT_RANGE));
            }
            List highlighters = (List)destination$iv$iv2;
            object3.add(new Pair(CollectionsKt.first((List)highlighters), (Object)messages));
        }
        List highlighterAndMessagesByLine = (List)destination$iv$iv;
        for (Pair pair : highlighterAndMessagesByLine) {
            RangeHighlighter highlighter = (RangeHighlighter)pair.component1();
            List messages = (List)pair.component2();
            if (this$0.historyDocument.getLineNumber(highlighter.getStartOffset()) == lastCommandStartLine) {
                historyCommandRunIndicator.setGutterIconRenderer((GutterIconRenderer)new ConsoleErrorRenderer(messages));
                continue;
            }
            highlighter.setGutterIconRenderer((GutterIconRenderer)new ConsoleErrorRenderer(messages));
        }
    }

    private static final void printRuntimeError$lambda$12(ReplOutputProcessor this$0, String $errorText) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$errorText, (String)"$errorText");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
        this$0.printOutput($errorText, consoleViewContentType, ReplIcons.INSTANCE.getRUNTIME_EXCEPTION());
    }

    private static final void printInternalErrorMessage$lambda$13(ReplOutputProcessor this$0, String $internalErrorText) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$internalErrorText, (String)"$internalErrorText");
        String promptText = KotlinIdeaReplBundle.message("internal.error.occurred.please.send.report.to.developers", new Object[0]);
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
        this$0.printOutput(promptText, consoleViewContentType, ReplIcons.INSTANCE.getRUNTIME_EXCEPTION());
        RunExecuteActionsKt.logError$default(this$0.getClass(), $internalErrorText, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

