/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDataClassPrimaryConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDataClassPrimaryConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,46:1\n68#2:47\n*S KotlinDebug\n*F\n+ 1 FirDataClassPrimaryConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker\n*L\n21#1:47\n*E\n"})
public final class FirDataClassPrimaryConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirDataClassPrimaryConstructorChecker INSTANCE = new FirDataClassPrimaryConstructorChecker();

    private FirDataClassPrimaryConstructorChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirConstructorSymbol primaryConstructor;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (declaration2.getClassKind() != ClassKind.CLASS) break block7;
                FirRegularClass $this$isData$iv = declaration2;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData()) break block8;
            }
            return;
        }
        FirConstructorSymbol firConstructorSymbol = primaryConstructor = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if ((firConstructorSymbol != null ? firConstructorSymbol.getSource() : null) == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), (DiagnosticContext)context2, null, (int)8, null);
            return;
        }
        List<FirValueParameterSymbol> valueParameters = primaryConstructor.getValueParameterSymbols();
        if (valueParameters.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructor.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), (DiagnosticContext)context2, null, (int)8, null);
        }
        for (FirValueParameterSymbol parameter : valueParameters) {
            if (parameter.isVararg()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)parameter.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDATA_CLASS_VARARG_PARAMETER(), (DiagnosticContext)context2, null, (int)8, null);
            }
            KtSourceElement ktSourceElement = parameter.getSource();
            if (ktSourceElement != null ? LightTreePositioningStrategiesKt.hasValOrVar((KtSourceElement)ktSourceElement) : false) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)parameter.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDATA_CLASS_NOT_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }
}

