/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUpperBoundViolatedHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUpperBoundViolatedDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirUpperBoundViolatedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirUpperBoundViolatedDeclarationChecker INSTANCE = new FirUpperBoundViolatedDeclarationChecker();

    private FirUpperBoundViolatedDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block7: {
            FirPureAbstractElement firPureAbstractElement;
            block8: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    if (!(declaration2 instanceof FirClass)) break block6;
                    for (FirTypeParameterRef typeParameter : ((FirClass)declaration2).getTypeParameters()) {
                        if (!(typeParameter instanceof FirTypeParameter)) continue;
                        for (FirTypeRef bound2 : ((FirTypeParameter)typeParameter).getBounds()) {
                            FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(bound2, context2, reporter, false, 8, null);
                        }
                    }
                    for (FirTypeRef superTypeRef : ((FirClass)declaration2).getSuperTypeRefs()) {
                        FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(superTypeRef, context2, reporter, false, 8, null);
                    }
                    break block7;
                }
                if (!(declaration2 instanceof FirTypeAlias)) break block8;
                FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter, true);
                break block7;
            }
            if (!(declaration2 instanceof FirCallableDeclaration)) break block7;
            KtSourceElement ktSourceElement = ((FirCallableDeclaration)declaration2).getReturnTypeRef().getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated(((FirCallableDeclaration)declaration2).getReturnTypeRef(), context2, reporter, CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirTypeAlias);
            }
            if ((firPureAbstractElement = ((FirCallableDeclaration)declaration2).getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
                FirPureAbstractElement receiverTypeRef = firPureAbstractElement;
                boolean bl = false;
                FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default((FirTypeRef)receiverTypeRef, context2, reporter, false, 8, null);
            }
            for (FirContextReceiver receiver2 : ((FirCallableDeclaration)declaration2).getContextReceivers()) {
                FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(receiver2.getTypeRef(), context2, reporter, false, 8, null);
            }
        }
    }
}

