/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirDesignatedCompilerRequiredAnnotationsResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "<init>", "()V", "filesWithResolvedImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "importsAreResolved", "", "file", "useCacheForImportScope", "getUseCacheForImportScope", "()Z", "recordThatImportsAreResolved", "", "declarationsWithResolvedAnnotations", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotationsAreResolved", "declaration", "treatNonSourceDeclarationsAsResolved", "recordThatAnnotationsAreResolved", "resolveAnnotationsOnAnnotationIfNeeded", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolveAnnotationSymbol", "resolve"})
public class CompilerRequiredAnnotationsComputationSession {
    @NotNull
    private final Set<FirFile> filesWithResolvedImports = new LinkedHashSet();
    @NotNull
    private final Set<FirAnnotationContainer> declarationsWithResolvedAnnotations = new LinkedHashSet();

    public final boolean importsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.filesWithResolvedImports.contains(file2);
    }

    public boolean getUseCacheForImportScope() {
        return false;
    }

    public final void recordThatImportsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.filesWithResolvedImports.add(file2)) {
            throw new IllegalStateException("Imports are resolved twice".toString());
        }
    }

    public final boolean annotationsAreResolved(@NotNull FirAnnotationContainer declaration2, boolean treatNonSourceDeclarationsAsResolved) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof FirFile) {
            return false;
        }
        if (treatNonSourceDeclarationsAsResolved && declaration2 instanceof FirDeclaration && !Intrinsics.areEqual((Object)((FirDeclaration)declaration2).getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return true;
        }
        return this.declarationsWithResolvedAnnotations.contains(declaration2);
    }

    public final void recordThatAnnotationsAreResolved(@NotNull FirAnnotationContainer declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.declarationsWithResolvedAnnotations.add(declaration2);
    }

    public final void resolveAnnotationsOnAnnotationIfNeeded(@NotNull FirRegularClassSymbol symbol2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirRegularClass regularClass = (FirRegularClass)symbol2.getFir();
        if (this.annotationsAreResolved(regularClass, true)) {
            return;
        }
        this.resolveAnnotationSymbol(symbol2, scopeSession);
    }

    public void resolveAnnotationSymbol(@NotNull FirRegularClassSymbol symbol2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        DesignationState designationState = DesignationState.Companion.create(symbol2, MapsKt.emptyMap(), true);
        if (designationState == null) {
            return;
        }
        DesignationState designation = designationState;
        FirDesignatedCompilerRequiredAnnotationsResolveTransformer transformer2 = new FirDesignatedCompilerRequiredAnnotationsResolveTransformer(designation.getFirstDeclaration().getModuleData().getSession(), scopeSession, this, designation);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
    }
}

