/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightSettings;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/IDESettingsFUSCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "optimizeImportsEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "scriptingAREnabledField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "scriptingAREvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "scriptingDefNameField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "scriptingPluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "unambiguousImportsEvent", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class IDESettingsFUSCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.ide.settings", 4, null, 4, null);
    @NotNull
    private final BooleanEventField scriptingAREnabledField = EventFields.Boolean((String)"enabled");
    @NotNull
    private final StringEventField scriptingDefNameField;
    @NotNull
    private final PrimitiveEventField<PluginInfo> scriptingPluginInfoField;
    @NotNull
    private final EventId3<String, Boolean, PluginInfo> scriptingAREvent;
    @NotNull
    private final EventId2<Boolean, PluginInfo> unambiguousImportsEvent;
    @NotNull
    private final EventId2<Boolean, PluginInfo> optimizeImportsEvent;

    public IDESettingsFUSCollector() {
        Object[] objectArray = new String[]{"KotlinInitScript", "KotlinSettingsScript", "KotlinBuildScript", "Script_definition_for_extension_scripts_and_IDE_console", "MainKtsScript", "Kotlin_Script", "Space_Automation"};
        this.scriptingDefNameField = EventFields.String((String)"definition_name", (List)CollectionsKt.listOf((Object[])objectArray));
        this.scriptingPluginInfoField = EventFields.PluginInfo;
        this.scriptingAREvent = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"scriptingAutoReloadEnabled", (EventField)((EventField)this.scriptingDefNameField), (EventField)((EventField)this.scriptingAREnabledField), (EventField)((EventField)this.scriptingPluginInfoField), null, (int)16, null);
        this.unambiguousImportsEvent = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"addUnambiguousImportsOnTheFly", (EventField)((EventField)EventFields.Boolean((String)"enabled")), (EventField)((EventField)EventFields.PluginInfo), null, (int)8, null);
        this.optimizeImportsEvent = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"optimizeImportsOnTheFly", (EventField)((EventField)EventFields.Boolean((String)"enabled")), (EventField)((EventField)EventFields.PluginInfo), null, (int)8, null);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (KotlinPlatformUtils.isAndroidStudio()) {
            return SetsKt.emptySet();
        }
        Set metrics = new LinkedHashSet();
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoById((PluginId)KotlinIdePlugin.INSTANCE.getId());
        for (ScriptDefinition definition2 : ScriptUtilsKt.getAllDefinitions(project2)) {
            if (!definition2.getCanAutoReloadScriptConfigurationsBeSwitchedOff()) continue;
            boolean scriptingAutoReloadEnabled = KotlinScriptingSettings.Companion.getInstance(project2).autoReloadConfigurations(definition2);
            metrics.add(this.scriptingAREvent.metric((Object)definition2.getName(), (Object)scriptingAutoReloadEnabled, (Object)pluginInfo));
        }
        KotlinCodeInsightSettings settings2 = KotlinCodeInsightSettings.Companion.getInstance();
        KotlinCodeInsightWorkspaceSettings projectSettings = KotlinCodeInsightWorkspaceSettings.Companion.getInstance(project2);
        metrics.add(this.unambiguousImportsEvent.metric((Object)settings2.addUnambiguousImportsOnTheFly, (Object)pluginInfo));
        metrics.add(this.optimizeImportsEvent.metric((Object)projectSettings.optimizeImportsOnTheFly, (Object)pluginInfo));
        return metrics;
    }
}

