/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinFoldingBuilder;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtFunctionElementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J.\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\"\u001a\u00020\u0006*\u00020\u0006H\u0002J\u0014\u0010#\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "collectionFactoryFunctionsNames", "", "", "appendDescriptors", "", "node", "Lcom/intellij/lang/ASTNode;", "document", "Lcom/intellij/openapi/editor/Document;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "quick", "", "getCommentContents", "line", "getFirstLineOfComment", "getLanguagePlaceholderText", "range", "Lcom/intellij/openapi/util/TextRange;", "getRangeToFold", "getTrimmedFirstLineOfString", "isCustomFoldingRoot", "isFirstElementInFile", "element", "isRegionCollapsedByDefault", "needFolding", "addSpaceIfNeeded", "shouldFoldCollection", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nKotlinFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFoldingBuilder.kt\norg/jetbrains/kotlin/idea/KotlinFoldingBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,230:1\n1747#2,3:231\n288#2,2:238\n179#3,2:234\n179#3,2:236\n179#3,2:240\n*S KotlinDebug\n*F\n+ 1 KotlinFoldingBuilder.kt\norg/jetbrains/kotlin/idea/KotlinFoldingBuilder\n*L\n111#1:231,3\n183#1:238,2\n123#1:234,2\n173#1:236,2\n220#1:240,2\n*E\n"})
public final class KotlinFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    @NotNull
    private final Set<String> collectionFactoryFunctionsNames;

    public KotlinFoldingBuilder() {
        Object[] objectArray = new String[]{"arrayOf", "booleanArrayOf", "byteArrayOf", "charArrayOf", "doubleArrayOf", "floatArrayOf", "intArrayOf", "longArrayOf", "shortArrayOf", "arrayListOf", "hashMapOf", "hashSetOf", "linkedMapOf", "linkedSetOf", "linkedStringMapOf", "linkedStringSetOf", "listOf", "listOfNotNull", "mapOf", "mutableListOf", "mutableMapOf", "mutableSetOf", "setOf", "sortedMapOf", "sortedSetOf", "stringMapOf", "stringSetOf"};
        this.collectionFactoryFunctionsNames = SetsKt.setOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors2, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors2, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof KtFile)) {
            return;
        }
        KtImportList importList = ((KtFile)root).getImportList();
        if (importList != null) {
            List list2 = importList.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getImports(...)");
            KtImportDirective firstImport = (KtImportDirective)CollectionsKt.firstOrNull((List)list2);
            if (firstImport != null && importList.getImports().size() > 1) {
                void $this$buildLanguageFoldRegions_u24lambda_u240;
                FoldingDescriptor foldingDescriptor;
                PsiElement importKeyword = firstImport.getFirstChild();
                Intrinsics.checkNotNull((Object)importKeyword);
                int startOffset = PsiUtilsKt.getEndOffset((PsiElement)importKeyword) + 1;
                int endOffset2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)importList));
                FoldingDescriptor foldingDescriptor2 = foldingDescriptor = new FoldingDescriptor((PsiElement)importList, new TextRange(startOffset, endOffset2));
                List<FoldingDescriptor> list3 = descriptors2;
                boolean bl = false;
                $this$buildLanguageFoldRegions_u24lambda_u240.setCanBeRemovedWhenCollapsed(true);
                list3.add(foldingDescriptor);
            }
        }
        FileASTNode fileASTNode = ((KtFile)root).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
        this.appendDescriptors((ASTNode)fileASTNode, document, descriptors2);
    }

    private final void appendDescriptors(ASTNode node2, Document document, List<FoldingDescriptor> descriptors2) {
        if (this.needFolding(node2, document)) {
            TextRange textRange = this.getRangeToFold(node2, document);
            TextRange textRange2 = textRange.shiftRight(-node2.getTextRange().getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
            TextRange relativeRange = textRange2;
            CharSequence foldRegionText = node2.getChars().subSequence(relativeRange.getStartOffset(), relativeRange.getEndOffset());
            if (StringUtil.countNewLines((CharSequence)foldRegionText) > 0) {
                descriptors2.add(new FoldingDescriptor(node2, textRange));
            }
        }
        for (ASTNode child2 = node2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            this.appendDescriptors(child2, document, descriptors2);
        }
    }

    private final boolean needFolding(ASTNode node2, Document document) {
        IElementType parentType;
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type2 = iElementType;
        ASTNode aSTNode = node2.getTreeParent();
        Object object = parentType = aSTNode != null ? aSTNode.getElementType() : null;
        if (type2 instanceof KtFunctionElementType) {
            KtExpression bodyExpression;
            PsiElement psiElement2 = node2.getPsi();
            KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            Object object2 = bodyExpression = ktNamedFunction != null ? ktNamedFunction.getBodyExpression() : null;
            if (bodyExpression != null && !(bodyExpression instanceof KtBlockExpression)) {
                return true;
            }
        }
        return Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.FUNCTION_LITERAL) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.BLOCK) && !Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.FUNCTION_LITERAL) && !Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.SCRIPT) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.CLASS_BODY) || Intrinsics.areEqual((Object)type2, (Object)KtTokens.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.STRING_TEMPLATE) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.WHEN) || this.shouldFoldCollection(node2, document);
    }

    private final boolean shouldFoldCollection(ASTNode $this$shouldFoldCollection, Document document) {
        boolean bl;
        block8: {
            PsiElement psiElement2 = $this$shouldFoldCollection.getPsi();
            KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression call2 = ktCallExpression;
            Project project2 = call2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (DumbService.Companion.isDumb(project2)) {
                return false;
            }
            if (call2.getValueArguments().size() < 2) {
                return false;
            }
            if (FixersUtilKt.startLine((PsiElement)((PsiElement)call2), (Document)document) == FixersUtilKt.endLine((PsiElement)((PsiElement)call2), (Document)document)) {
                return false;
            }
            KtReferenceExpression ktReferenceExpression = KtPsiUtilKt.referenceExpression((KtExpression)((KtExpression)call2));
            if (ktReferenceExpression == null) {
                return false;
            }
            KtReferenceExpression reference2 = ktReferenceExpression;
            Iterable $this$any$iv = ReferenceUtilsKt.getMainReference((KtReferenceExpression)reference2).getResolvesByNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Name name2 = (Name)element$iv;
                    boolean bl2 = false;
                    if (!(name2.isSpecial() || !this.collectionFactoryFunctionsNames.contains(name2.getIdentifier()))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final TextRange getRangeToFold(ASTNode node2, Document document) {
        PsiElement leftParenthesis;
        PsiElement rbrace;
        PsiElement funKeyword;
        if (node2.getElementType() instanceof KtFunctionElementType) {
            KtExpression bodyExpression;
            KtNamedFunction function2;
            PsiElement psiElement2 = node2.getPsi();
            KtNamedFunction ktNamedFunction = function2 = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            funKeyword = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
            KtNamedFunction ktNamedFunction2 = function2;
            Object object = bodyExpression = ktNamedFunction2 != null ? ktNamedFunction2.getBodyExpression() : null;
            if (funKeyword != null && bodyExpression != null && !(bodyExpression instanceof KtBlockExpression)) {
                if (FixersUtilKt.startLine((PsiElement)funKeyword, (Document)document) != FixersUtilKt.startLine((PsiElement)((PsiElement)bodyExpression), (Document)document)) {
                    Object v4;
                    block11: {
                        Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)bodyExpression), (boolean)false, (boolean)false);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            String string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) continue;
                            v4 = element$iv;
                            break block11;
                        }
                        v4 = null;
                    }
                    PsiElement lineBreak = v4;
                    if (lineBreak != null) {
                        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)lineBreak), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)bodyExpression)));
                    }
                }
                TextRange textRange = bodyExpression.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return textRange;
            }
        }
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.FUNCTION_LITERAL)) {
            KtFunctionLiteral psi2;
            funKeyword = node2.getPsi();
            KtFunctionLiteral ktFunctionLiteral = psi2 = funKeyword instanceof KtFunctionLiteral ? (KtFunctionLiteral)funKeyword : null;
            PsiElement lbrace = ktFunctionLiteral != null ? ktFunctionLiteral.getLBrace() : null;
            KtFunctionLiteral ktFunctionLiteral2 = psi2;
            Object object = rbrace = ktFunctionLiteral2 != null ? ktFunctionLiteral2.getRBrace() : null;
            if (lbrace != null && rbrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)lbrace), PsiUtilsKt.getEndOffset((PsiElement)rbrace));
            }
        }
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION)) {
            PsiElement rightParenthesis;
            KtValueArgumentList valueArgumentList2;
            rbrace = node2.getPsi();
            KtCallExpression ktCallExpression = rbrace instanceof KtCallExpression ? (KtCallExpression)rbrace : null;
            KtValueArgumentList ktValueArgumentList = valueArgumentList2 = ktCallExpression != null ? ktCallExpression.getValueArgumentList() : null;
            leftParenthesis = ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null;
            KtValueArgumentList ktValueArgumentList2 = valueArgumentList2;
            Object object = rightParenthesis = ktValueArgumentList2 != null ? ktValueArgumentList2.getRightParenthesis() : null;
            if (leftParenthesis != null && rightParenthesis != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)leftParenthesis), PsiUtilsKt.getEndOffset((PsiElement)rightParenthesis));
            }
        }
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.WHEN)) {
            PsiElement closeBrace;
            KtWhenExpression whenExpression2;
            leftParenthesis = node2.getPsi();
            KtWhenExpression ktWhenExpression = whenExpression2 = leftParenthesis instanceof KtWhenExpression ? (KtWhenExpression)leftParenthesis : null;
            PsiElement openBrace = ktWhenExpression != null ? ktWhenExpression.getOpenBrace() : null;
            KtWhenExpression ktWhenExpression2 = whenExpression2;
            Object object = closeBrace = ktWhenExpression2 != null ? ktWhenExpression2.getCloseBrace() : null;
            if (openBrace != null && closeBrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)openBrace), PsiUtilsKt.getEndOffset((PsiElement)closeBrace));
            }
        }
        TextRange textRange = node2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node2, @NotNull TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        return Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtTokens.BLOCK_COMMENT) ? "/" + this.getFirstLineOfComment(node2) + ".../" : (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KDocTokens.KDOC) ? "/**" + this.getFirstLineOfComment(node2) + "...*/" : (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.STRING_TEMPLATE) ? "\"\"\"" + this.addSpaceIfNeeded(this.getTrimmedFirstLineOfString(node2)) + "...\"\"\"" : (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION) ? "(...)" : (node2.getPsi() instanceof KtImportList ? "..." : "{...}"))));
    }

    private final String getTrimmedFirstLineOfString(ASTNode node2) {
        String firstLine2;
        String string;
        Object v1;
        block2: {
            String string2 = node2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String[] stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), (Function1)getTrimmedFirstLineOfString.firstLine.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                if (!(((CharSequence)p0).length() > 0)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((string = (firstLine2 = (String)v1)) == null) {
            string = "";
        }
        return string;
    }

    private final String addSpaceIfNeeded(String $this$addSpaceIfNeeded) {
        if (((CharSequence)$this$addSpaceIfNeeded).length() == 0 || StringsKt.endsWith$default((String)$this$addSpaceIfNeeded, (String)" ", (boolean)false, (int)2, null)) {
            return $this$addSpaceIfNeeded;
        }
        return $this$addSpaceIfNeeded + " ";
    }

    private final String getFirstLineOfComment(ASTNode node2) {
        Object v2;
        block2: {
            String string = node2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{"\n"};
            Iterable $this$firstOrNull$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)this.getCommentContents(it)).length() > 0;
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return "";
        }
        String targetCommentLine = string;
        return " " + this.getCommentContents(targetCommentLine) + " ";
    }

    private final String getCommentContents(String line) {
        return ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (CharSequence)"/**"), (CharSequence)"/*"), (CharSequence)"*/"), (CharSequence)"*"))).toString();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        JavaCodeFoldingSettings settings2 = JavaCodeFoldingSettings.getInstance();
        if (node2.getPsi() instanceof KtImportList) {
            return settings2.isCollapseImports();
        }
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type2 = iElementType;
        if (Intrinsics.areEqual((Object)type2, (Object)KtTokens.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC)) {
            PsiElement psiElement2 = node2.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsi(...)");
            if (this.isFirstElementInFile(psiElement2)) {
                return settings2.isCollapseFileHeader();
            }
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.BLOCK) || Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.CLASS_BODY);
    }

    private final boolean isFirstElementInFile(PsiElement element3) {
        PsiElement parent2 = element3.getParent();
        if (parent2 instanceof KtFile) {
            Object v0;
            block2: {
                Sequence $this$firstOrNull$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)parent2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it.getTextLength() != 0 && !(it instanceof PsiWhiteSpace))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PsiElement firstNonWhiteSpace = v0;
            return Intrinsics.areEqual((Object)element3, (Object)firstNonWhiteSpace);
        }
        return false;
    }
}

