/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.actions.AbstractNewKotlinFileAction;
import org.jetbrains.kotlin.idea.actions.KotlinFileTemplate;
import org.jetbrains.kotlin.idea.actions.NewKotlinFileActionKt;
import org.jetbrains.kotlin.idea.actions.NewKotlinFileNameValidator;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/actions/NewKotlinFileAction;", "Lorg/jetbrains/kotlin/idea/actions/AbstractNewKotlinFileAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "equals", "", "other", "", "getActionName", "", "newName", "templateName", "hashCode", "", "isAvailable", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nNewKotlinFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewKotlinFileAction.kt\norg/jetbrains/kotlin/idea/actions/NewKotlinFileAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,338:1\n12474#2,2:339\n*S KotlinDebug\n*F\n+ 1 NewKotlinFileAction.kt\norg/jetbrains/kotlin/idea/actions/NewKotlinFileAction\n*L\n67#1:339,2\n*E\n"})
public final class NewKotlinFileAction
extends AbstractNewKotlinFileAction
implements DumbAware {
    protected boolean isAvailable(@NotNull DataContext dataContext) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (!super.isAvailable(dataContext)) {
                return false;
            }
            IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
            if (ideView == null) {
                return false;
            }
            IdeView ideView2 = ideView;
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return false;
            }
            Project project3 = project2;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project3).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex projectFileIndex2 = projectFileIndex;
            PsiDirectory[] psiDirectoryArray = ideView2.getDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
            Object[] $this$any$iv = psiDirectoryArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile virtualFile2;
                PsiDirectory it = (PsiDirectory)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getVirtualFile(), (String)"getVirtualFile(...)");
                boolean bl3 = SourceKindFilterUtils.matches(RootKindFilter.projectSources, project3, virtualFile2) || CreateTemplateInPackageAction.isInContentRoot((VirtualFile)virtualFile2, (ProjectFileIndex)projectFileIndex2);
                if (!bl3) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    protected void buildDialog(@NotNull Project project2, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        KotlinJ2KOnboardingFUSCollector.INSTANCE.logKtFileDialogOpened(project2);
        boolean sealedTemplatesEnabled = RegistryManager.Companion.getInstance().is("kotlin.create.sealed.templates.enabled");
        builder2.setTitle(KotlinBundle.message((String)"action.new.file.dialog.title", (Object[])new Object[0]));
        CreateFileFromTemplateDialog.Builder builder3 = NewKotlinFileActionKt.addKind(builder2, KotlinFileTemplate.Class);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"addKind(...)");
        CreateFileFromTemplateDialog.Builder builder4 = NewKotlinFileActionKt.addKind(builder3, KotlinFileTemplate.File);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"addKind(...)");
        NewKotlinFileActionKt.addKind(builder4, KotlinFileTemplate.Interface);
        if (sealedTemplatesEnabled && LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(project2).supportsFeature(LanguageFeature.SealedInterfaces)) {
            NewKotlinFileActionKt.addKind(builder2, KotlinFileTemplate.SealedInterface);
        }
        CreateFileFromTemplateDialog.Builder builder5 = NewKotlinFileActionKt.addKind(builder2, KotlinFileTemplate.DataClass);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"addKind(...)");
        NewKotlinFileActionKt.addKind(builder5, KotlinFileTemplate.Enum);
        if (sealedTemplatesEnabled) {
            NewKotlinFileActionKt.addKind(builder2, KotlinFileTemplate.SealedClass);
        }
        CreateFileFromTemplateDialog.Builder builder6 = NewKotlinFileActionKt.addKind(builder2, KotlinFileTemplate.Annotation);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"addKind(...)");
        CreateFileFromTemplateDialog.Builder builder7 = NewKotlinFileActionKt.addKind(builder6, KotlinFileTemplate.Script);
        Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"addKind(...)");
        builder4 = NewKotlinFileActionKt.addKind(builder7, KotlinFileTemplate.Worksheet);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"addKind(...)");
        NewKotlinFileActionKt.addKind(builder4, KotlinFileTemplate.Object);
        builder2.setValidator((InputValidator)NewKotlinFileNameValidator.INSTANCE);
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName2, @NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        return KotlinBundle.message((String)"action.Kotlin.NewFile.text", (Object[])new Object[0]);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object other2) {
        return other2 instanceof NewKotlinFileAction;
    }
}

