/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeParameter;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\fH\u0007\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\fH\u0007\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\fH\u0007\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"textAttributesForClass", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "textAttributesForKtParameterDeclaration", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "textAttributesForKtPropertyDeclaration", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "textAttributesKeyForKtElement", "element", "Lcom/intellij/psi/PsiElement;", "textAttributesKeyForKtFunction", "function", "textAttributesKeyForPropertyDeclaration", "declaration", "textAttributesKeyForTypeDeclaration", "isCustomPropertyDeclaration", "", "kotlin.highlighting.shared"})
@JvmName(name="KotlinHighlighterAttributeUtils")
public final class KotlinHighlighterAttributeUtils {
    @ApiStatus.Internal
    @Nullable
    public static final HighlightInfoType textAttributesKeyForKtElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        HighlightInfoType highlightInfoType = KotlinHighlighterAttributeUtils.textAttributesKeyForTypeDeclaration(element3);
        if (highlightInfoType == null && (highlightInfoType = KotlinHighlighterAttributeUtils.textAttributesKeyForKtFunction(element3)) == null) {
            highlightInfoType = KotlinHighlighterAttributeUtils.textAttributesKeyForPropertyDeclaration(element3);
        }
        return highlightInfoType;
    }

    @ApiStatus.Internal
    @Nullable
    public static final HighlightInfoType textAttributesKeyForPropertyDeclaration(@NotNull PsiElement declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        PsiElement psiElement2 = declaration2;
        return psiElement2 instanceof KtProperty ? KotlinHighlighterAttributeUtils.textAttributesForKtPropertyDeclaration((KtProperty)declaration2) : (psiElement2 instanceof KtParameter ? KotlinHighlighterAttributeUtils.textAttributesForKtParameterDeclaration((KtParameter)declaration2) : (psiElement2 instanceof PsiLocalVariable ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLOCAL_VARIABLE() : (psiElement2 instanceof PsiParameter ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPARAMETER() : (psiElement2 instanceof PsiField ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getINSTANCE_PROPERTY() : null))));
    }

    @ApiStatus.Internal
    @NotNull
    public static final HighlightInfoType textAttributesForKtParameterDeclaration(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return parameter.getValOrVarKeyword() != null ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getINSTANCE_PROPERTY() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPARAMETER();
    }

    @ApiStatus.Internal
    @NotNull
    public static final HighlightInfoType textAttributesForKtPropertyDeclaration(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)property2)) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getEXTENSION_PROPERTY() : (property2.isLocal() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLOCAL_VARIABLE() : (property2.isTopLevel() ? (KotlinHighlighterAttributeUtils.isCustomPropertyDeclaration(property2) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPACKAGE_PROPERTY_CUSTOM_PROPERTY_DECLARATION() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPACKAGE_PROPERTY()) : (KotlinHighlighterAttributeUtils.isCustomPropertyDeclaration(property2) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getINSTANCE_PROPERTY_CUSTOM_PROPERTY_DECLARATION() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getINSTANCE_PROPERTY())));
    }

    @ApiStatus.Internal
    @Nullable
    public static final HighlightInfoType textAttributesKeyForKtFunction(@NotNull PsiElement function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof KtFunction ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_DECLARATION() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ApiStatus.Internal
    @Nullable
    public static final HighlightInfoType textAttributesKeyForTypeDeclaration(@NotNull PsiElement declaration2) {
        HighlightInfoType highlightInfoType;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof KtTypeParameter || declaration2 instanceof PsiTypeParameter) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER();
            return highlightInfoType;
        }
        if (declaration2 instanceof KtTypeAlias) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_ALIAS();
            return highlightInfoType;
        }
        if (declaration2 instanceof KtClass) {
            if (((KtClass)declaration2).isAnnotation()) {
                highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION();
                return highlightInfoType;
            }
            highlightInfoType = KotlinHighlighterAttributeUtils.textAttributesForClass((KtClass)declaration2);
            return highlightInfoType;
        }
        if (declaration2 instanceof PsiClass && ((PsiClass)declaration2).isInterface() && !((PsiClass)declaration2).isAnnotationType()) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTRAIT();
            return highlightInfoType;
        }
        if (declaration2 instanceof KtPrimaryConstructor) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
            boolean bl = ktClassOrObject != null ? ktClassOrObject.isAnnotation() : false;
            if (bl) {
                highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION();
                return highlightInfoType;
            }
        }
        if (declaration2 instanceof KtObjectDeclaration) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getOBJECT();
            return highlightInfoType;
        }
        if (declaration2 instanceof PsiEnumConstant) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getENUM_ENTRY();
            return highlightInfoType;
        }
        if (!(declaration2 instanceof PsiClass)) {
            return null;
        }
        if (((PsiClass)declaration2).isAnnotationType()) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION();
            return highlightInfoType;
        }
        if (((PsiClass)declaration2).hasModifier(JvmModifier.ABSTRACT)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getABSTRACT_CLASS();
            return highlightInfoType;
        }
        highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCLASS();
        return highlightInfoType;
    }

    @ApiStatus.Internal
    @NotNull
    public static final HighlightInfoType textAttributesForClass(@NotNull KtClass klass2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        return klass2.isInterface() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTRAIT() : (klass2.isAnnotation() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION() : (klass2.isEnum() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getENUM() : (klass2 instanceof KtEnumEntry ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getENUM_ENTRY() : (KtPsiUtilKt.isAbstract((KtClass)klass2) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getABSTRACT_CLASS() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCLASS()))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCustomPropertyDeclaration(KtProperty $this$isCustomPropertyDeclaration) {
        KtPropertyAccessor ktPropertyAccessor = $this$isCustomPropertyDeclaration.getGetter();
        if ((ktPropertyAccessor != null ? ktPropertyAccessor.getBodyExpression() : null) != null) return true;
        KtPropertyAccessor ktPropertyAccessor2 = $this$isCustomPropertyDeclaration.getSetter();
        if (ktPropertyAccessor2 == null) return false;
        KtExpression ktExpression = ktPropertyAccessor2.getBodyExpression();
        if (ktExpression == null) return false;
        return true;
    }
}

