/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.plugin.artifacts;

import com.intellij.util.io.DigestUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducer;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducerKt;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.LazyFileOutputProducer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b \u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001'B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\t0\t0\u000bH\u0002J%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%H$\u00a2\u0006\u0002\u0010&R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer;", "I", "", "C", "Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/LazyFileOutputProducer;", "uniquePipelineId", "", "(Ljava/lang/String;)V", "hashFile", "Ljava/io/File;", "value", "", "outputs", "getOutputs", "()Ljava/util/List;", "setOutputs", "(Ljava/util/List;)V", "outputsFile", "calculateMd5", "input", "(Ljava/lang/Object;)Ljava/lang/String;", "getOutputIfUpToDateOrEmpty", "(Ljava/lang/Object;)Ljava/util/List;", "isUpToDate", "", "(Ljava/lang/Object;)Z", "lazyProduceOutput", "computationContext", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "produceOutput", "readOutputsFile", "kotlin.jvm.PlatformType", "updateMessageDigestWithInput", "", "messageDigest", "Ljava/security/MessageDigest;", "buffer", "", "(Ljava/security/MessageDigest;Ljava/lang/Object;[B)V", "Companion", "kotlin.base.plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractLazyFileOutputProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLazyFileOutputProducer.kt\norg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n*L\n1#1,96:1\n1#2:97\n1#2:107\n1549#3:98\n1620#3,3:99\n1726#3,3:102\n230#4,2:105\n*S KotlinDebug\n*F\n+ 1 AbstractLazyFileOutputProducer.kt\norg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer\n*L\n52#1:107\n26#1:98\n26#1:99,3\n45#1:102,3\n52#1:105,2\n*E\n"})
public abstract class AbstractLazyFileOutputProducer<I, C>
implements LazyFileOutputProducer<I, C> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File hashFile;
    @NotNull
    private final File outputsFile;
    @NotNull
    private List<? extends File> outputs;

    public AbstractLazyFileOutputProducer(@NotNull String uniquePipelineId) {
        Intrinsics.checkNotNullParameter((Object)uniquePipelineId, (String)"uniquePipelineId");
        this.hashFile = FilesKt.resolve((File)AbstractLazyFileOutputProducerKt.access$getROOT$p(), (String)(uniquePipelineId + ".hash"));
        this.outputsFile = FilesKt.resolve((File)AbstractLazyFileOutputProducerKt.access$getROOT$p(), (String)(uniquePipelineId + ".outputs"));
        this.outputs = CollectionsKt.emptyList();
    }

    private final List<File> getOutputs() {
        List<File> list2;
        List<File> it = list2 = this.outputs;
        boolean bl = false;
        List<File> list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 == null) {
            it = list2 = this.readOutputsFile();
            boolean bl2 = false;
            this.outputs = it;
            list3 = list2;
        }
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    private final void setOutputs(List<? extends File> value2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = value2;
        AbstractLazyFileOutputProducer abstractLazyFileOutputProducer = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanonicalFile());
        }
        abstractLazyFileOutputProducer.outputs = (List)destination$iv$iv;
        this.outputsFile.getParentFile().mkdirs();
        FilesKt.writeText$default((File)this.outputsFile, (String)CollectionsKt.joinToString$default((Iterable)this.outputs, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    @Override
    @NotNull
    public List<File> lazyProduceOutput(@NotNull I input, C computationContext) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (!this.isUpToDate(input)) {
            Collection collection = this.produceOutput(input, computationContext);
            if (collection.isEmpty()) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            this.setOutputs((List)collection);
            this.hashFile.getParentFile().mkdirs();
            FilesKt.writeText$default((File)this.hashFile, (String)this.calculateMd5(input), null, (int)2, null);
            if (!this.isUpToDate(input)) {
                boolean bl = false;
                String string = "It should be up-to-date after re-calculation";
                throw new IllegalStateException(string.toString());
            }
        }
        return this.getOutputs();
    }

    @NotNull
    public final List<File> getOutputIfUpToDateOrEmpty(@NotNull I input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return this.isUpToDate(input) ? this.getOutputs() : CollectionsKt.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUpToDate(@NotNull I input) {
        boolean bl;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (((Collection)this.getOutputs()).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = this.getOutputs();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                File it = (File)element$iv;
                boolean bl3 = false;
                if (it.exists()) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (!this.hashFile.isFile()) return false;
        if (!this.outputsFile.isFile()) return false;
        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)this.hashFile, null, (int)1, null))).toString(), (Object)this.calculateMd5(input))) return false;
        return true;
    }

    @NotNull
    protected abstract List<File> produceOutput(@NotNull I var1, C var2);

    protected abstract void updateMessageDigestWithInput(@NotNull MessageDigest var1, @NotNull I var2, @NotNull byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<File> readOutputsFile() {
        Object object;
        File file2;
        Object object2 = this.outputsFile;
        File it = object2;
        boolean bl = false;
        File file3 = file2 = it.exists() ? object2 : null;
        if (file2 != null) {
            File $this$useLines_u24default$iv = file2;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object3 = $this$useLines_u24default$iv;
            int n = 8192;
            Object object4 = object3;
            object3 = (object4 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object4), charset$iv)) instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object3;
                boolean bl2 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl3 = false;
                object4 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)lines, (Function1)readOutputsFile.2.1.INSTANCE));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            object2 = object4;
            if (object2 != null) {
                object = object2;
                return object;
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    private final String calculateMd5(I input) {
        MessageDigest messageDigest = DigestUtil.md5();
        byte[] buffer = new byte[524288];
        Path path2 = this.outputsFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        DigestUtil.updateContentHash((MessageDigest)messageDigest, (Path)path2, (byte[])buffer);
        this.updateMessageDigestWithInput(messageDigest, input, buffer);
        AbstractLazyFileOutputProducerKt.update(messageDigest, this.getOutputs(), buffer);
        return DigestUtil.digestToHash((MessageDigest)messageDigest);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer$Companion;", "", "()V", "invalidateCaches", "", "kotlin.base.plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void invalidateCaches() {
            FilesKt.deleteRecursively((File)AbstractLazyFileOutputProducerKt.access$getROOT$p());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

