/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.HmppSourceModuleDependencyFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NegatedModuleDependencyFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NonHmppSourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectModuleDependencies", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "sourceRootType", "Lorg/jetbrains/kotlin/config/KotlinSourceRootType;", "includeExportedDependencies", "", "collectionMode", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$CollectionMode;", "collectModuleDependenciesForOrderEntry", "", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "getOrderEnumerator", "Lcom/intellij/openapi/roots/OrderEnumerator;", "isApplicable", "CollectionMode", "Companion", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nKotlinModuleDependencyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n35#2:147\n766#3:148\n857#3,2:149\n*S KotlinDebug\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector\n*L\n50#1:147\n113#1:148\n113#1:149,2\n*E\n"})
public final class ModuleDependencyCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public ModuleDependencyCollector(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Collection<IdeaModuleInfo> collectModuleDependencies(@NotNull Module module2, @NotNull TargetPlatform platform2, @NotNull KotlinSourceRootType sourceRootType, boolean includeExportedDependencies, @NotNull CollectionMode collectionMode) {
        NegatedModuleDependencyFilter negatedModuleDependencyFilter;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)sourceRootType, (String)"sourceRootType");
        Intrinsics.checkNotNullParameter((Object)((Object)collectionMode), (String)"collectionMode");
        ArrayList<String> debugInfo = LOG.isDebugEnabled() ? new ArrayList<String>() : null;
        OrderEnumerator orderEnumerator = this.getOrderEnumerator(module2, sourceRootType, includeExportedDependencies);
        SourceModuleDependenciesFilter sourceModuleDependenciesFilter = KotlinFacetUtils.isHMPPEnabled(module2) ? (SourceModuleDependenciesFilter)new HmppSourceModuleDependencyFilter(platform2) : (SourceModuleDependenciesFilter)new NonHmppSourceModuleDependenciesFilter(platform2);
        boolean condition$iv = collectionMode == CollectionMode.COLLECT_IGNORED;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void p0 = $this$applyIf$iv;
            boolean bl = false;
            negatedModuleDependencyFilter = new NegatedModuleDependencyFilter((SourceModuleDependenciesFilter)p0);
        } else {
            negatedModuleDependencyFilter = $this$applyIf$iv;
        }
        SourceModuleDependenciesFilter dependencyFilter = negatedModuleDependencyFilter;
        LinkedHashSet<IdeaModuleInfo> result2 = new LinkedHashSet<IdeaModuleInfo>();
        orderEnumerator.forEach(arg_0 -> ModuleDependencyCollector.collectModuleDependencies$lambda$0((Function1)new Function1<OrderEntry, Boolean>(this, sourceRootType, debugInfo, dependencyFilter, result2){
            final /* synthetic */ ModuleDependencyCollector this$0;
            final /* synthetic */ KotlinSourceRootType $sourceRootType;
            final /* synthetic */ ArrayList<String> $debugInfo;
            final /* synthetic */ SourceModuleDependenciesFilter $dependencyFilter;
            final /* synthetic */ LinkedHashSet<IdeaModuleInfo> $result;
            {
                this.this$0 = $receiver;
                this.$sourceRootType = $sourceRootType;
                this.$debugInfo = $debugInfo;
                this.$dependencyFilter = $dependencyFilter;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(OrderEntry orderEntry) {
                block4: {
                    block3: {
                        Intrinsics.checkNotNull((Object)orderEntry);
                        if (!ModuleDependencyCollector.access$isApplicable(this.this$0, orderEntry, this.$sourceRootType)) break block3;
                        ArrayList<String> arrayList = this.$debugInfo;
                        if (arrayList != null) {
                            arrayList.add("Add entry " + orderEntry.getPresentableName());
                        }
                        for (IdeaModuleInfo moduleInfo : ModuleDependencyCollector.access$collectModuleDependenciesForOrderEntry(this.this$0, orderEntry, this.$sourceRootType)) {
                            if (!this.$dependencyFilter.isSupportedDependency(moduleInfo)) continue;
                            ArrayList<String> arrayList2 = this.$debugInfo;
                            if (arrayList2 != null) {
                                arrayList2.add("Add module " + moduleInfo.getDisplayedName());
                            }
                            this.$result.add(moduleInfo);
                        }
                        break block4;
                    }
                    ArrayList<String> arrayList = this.$debugInfo;
                    if (arrayList == null) break block4;
                    arrayList.add("Skip entry " + orderEntry.getPresentableName());
                }
                return true;
            }
        }, arg_0));
        if (debugInfo != null) {
            StringBuilder stringBuilder;
            StringBuilder $this$collectModuleDependencies_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$collectModuleDependencies_u24lambda_u241.append("Building dependency list for module " + $this$collectModuleDependencies_u24lambda_u241);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = $this$collectModuleDependencies_u24lambda_u241.append("Platform = " + platform2 + ", isForTests = " + Intrinsics.areEqual((Object)sourceRootType, (Object)TestSourceKotlinRootType.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            CollectionsKt.joinTo$default((Iterable)debugInfo, (Appendable)$this$collectModuleDependencies_u24lambda_u241, (CharSequence)"; ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)112, null);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String debugString = string;
            LOG.debug(debugString);
        }
        return result2;
    }

    public static /* synthetic */ Collection collectModuleDependencies$default(ModuleDependencyCollector moduleDependencyCollector, Module module2, TargetPlatform targetPlatform, KotlinSourceRootType kotlinSourceRootType, boolean bl, CollectionMode collectionMode, int n, Object object) {
        if ((n & 0x10) != 0) {
            collectionMode = CollectionMode.COLLECT_NON_IGNORED;
        }
        return moduleDependencyCollector.collectModuleDependencies(module2, targetPlatform, kotlinSourceRootType, bl, collectionMode);
    }

    private final OrderEnumerator getOrderEnumerator(Module module2, KotlinSourceRootType sourceRootType, boolean includeExportedDependencies) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        OrderEnumerator orderEnumerator = rootManager.orderEntries().compileOnly();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"compileOnly(...)");
        OrderEnumerator dependencyEnumerator = orderEnumerator;
        if (includeExportedDependencies) {
            dependencyEnumerator.recursively().exportedOnly();
        }
        if (Intrinsics.areEqual((Object)sourceRootType, (Object)SourceKotlinRootType.INSTANCE) && BuildSystemTypeKt.getBuildSystemType(module2) == BuildSystemType.JPS) {
            dependencyEnumerator.productionOnly();
        }
        return dependencyEnumerator;
    }

    private final boolean isApplicable(OrderEntry orderEntry, KotlinSourceRootType sourceRootType) {
        if (!orderEntry.isValid()) {
            return false;
        }
        return !(orderEntry instanceof ExportableOrderEntry) || Intrinsics.areEqual((Object)sourceRootType, (Object)TestSourceKotlinRootType.INSTANCE) || orderEntry instanceof ModuleOrderEntry && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() || ((ExportableOrderEntry)orderEntry).getScope().isForProductionCompile();
    }

    private final List<IdeaModuleInfo> collectModuleDependenciesForOrderEntry(OrderEntry orderEntry, KotlinSourceRootType sourceRootType) {
        List<Object> list2;
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module2 = ((ModuleSourceOrderEntry)orderEntry).getOwnerModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"getOwnerModule(...)");
            list2 = ModuleDependencyCollector.collectModuleDependenciesForOrderEntry$toInfos(module2, sourceRootType);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module3 = ((ModuleOrderEntry)orderEntry).getModule();
            if (module3 == null) {
                return CollectionsKt.emptyList();
            }
            Module module4 = module3;
            list2 = Intrinsics.areEqual((Object)sourceRootType, (Object)SourceKotlinRootType.INSTANCE) && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() ? CollectionsKt.listOfNotNull((Object)KotlinProjectStructureUtils.getTestSourceInfo(module4)) : ModuleDependencyCollector.collectModuleDependenciesForOrderEntry$toInfos(module4, sourceRootType);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library2 == null) {
                return CollectionsKt.emptyList();
            }
            Library library3 = library2;
            list2 = LibraryInfoCache.Companion.getInstance(this.project).get(library3);
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk2 = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk2 == null) {
                return CollectionsKt.emptyList();
            }
            Sdk sdk3 = sdk2;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(this.project, sdk3));
        } else {
            throw new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    private static final boolean collectModuleDependencies$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ModuleSourceInfo> collectModuleDependenciesForOrderEntry$toInfos(Module $this$collectModuleDependenciesForOrderEntry_u24toInfos, KotlinSourceRootType $sourceRootType) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = KotlinProjectStructureUtils.getSourceModuleInfos($this$collectModuleDependenciesForOrderEntry_u24toInfos);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)$sourceRootType, (Object)TestSourceKotlinRootType.INSTANCE) || it instanceof ModuleProductionSourceInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ boolean access$isApplicable(ModuleDependencyCollector $this, OrderEntry orderEntry, KotlinSourceRootType sourceRootType) {
        return $this.isApplicable(orderEntry, sourceRootType);
    }

    public static final /* synthetic */ List access$collectModuleDependenciesForOrderEntry(ModuleDependencyCollector $this, OrderEntry orderEntry, KotlinSourceRootType sourceRootType) {
        return $this.collectModuleDependenciesForOrderEntry(orderEntry, sourceRootType);
    }

    static {
        Logger logger = Logger.getInstance(ModuleDependencyCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$CollectionMode;", "", "(Ljava/lang/String;I)V", "COLLECT_IGNORED", "COLLECT_NON_IGNORED", "kotlin.base.project-structure"})
    public static final class CollectionMode
    extends Enum<CollectionMode> {
        public static final /* enum */ CollectionMode COLLECT_IGNORED = new CollectionMode();
        public static final /* enum */ CollectionMode COLLECT_NON_IGNORED = new CollectionMode();
        private static final /* synthetic */ CollectionMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CollectionMode[] values() {
            return (CollectionMode[])$VALUES.clone();
        }

        public static CollectionMode valueOf(String value2) {
            return Enum.valueOf(CollectionMode.class, value2);
        }

        @NotNull
        public static EnumEntries<CollectionMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = collectionModeArray = new CollectionMode[]{CollectionMode.COLLECT_IGNORED, CollectionMode.COLLECT_NON_IGNORED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleDependencyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,146:1\n31#2,2:147\n*S KotlinDebug\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$Companion\n*L\n27#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleDependencyCollector getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ModuleDependencyCollector> serviceClass$iv = ModuleDependencyCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleDependencyCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

