/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util.caching;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 I*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004:\u0002IJB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0014J8\u0010\u001f\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u001a\u0010 \u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010!H\u0002J\u001c\u0010\"\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0004J\b\u0010#\u001a\u00020\u001eH\u0004J\u0015\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010%\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00020\u001e2\u0006\u0010%\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010&J\u0015\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010&J\b\u0010,\u001a\u00020\u001eH\u0016J0\u0010-\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/H\u0014J)\u00100\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010%\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010(J\u001c\u00101\u001a\u00020\u001e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0014J0\u00102\u001a\b\u0012\u0004\u0012\u00028\u0001032\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u0000032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0014J\u0016\u00105\u001a\u00028\u00012\u0006\u0010%\u001a\u00028\u0000H\u00a7\u0002\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020\u001eH\u0004J\u0012\u00108\u001a\u00020\u001e2\b\b\u0002\u00109\u001a\u00020\bH\u0004J@\u0010:\u001a\u00020\u001e2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0!2\u001c\b\u0002\u0010 \u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010!H\u0005J4\u0010<\u001a\u00020\u001e2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u0000032\u001c\b\u0002\u0010 \u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010!H\u0005J:\u0010=\u001a\b\u0012\u0004\u0012\u00028\u0001032\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u0000032\u001c\b\u0002\u0010 \u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010!H\u0005J\u001c\u0010>\u001a\u00020\u001e2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010@H\u0004J\b\u0010A\u001a\u00020\u001eH\u0002J\b\u0010B\u001a\u00020\u001eH$J3\u0010C\u001a\u0002HD\"\u0004\b\u0002\u0010D2\u001e\u0010E\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0004\u0012\u0002HD0FH$\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00028\u000103H\u0007R\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache;", "Key", "", "Value", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cleanOnLowMemory", "", "(Lcom/intellij/openapi/project/Project;Z)V", "cache", "", "getCache", "()Ljava/util/Map;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidationStamp", "Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$InvalidationStamp;", "lastInvalidatedTimestampMs", "Ljava/util/concurrent/atomic/AtomicLong;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "additionalEntitiesCheck", "", "checkEntities", "validityCondition", "Lkotlin/Function2;", "checkEntitiesIfRequired", "checkIsInitialized", "checkKeyAndDisposeIllegalEntry", "key", "(Ljava/lang/Object;)V", "checkKeyConsistency", "(Ljava/util/Map;Ljava/lang/Object;)V", "checkKeyValidity", "checkValueValidity", "value", "dispose", "disposeEntry", "entry", "", "disposeIllegalEntry", "doInvalidate", "doInvalidateKeysAndGetOutdatedValues", "", "keys", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "initialize", "invalidate", "writeAccessRequired", "invalidateEntries", "condition", "invalidateKeys", "invalidateKeysAndGetOutdatedValues", "putAll", "map", "", "registerLowMemoryWatcher", "subscribe", "useCache", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "values", "Companion", "InvalidationStamp", "kotlin.base.util"})
@SourceDebugExtension(value={"SMAP\nFineGrainedEntityCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FineGrainedEntityCache.kt\norg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1#2:405\n*E\n"})
public abstract class FineGrainedEntityCache<Key, Value>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean cleanOnLowMemory;
    @NotNull
    private final InvalidationStamp invalidationStamp;
    @NotNull
    private final AtomicLong lastInvalidatedTimestampMs;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private static final Function2<Object, Object, Boolean> CHECK_ALL = Companion.CHECK_ALL.1.INSTANCE;
    @NotNull
    private static final Lazy<Boolean> isValidityChecksEnabled$delegate = LazyKt.lazy((Function0)Companion.isValidityChecksEnabled.2.INSTANCE);
    @NotNull
    private static final Lazy<Integer> invalidationThrottlingMs$delegate = LazyKt.lazy((Function0)Companion.invalidationThrottlingMs.2.INSTANCE);

    public FineGrainedEntityCache(@NotNull Project project2, boolean cleanOnLowMemory) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.cleanOnLowMemory = cleanOnLowMemory;
        this.invalidationStamp = new InvalidationStamp();
        this.lastInvalidatedTimestampMs = new AtomicLong(0L);
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.initialized = new AtomicBoolean(false);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected abstract Map<Key, Value> getCache();

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final AtomicBoolean getInitialized() {
        return this.initialized;
    }

    protected final void initialize() {
        if (!(!this.initialized.getAndSet(true))) {
            boolean bl = false;
            String string = this.getClass().getName() + " has to be initialized once.";
            throw new IllegalStateException(string.toString());
        }
        if (this.cleanOnLowMemory) {
            this.registerLowMemoryWatcher();
        }
        this.subscribe();
    }

    private final void registerLowMemoryWatcher() {
        LowMemoryWatcher.register(() -> FineGrainedEntityCache.registerLowMemoryWatcher$lambda$1(this), (Disposable)this);
    }

    protected final void checkIsInitialized() {
        if (!this.initialized.get()) {
            boolean bl = false;
            String string = this.getClass().getName() + " has to be initialized.";
            throw new IllegalStateException(string.toString());
        }
    }

    protected abstract <T> T useCache(@NotNull Function1<? super Map<Key, Value>, ? extends T> var1);

    public void dispose() {
        FineGrainedEntityCache.invalidate$default(this, false, 1, null);
    }

    @RequiresReadLock
    @NotNull
    public abstract Value get(@NotNull Key var1);

    @RequiresReadLock
    @NotNull
    public final Collection<Value> values() {
        ThreadingAssertions.softAssertReadAccess();
        return (Collection)this.useCache(values.1.INSTANCE);
    }

    protected final void checkEntitiesIfRequired(@NotNull Map<Key, Value> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        if (Companion.isValidityChecksEnabled() && this.invalidationStamp.isCheckRequired()) {
            this.checkEntities(cache2, CHECK_ALL);
        }
    }

    protected final void checkKeyAndDisposeIllegalEntry(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (Companion.isValidityChecksEnabled()) {
            try {
                this.checkKeyValidity(key);
            }
            catch (Throwable e) {
                this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(this, key){
                    final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
                    final /* synthetic */ Key $key;
                    {
                        this.this$0 = $receiver;
                        this.$key = $key;
                        super(1);
                    }

                    public final void invoke(@NotNull Map<Key, Value> cache2) {
                        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                        this.this$0.disposeIllegalEntry(cache2, this.$key);
                    }
                });
                this.logger.error(e);
            }
        }
    }

    protected void disposeIllegalEntry(@NotNull Map<Key, Value> cache2, @NotNull Key key) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        cache2.remove(key);
    }

    protected final void putAll(@NotNull Map<Key, ? extends Value> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        if (Companion.isValidityChecksEnabled()) {
            for (Map.Entry<Key, Value> entry : map2.entrySet()) {
                Key key = entry.getKey();
                Value value2 = entry.getValue();
                this.checkKeyValidity(key);
                this.checkValueValidity(value2);
            }
        }
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(map2){
            final /* synthetic */ Map<Key, Value> $map;
            {
                this.$map = $map;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                for (Map.Entry<Key, Value> entry : this.$map.entrySet()) {
                    Key key = entry.getKey();
                    Value value2 = entry.getValue();
                    cache2.putIfAbsent(key, value2);
                }
            }
        });
    }

    protected final void invalidate(boolean writeAccessRequired) {
        if (writeAccessRequired) {
            ThreadingAssertions.assertWriteAccess();
        } else {
            ThreadingAssertions.softAssertReadAccess();
        }
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(this){
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                this.this$0.doInvalidate(cache2);
            }
        });
    }

    public static /* synthetic */ void invalidate$default(FineGrainedEntityCache fineGrainedEntityCache, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidate");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        fineGrainedEntityCache.invalidate(bl);
    }

    protected void doInvalidate(@NotNull Map<Key, Value> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        cache2.clear();
    }

    @RequiresWriteLock
    @NotNull
    protected final Collection<Value> invalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends Key> keys, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        ThreadingAssertions.assertWriteAccess();
        return (Collection)this.useCache((Function1)new Function1<Map<Key, Value>, Collection<? extends Value>>(this, keys, validityCondition){
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            final /* synthetic */ Collection<Key> $keys;
            final /* synthetic */ Function2<Key, Value, Boolean> $validityCondition;
            {
                this.this$0 = $receiver;
                this.$keys = $keys;
                this.$validityCondition = $validityCondition;
                super(1);
            }

            @NotNull
            public final Collection<Value> invoke(@NotNull Map<Key, Value> cache2) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                Collection<Value> collection = this.this$0.doInvalidateKeysAndGetOutdatedValues(this.$keys, cache2);
                FineGrainedEntityCache<Key, Value> fineGrainedEntityCache = this.this$0;
                Function2<Key, Value, Boolean> function2 = this.$validityCondition;
                Collection<Value> it = collection;
                boolean bl = false;
                FineGrainedEntityCache.access$getInvalidationStamp$p(fineGrainedEntityCache).incInvalidation();
                FineGrainedEntityCache.access$checkEntities(fineGrainedEntityCache, cache2, function2);
                return collection;
            }
        });
    }

    public static /* synthetic */ Collection invalidateKeysAndGetOutdatedValues$default(FineGrainedEntityCache fineGrainedEntityCache, Collection collection, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateKeysAndGetOutdatedValues");
        }
        if ((n & 2) != 0) {
            function2 = CHECK_ALL;
        }
        return fineGrainedEntityCache.invalidateKeysAndGetOutdatedValues(collection, function2);
    }

    @NotNull
    protected Collection<Value> doInvalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends Key> keys, @NotNull Map<Key, Value> cache2) {
        List list2;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        List $this$doInvalidateKeysAndGetOutdatedValues_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Key key : keys) {
            Value p0;
            if (cache2.remove(key) == null) continue;
            boolean bl2 = false;
            $this$doInvalidateKeysAndGetOutdatedValues_u24lambda_u243.add(p0);
        }
        return CollectionsKt.build((List)list2);
    }

    @RequiresWriteLock
    protected final void invalidateKeys(@NotNull Collection<? extends Key> keys, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        ThreadingAssertions.assertWriteAccess();
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(keys, this, validityCondition){
            final /* synthetic */ Collection<Key> $keys;
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            final /* synthetic */ Function2<Key, Value, Boolean> $validityCondition;
            {
                this.$keys = $keys;
                this.this$0 = $receiver;
                this.$validityCondition = $validityCondition;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                for (Key key : this.$keys) {
                    cache2.remove(key);
                }
                FineGrainedEntityCache.access$getInvalidationStamp$p(this.this$0).incInvalidation();
                FineGrainedEntityCache.access$checkEntities(this.this$0, cache2, this.$validityCondition);
            }
        });
    }

    public static /* synthetic */ void invalidateKeys$default(FineGrainedEntityCache fineGrainedEntityCache, Collection collection, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateKeys");
        }
        if ((n & 2) != 0) {
            function2 = CHECK_ALL;
        }
        fineGrainedEntityCache.invalidateKeys(collection, function2);
    }

    @RequiresWriteLock
    protected final void invalidateEntries(@NotNull Function2<? super Key, ? super Value, Boolean> condition2, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        Intrinsics.checkNotNullParameter(condition2, (String)"condition");
        ThreadingAssertions.assertWriteAccess();
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(condition2, this, validityCondition){
            final /* synthetic */ Function2<Key, Value, Boolean> $condition;
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            final /* synthetic */ Function2<Key, Value, Boolean> $validityCondition;
            {
                this.$condition = $condition;
                this.this$0 = $receiver;
                this.$validityCondition = $validityCondition;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                Iterator<Map.Entry<Key, Value>> iterator2 = cache2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Value value2;
                    Map.Entry<Key, Value> entry = iterator2.next();
                    Key key = entry.getKey();
                    if (!((Boolean)this.$condition.invoke(key, value2 = entry.getValue())).booleanValue()) continue;
                    iterator2.remove();
                }
                FineGrainedEntityCache.access$getInvalidationStamp$p(this.this$0).incInvalidation();
                FineGrainedEntityCache.access$checkEntities(this.this$0, cache2, this.$validityCondition);
            }
        });
    }

    public static /* synthetic */ void invalidateEntries$default(FineGrainedEntityCache fineGrainedEntityCache, Function2 function2, Function2 function22, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateEntries");
        }
        if ((n & 2) != 0) {
            function22 = CHECK_ALL;
        }
        fineGrainedEntityCache.invalidateEntries(function2, function22);
    }

    private final void checkEntities(Map<Key, Value> cache2, Function2<? super Key, ? super Value, Boolean> validityCondition) {
        if (Companion.isValidityChecksEnabled() && validityCondition != null) {
            boolean allEntriesChecked = true;
            Iterator<Map.Entry<Key, Value>> iterator2 = cache2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Key, Value> entry = iterator2.next();
                if (((Boolean)validityCondition.invoke(entry.getKey(), entry.getValue())).booleanValue()) {
                    try {
                        this.checkKeyConsistency(cache2, entry.getKey());
                        this.checkValueValidity(entry.getValue());
                    }
                    catch (Throwable e) {
                        iterator2.remove();
                        this.disposeEntry(cache2, entry);
                        this.logger.error(e);
                    }
                    continue;
                }
                allEntriesChecked = false;
            }
            this.additionalEntitiesCheck(cache2);
            if (allEntriesChecked) {
                this.invalidationStamp.reset();
            }
        }
    }

    protected void additionalEntitiesCheck(@NotNull Map<Key, Value> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
    }

    protected void disposeEntry(@NotNull Map<Key, Value> cache2, @NotNull Map.Entry<Key, Value> entry) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
    }

    protected abstract void subscribe();

    protected abstract void checkKeyValidity(@NotNull Key var1);

    protected void checkKeyConsistency(@NotNull Map<Key, Value> cache2, @NotNull Key key) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkKeyValidity(key);
    }

    protected void checkValueValidity(@NotNull Value value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
    }

    private static final void registerLowMemoryWatcher$lambda$1(FineGrainedEntityCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean isInvalidationThrottled;
                long nowMs = System.currentTimeMillis();
                boolean bl = isInvalidationThrottled = FineGrainedEntityCache.Companion.getInvalidationThrottlingMs() > 0 && nowMs < FineGrainedEntityCache.access$getLastInvalidatedTimestampMs$p(this.this$0).get() + (long)FineGrainedEntityCache.Companion.getInvalidationThrottlingMs();
                if (isInvalidationThrottled) {
                    this.this$0.getLogger().debug("invalidation throttled");
                } else {
                    this.this$0.getLogger().debug("invalidated on low memory");
                    FineGrainedEntityCache.invalidate$default(this.this$0, false, 1, null);
                    FineGrainedEntityCache.access$getLastInvalidatedTimestampMs$p(this.this$0).getAndSet(nowMs);
                }
            }
        }));
    }

    public static final /* synthetic */ InvalidationStamp access$getInvalidationStamp$p(FineGrainedEntityCache $this) {
        return $this.invalidationStamp;
    }

    public static final /* synthetic */ void access$checkEntities(FineGrainedEntityCache $this, Map cache2, Function2 validityCondition) {
        $this.checkEntities(cache2, validityCondition);
    }

    public static final /* synthetic */ AtomicLong access$getLastInvalidatedTimestampMs$p(FineGrainedEntityCache $this) {
        return $this.lastInvalidatedTimestampMs;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$Companion;", "", "()V", "CHECK_ALL", "Lkotlin/Function2;", "", "getCHECK_ALL", "()Lkotlin/jvm/functions/Function2;", "invalidationThrottlingMs", "", "getInvalidationThrottlingMs", "()I", "invalidationThrottlingMs$delegate", "Lkotlin/Lazy;", "isValidityChecksEnabled", "()Z", "isValidityChecksEnabled$delegate", "kotlin.base.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function2<Object, Object, Boolean> getCHECK_ALL() {
            return CHECK_ALL;
        }

        public final boolean isValidityChecksEnabled() {
            Lazy lazy = isValidityChecksEnabled$delegate;
            return (Boolean)lazy.getValue();
        }

        public final int getInvalidationThrottlingMs() {
            Lazy lazy = invalidationThrottlingMs$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$InvalidationStamp;", "", "()V", "count", "", "currentCount", "incInvalidation", "", "isCheckRequired", "", "reset", "kotlin.base.util"})
    private static final class InvalidationStamp {
        private int currentCount;
        private int count;

        public final boolean isCheckRequired() {
            return this.currentCount > this.count;
        }

        public final void incInvalidation() {
            int n = this.currentCount;
            this.currentCount = n + 1;
        }

        public final void reset() {
            this.count = this.currentCount;
        }
    }
}

