/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a'\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u00020\u0004\u00a2\u0006\u0002\u0010\u0007\u001a'\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u00020\u0004\u00a2\u0006\u0002\u0010\u0007\u001a\u001b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u00020\u0004\u00a2\u0006\u0002\u0010\n\u001a\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u00020\u0004\u00a2\u0006\u0002\u0010\f\u001a\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\u0004\u00a2\u0006\u0002\u0010\u0010\u001a\u0019\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0012H\u0007R\u00020\u0004\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"getCallExpressionSymbol", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lkotlin/Pair;", "getDefaultArgumentSymbol", "getFunctionSymbol", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "getInlineArgumentSymbol", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;", "isArrayGeneratorConstructorCall", "", "symbol", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;)Z", "isInlinedArgument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtFunction;)Z", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nInlineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/InlineUtilsKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,95:1\n66#2,2:96\n66#2,2:98\n*S KotlinDebug\n*F\n+ 1 InlineUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/InlineUtilsKt\n*L\n50#1:96,2\n53#1:98,2\n*E\n"})
public final class InlineUtilsKt {
    @ApiStatus.Internal
    public static final boolean isInlinedArgument(@NotNull KaSession $context_receiver_0, @NotNull KtFunction argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return InlineUtilsKt.getInlineArgumentSymbol($context_receiver_0, (KtExpression)argument2) != null;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaValueParameterSymbol getInlineArgumentSymbol(@NotNull KaSession $context_receiver_0, @NotNull KtExpression argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!(argument2 instanceof KtFunctionLiteral || argument2 instanceof KtNamedFunction || argument2 instanceof KtCallableReferenceExpression)) {
            return null;
        }
        Pair<KaFunctionSymbol, KaValueParameterSymbol> pair = InlineUtilsKt.getCallExpressionSymbol($context_receiver_0, argument2);
        if (pair == null && (pair = InlineUtilsKt.getDefaultArgumentSymbol($context_receiver_0, argument2)) == null) {
            return null;
        }
        Pair<KaFunctionSymbol, KaValueParameterSymbol> pair2 = pair;
        KaFunctionSymbol symbol2 = (KaFunctionSymbol)pair2.component1();
        KaValueParameterSymbol argumentSymbol = (KaValueParameterSymbol)pair2.component2();
        if (symbol2 instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol2).isInline() || InlineUtilsKt.isArrayGeneratorConstructorCall($context_receiver_0, symbol2)) {
            if (argumentSymbol.isNoinline()) {
                return null;
            }
            KaType parameterType = argumentSymbol.getReturnType();
            if (!$context_receiver_0.isMarkedNullable(parameterType) && ($context_receiver_0.isFunctionType(parameterType) || $context_receiver_0.isSuspendFunctionType(parameterType))) {
                return argumentSymbol;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaFunctionSymbol getFunctionSymbol(@NotNull KaSession $context_receiver_0, @NotNull KtExpression argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Object object = InlineUtilsKt.getCallExpressionSymbol($context_receiver_0, argument2);
        if (object == null || (object = (KaFunctionSymbol)object.getFirst()) == null) {
            Pair<KaFunctionSymbol, KaValueParameterSymbol> pair = InlineUtilsKt.getDefaultArgumentSymbol($context_receiver_0, argument2);
            object = pair != null ? (KaFunctionSymbol)pair.getFirst() : null;
        }
        return object;
    }

    private static final Pair<KaFunctionSymbol, KaValueParameterSymbol> getDefaultArgumentSymbol(KaSession $context_receiver_0, KtExpression argument2) {
        if (!(argument2 instanceof KtFunction) && !(argument2 instanceof KtCallableReferenceExpression)) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)argument2;
        boolean withSelf$iv22 = false;
        boolean $i$f$parentOfType = false;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtParameter.class, (boolean)true);
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        PsiElement withSelf$iv22 = argument2.getParent();
        KtLambdaExpression ktLambdaExpression2 = withSelf$iv22 instanceof KtLambdaExpression ? (KtLambdaExpression)withSelf$iv22 : null;
        if (ktLambdaExpression2 == null) {
            return null;
        }
        KtLambdaExpression lambdaExpression2 = ktLambdaExpression2;
        if (!Intrinsics.areEqual((Object)parameter.getDefaultValue(), (Object)lambdaExpression2)) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)parameter;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType2 = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function2 = ktNamedFunction;
        KaFunctionSymbol symbol2 = $context_receiver_0.getFunctionLikeSymbol(function2);
        KaVariableSymbol kaVariableSymbol = $context_receiver_0.getParameterSymbol(parameter);
        KaValueParameterSymbol kaValueParameterSymbol = kaVariableSymbol instanceof KaValueParameterSymbol ? (KaValueParameterSymbol)kaVariableSymbol : null;
        if (kaValueParameterSymbol == null) {
            return null;
        }
        KaValueParameterSymbol argumentSymbol = kaValueParameterSymbol;
        return TuplesKt.to((Object)symbol2, (Object)argumentSymbol);
    }

    @ApiStatus.Internal
    @Nullable
    public static final Pair<KaFunctionSymbol, KaValueParameterSymbol> getCallExpressionSymbol(@NotNull KaSession $context_receiver_0, @NotNull KtExpression argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!(argument2 instanceof KtFunction) && !(argument2 instanceof KtCallableReferenceExpression)) {
            return null;
        }
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)argument2);
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression parentCallExpression = ktCallExpression;
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)parentCallExpression);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner parentCall2 = kaLifetimeOwner;
        KaFunctionSymbol symbol2 = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(parentCall2.getPartiallyAppliedSymbol());
        KtValueArgument ktValueArgument = KotlinPsiUtils.getContainingValueArgument(parentCallExpression, argument2);
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument valueArgument = ktValueArgument;
        KaLifetimeOwner kaLifetimeOwner2 = parentCall2.getArgumentMapping().get(valueArgument.getArgumentExpression());
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = (KaValueParameterSymbol)kaLifetimeOwner2.getSymbol()) == null) {
            return null;
        }
        KaLifetimeOwner argumentSymbol = kaLifetimeOwner2;
        return TuplesKt.to((Object)symbol2, argumentSymbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayGeneratorConstructorCall(KaSession $context_receiver_0, KaFunctionSymbol symbol2) {
        if (symbol2 instanceof KaConstructorSymbol) {
            ClassId classId = ((KaConstructorSymbol)symbol2).getContainingClassId();
            if (!Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray()) && !StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().containsKey(classId)) {
                if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(classId)) return false;
            }
            boolean bl = true;
            boolean isArrayClass = bl;
            if (!isArrayClass) return false;
            if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($context_receiver_0, symbol2)) return false;
            return true;
        }
        if (!(symbol2 instanceof KaNamedFunctionSymbol)) return false;
        if (!symbol2.isExtension()) return false;
        KaType receiverType2 = KaCallableSymbolKt.getReceiverType(symbol2);
        if (!(receiverType2 instanceof KaClassType)) return false;
        if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(((KaClassType)receiverType2).getClassId())) return false;
        CallableId callableId = symbol2.getCallableId();
        if (!Intrinsics.areEqual((Object)(callableId != null ? callableId.getPackageName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($context_receiver_0, symbol2)) return false;
        return true;
    }

    private static final boolean isArrayGeneratorConstructorCall$checkParameters(KaSession $$context_receiver_0, KaFunctionSymbol symbol2) {
        return symbol2.getValueParameters().size() == 2 && $$context_receiver_0.isInt(symbol2.getValueParameters().get(0).getReturnType()) && $$context_receiver_0.isFunctionType(symbol2.getValueParameters().get(1).getReturnType());
    }
}

