/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u000bJ5\u0010\f\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006R\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00062\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0006R\u00020\u000e\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/NamedArgumentUtils;", "", "()V", "addArgumentName", "", "element", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "addArgumentNames", "argumentNames", "", "associateArgumentNamesStartingAt", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "call", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "startArgument", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallElement;Lorg/jetbrains/kotlin/psi/KtValueArgument;)Ljava/util/Map;", "getNameForNameableArgument", "argument", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "getStableNameFor", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtValueArgument;)Lorg/jetbrains/kotlin/name/Name;", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nNamedArgumentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedArgumentUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/NamedArgumentUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,96:1\n748#2,10:97\n1271#2,2:107\n1285#2,4:109\n1238#2,4:115\n1774#2,4:119\n468#3:113\n414#3:114\n*S KotlinDebug\n*F\n+ 1 NamedArgumentUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/NamedArgumentUtils\n*L\n54#1:97,10\n56#1:107,2\n56#1:109,4\n57#1:115,4\n88#1:119,4\n57#1:113\n57#1:114\n*E\n"})
public final class NamedArgumentUtils {
    @NotNull
    public static final NamedArgumentUtils INSTANCE = new NamedArgumentUtils();

    private NamedArgumentUtils() {
    }

    public final void addArgumentName(@NotNull KtValueArgument element3, @NotNull Name argumentName2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)argumentName2, (String)"argumentName");
        KtExpression ktExpression = element3.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression2 = ktExpression;
        PsiElement prevSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespace$default((PsiElement)((PsiElement)element3), (boolean)false, (int)1, null);
        if (prevSibling instanceof PsiComment) {
            Regex regex = new Regex("/\\*\\s*" + argumentName2 + "\\s*=\\s*\\*/");
            String string = ((PsiComment)prevSibling).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (regex.matches((CharSequence)string)) {
                ((PsiComment)prevSibling).delete();
            }
        }
        KtValueArgument newArgument = KtPsiFactory.createArgument$default((KtPsiFactory)new KtPsiFactory((KtElement)element3, false, 2, null), (KtExpression)argumentExpression2, (Name)argumentName2, (element3.getSpreadElement() != null ? 1 : 0) != 0, (boolean)false, (int)8, null);
        element3.replace((PsiElement)newArgument);
    }

    public final void addArgumentNames(@NotNull Map<KtValueArgument, Name> argumentNames) {
        Intrinsics.checkNotNullParameter(argumentNames, (String)"argumentNames");
        for (Map.Entry<KtValueArgument, Name> entry : argumentNames.entrySet()) {
            KtValueArgument argument2 = entry.getKey();
            Name name2 = entry.getValue();
            this.addArgumentName(argument2, name2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<SmartPsiElementPointer<KtValueArgument>, Name> associateArgumentNamesStartingAt(@NotNull KaSession $context_receiver_0, @NotNull KtCallElement call2, @Nullable KtValueArgument startArgument) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map2;
        Map $this$associateWith$iv;
        Object object;
        Iterable $this$dropWhile$iv;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)call2);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull(kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner resolvedCall2 = kaLifetimeOwner;
        if (!((KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)resolvedCall2)).getHasStableParameterNames()) {
            return null;
        }
        Object object2 = call2.getValueArgumentList();
        if (object2 == null || (object2 = object2.getArguments()) == null) {
            return null;
        }
        Object arguments2 = object2;
        if (startArgument != null) {
            $this$dropWhile$iv = (Iterable)arguments2;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList<Object> list$iv = new ArrayList<Object>();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                KtValueArgument it = (KtValueArgument)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)startArgument)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            object = list$iv;
        } else {
            object = arguments2;
        }
        Object argumentsExcludingPrevious = object;
        $this$dropWhile$iv = (Iterable)argumentsExcludingPrevious;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Name name2;
            void it;
            KtValueArgument bl = (KtValueArgument)element$iv$iv;
            Object e = element$iv$iv;
            map2 = result$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (INSTANCE.getNameForNameableArgument((KtValueArgument)it, (KaFunctionCall<?>)resolvedCall2) == null) {
                return null;
            }
            map2.put(e, name2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)k));
            Map map3 = map2;
            boolean bl3 = false;
            entry = it$iv$iv.getValue();
            map3.put(smartPsiElementPointer, entry);
        }
        return destination$iv$iv;
    }

    @Nullable
    public final Name getStableNameFor(@NotNull KaSession $context_receiver_0, @NotNull KtValueArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        KtCallElement ktCallElement = KotlinPsiUtils.getCallElement(argument2);
        if (ktCallElement == null) {
            return null;
        }
        KtCallElement callElement2 = ktCallElement;
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)callElement2);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull(kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner resolvedCall2 = kaLifetimeOwner;
        if (!((KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)resolvedCall2)).getHasStableParameterNames()) {
            return null;
        }
        return this.getNameForNameableArgument(argument2, (KaFunctionCall<?>)resolvedCall2);
    }

    private final Name getNameForNameableArgument(KtValueArgument argument2, KaFunctionCall<?> resolvedCall2) {
        KaLifetimeOwner kaLifetimeOwner = resolvedCall2.getArgumentMapping().get(argument2.getArgumentExpression());
        if (kaLifetimeOwner == null || (kaLifetimeOwner = (KaValueParameterSymbol)kaLifetimeOwner.getSymbol()) == null) {
            return null;
        }
        KaLifetimeOwner valueParameterSymbol = kaLifetimeOwner;
        if (((KaValueParameterSymbol)valueParameterSymbol).isVararg()) {
            int varargArgumentCount;
            if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)argument2).supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm) && !argument2.isSpread()) {
                return null;
            }
            Iterable $this$count$iv = resolvedCall2.getArgumentMapping().values();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v1 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KaVariableSignature it = (KaVariableSignature)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getSymbol(), (Object)valueParameterSymbol) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v1 = varargArgumentCount = count$iv;
            }
            if (varargArgumentCount != 1) {
                return null;
            }
        }
        return ((KaValueParameterSymbol)valueParameterSymbol).getName();
    }
}

