/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.PluginStartupApplicationService;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinBuildProcessParametersProvider;", "Lcom/intellij/compiler/server/BuildProcessParametersProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "MIN_DEP_GRAPH_SUPPORTING_VERSION", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getVMArguments", "", "", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nKotlinBuildProcessParametersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuildProcessParametersProvider.kt\norg/jetbrains/kotlin/idea/compiler/configuration/KotlinBuildProcessParametersProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1855#2,2:56\n*S KotlinDebug\n*F\n+ 1 KotlinBuildProcessParametersProvider.kt\norg/jetbrains/kotlin/idea/compiler/configuration/KotlinBuildProcessParametersProvider\n*L\n40#1:56,2\n*E\n"})
public final class KotlinBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final IdeKotlinVersion MIN_DEP_GRAPH_SUPPORTING_VERSION;

    public KotlinBuildProcessParametersProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        IdeKotlinVersion ideKotlinVersion = IdeKotlinVersion.Companion.opt("1.9.24");
        Intrinsics.checkNotNull((Object)ideKotlinVersion);
        this.MIN_DEP_GRAPH_SUPPORTING_VERSION = ideKotlinVersion;
    }

    @NotNull
    public List<String> getVMArguments() {
        String[] configuredKotlinVersion;
        KotlinCompilerWorkspaceSettings compilerWorkspaceSettings = KotlinCompilerWorkspaceSettings.Companion.getInstance(this.project);
        List arguments2 = new ArrayList();
        if (compilerWorkspaceSettings.getPreciseIncrementalEnabled()) {
            ((Collection)arguments2).add("-Dkotlin.incremental.compilation=true");
            if (AdvancedSettings.Companion.getBoolean("compiler.unified.ic.implementation") && !Registry.is((String)"compiler.process.use.portable.caches") && (configuredKotlinVersion = IdeKotlinVersion.Companion.opt(KotlinJpsPluginSettings.Companion.jpsVersion(this.project))) != null && configuredKotlinVersion.compareTo(this.MIN_DEP_GRAPH_SUPPORTING_VERSION) >= 0) {
                ((Collection)arguments2).add("-Dkotlin.jps.dumb.mode=true");
            }
        }
        if (compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled()) {
            ((Collection)arguments2).add("-Dkotlin.incremental.compilation.js=true");
        }
        if (compilerWorkspaceSettings.getEnableDaemon()) {
            ((Collection)arguments2).add("-Dkotlin.daemon.enabled");
        }
        if (((CharSequence)compilerWorkspaceSettings.getDaemonVmOptions()).length() > 0) {
            configuredKotlinVersion = new String[]{" "};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)compilerWorkspaceSettings.getDaemonVmOptions(), (String[])configuredKotlinVersion, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                ((Collection)arguments2).add(it);
            }
        }
        String it = PluginStartupApplicationService.Companion.getInstance().getAliveFlagPath();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)it)) {
            ((Collection)arguments2).add("-Dkotlin.daemon.client.alive.path=\"" + it + "\"");
        }
        return arguments2;
    }
}

