/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.completion.context.FirBasicCompletionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KDocNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinCallableReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinRawPositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinTypeNameReferencePositionContext;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/FirCompletionSessionParameters;", "", "basicContext", "Lorg/jetbrains/kotlin/idea/completion/context/FirBasicCompletionContext;", "positionContext", "Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;", "(Lorg/jetbrains/kotlin/idea/completion/context/FirBasicCompletionContext;Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;)V", "allowClassifiersAndPackagesForPossibleExtensionCallables", "", "getAllowClassifiersAndPackagesForPossibleExtensionCallables", "()Z", "allowExpectedDeclarations", "getAllowExpectedDeclarations", "allowJavaGettersAndSetters", "getAllowJavaGettersAndSetters", "allowSyntheticJavaProperties", "getAllowSyntheticJavaProperties", "excludeEnumEntries", "getExcludeEnumEntries", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.completion.impl.k2"})
public final class FirCompletionSessionParameters {
    @NotNull
    private final FirBasicCompletionContext basicContext;
    @NotNull
    private final KotlinRawPositionContext positionContext;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean excludeEnumEntries;
    private final boolean allowSyntheticJavaProperties;
    private final boolean allowJavaGettersAndSetters;
    private final boolean allowExpectedDeclarations;

    public FirCompletionSessionParameters(@NotNull FirBasicCompletionContext basicContext, @NotNull KotlinRawPositionContext positionContext) {
        Intrinsics.checkNotNullParameter((Object)basicContext, (String)"basicContext");
        Intrinsics.checkNotNullParameter((Object)positionContext, (String)"positionContext");
        this.basicContext = basicContext;
        this.positionContext = positionContext;
        this.languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(this.basicContext.getProject());
        this.excludeEnumEntries = !this.languageVersionSettings.supportsFeature(LanguageFeature.EnumEntries);
        this.allowSyntheticJavaProperties = !(this.positionContext instanceof KDocNameReferencePositionContext) && (!(this.positionContext instanceof KotlinCallableReferencePositionContext) || this.languageVersionSettings.supportsFeature(LanguageFeature.ReferencesToSyntheticJavaProperties));
        this.allowJavaGettersAndSetters = !this.allowSyntheticJavaProperties || this.basicContext.getParameters().getInvocationCount() > 1;
        this.allowExpectedDeclarations = TargetPlatformKt.isMultiPlatform((TargetPlatform)ModuleInfoProviderUtils.getModuleInfo((PsiElement)this.basicContext.getOriginalKtFile()).getPlatform());
    }

    public final boolean getExcludeEnumEntries() {
        return this.excludeEnumEntries;
    }

    public final boolean getAllowSyntheticJavaProperties() {
        return this.allowSyntheticJavaProperties;
    }

    public final boolean getAllowJavaGettersAndSetters() {
        return this.allowJavaGettersAndSetters;
    }

    public final boolean getAllowExpectedDeclarations() {
        return this.allowExpectedDeclarations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getAllowClassifiersAndPackagesForPossibleExtensionCallables() {
        KotlinRawPositionContext kotlinRawPositionContext = this.positionContext;
        if (!(kotlinRawPositionContext instanceof KotlinTypeNameReferencePositionContext)) return true;
        KotlinTypeNameReferencePositionContext kotlinTypeNameReferencePositionContext = (KotlinTypeNameReferencePositionContext)kotlinRawPositionContext;
        KotlinTypeNameReferencePositionContext kotlinTypeNameReferencePositionContext2 = kotlinTypeNameReferencePositionContext;
        if (kotlinTypeNameReferencePositionContext == null) return true;
        KtTypeReference ktTypeReference = kotlinTypeNameReferencePositionContext2.getTypeReference();
        kotlinTypeNameReferencePositionContext2 = ktTypeReference;
        if (ktTypeReference == null) return true;
        PsiElement psiElement2 = kotlinTypeNameReferencePositionContext2.getParent();
        if (psiElement2 == null) {
            return true;
        }
        PsiElement declaration2 = psiElement2;
        if (this.basicContext.getParameters().getInvocationCount() != 0) return true;
        if (!(declaration2 instanceof KtNamedFunction)) {
            if (!(declaration2 instanceof KtProperty)) return true;
        }
        if (((KotlinTypeNameReferencePositionContext)this.positionContext).getExplicitReceiver() != null) return true;
        String string = this.basicContext.getPrefixMatcher().getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        Character c = StringsKt.firstOrNull((CharSequence)string);
        if (c == null) return true;
        if (!Character.isLowerCase(c.charValue())) return true;
        return false;
    }

    private final FirBasicCompletionContext component1() {
        return this.basicContext;
    }

    private final KotlinRawPositionContext component2() {
        return this.positionContext;
    }

    @NotNull
    public final FirCompletionSessionParameters copy(@NotNull FirBasicCompletionContext basicContext, @NotNull KotlinRawPositionContext positionContext) {
        Intrinsics.checkNotNullParameter((Object)basicContext, (String)"basicContext");
        Intrinsics.checkNotNullParameter((Object)positionContext, (String)"positionContext");
        return new FirCompletionSessionParameters(basicContext, positionContext);
    }

    public static /* synthetic */ FirCompletionSessionParameters copy$default(FirCompletionSessionParameters firCompletionSessionParameters, FirBasicCompletionContext firBasicCompletionContext, KotlinRawPositionContext kotlinRawPositionContext, int n, Object object) {
        if ((n & 1) != 0) {
            firBasicCompletionContext = firCompletionSessionParameters.basicContext;
        }
        if ((n & 2) != 0) {
            kotlinRawPositionContext = firCompletionSessionParameters.positionContext;
        }
        return firCompletionSessionParameters.copy(firBasicCompletionContext, kotlinRawPositionContext);
    }

    @NotNull
    public String toString() {
        return "FirCompletionSessionParameters(basicContext=" + this.basicContext + ", positionContext=" + this.positionContext + ")";
    }

    public int hashCode() {
        int result2 = this.basicContext.hashCode();
        result2 = result2 * 31 + this.positionContext.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof FirCompletionSessionParameters)) {
            return false;
        }
        FirCompletionSessionParameters firCompletionSessionParameters = (FirCompletionSessionParameters)other2;
        if (!Intrinsics.areEqual((Object)this.basicContext, (Object)firCompletionSessionParameters.basicContext)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.positionContext, (Object)firCompletionSessionParameters.positionContext);
    }
}

