/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Range;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.FileApplicabilityChecker;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils$isInCrossInlineArgument$;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerLegacyFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J(\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017JM\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u00062\b\b\u0002\u0010\"\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b#J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001bH\u0007J>\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u001bH\u0002J\u0018\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u000208H\u0002J\u000e\u00109\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J9\u0010:\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000fH\u0000\u00a2\u0006\u0002\b<J\u0012\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010>*\u00020?J\f\u0010@\u001a\u00020\u0017*\u00020\u0017H\u0002J\n\u0010A\u001a\u00020\u0006*\u00020\u0017J\u0012\u0010B\u001a\u00020\u0017*\u00020\u00172\u0006\u0010C\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils;", "", "()V", "IR_BACKEND_LAMBDA_REGEX", "Lkotlin/text/Regex;", "<set-?>", "", "forceRanking", "getForceRanking", "()Z", "setForceRanking", "(Z)V", "chooseApplicableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "location", "Lcom/sun/jdi/Location;", "chooseApplicableFile$kotlin_jvm_debugger_core", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "findSourceFileForClassIncludeLibrarySources", "scope", "findSourceFilesForClass", "hasLocation", "classNameResolvesInline", "findSourceFilesForClass$kotlin_jvm_debugger_core", "getLocationsOfInlinedLine", "type", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "sourceSearchScope", "inlinedLinesNumbers", "", "inlineLineNumber", "inlineFileName", "destinationTypeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destinationFileName", "isApplicable", "file", "isCrossInlineArgument", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isInCrossInlineArgument", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isKotlinSourceFile", "tryFindFileByClassNameAndFileName", "sourceName", "tryFindFileByClassNameAndFileName$kotlin_jvm_debugger_core", "getBorders", "Lkotlin/ranges/ClosedRange;", "Lcom/sun/jdi/LocalVariable;", "getMethodNameWithoutMangling", "isGeneratedIrBackendLambdaMethodName", "trimIfMangledInBytecode", "isMangledInBytecode", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nDebuggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 7 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,294:1\n766#2:295\n857#2,2:296\n766#2:299\n857#2,2:300\n766#2:302\n857#2,2:303\n1549#2:305\n1620#2,3:306\n1360#2:313\n1446#2,5:314\n766#2:330\n857#2,2:331\n1360#2:333\n1446#2,5:334\n1#3:298\n15#4,2:309\n1247#5,2:311\n473#5:319\n28#6,2:320\n36#7,8:322\n*S KotlinDebug\n*F\n+ 1 DebuggerUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils\n*L\n100#1:295\n100#1:296,2\n101#1:299\n101#1:300,2\n143#1:302\n143#1:303,2\n177#1:305\n177#1:306,3\n226#1:313\n226#1:314,5\n275#1:330\n275#1:331,2\n276#1:333\n276#1:334,5\n212#1:309,2\n214#1:311,2\n230#1:319\n253#1:320,2\n253#1:322,8\n*E\n"})
public final class DebuggerUtils {
    @NotNull
    public static final DebuggerUtils INSTANCE = new DebuggerUtils();
    private static boolean forceRanking;
    @NotNull
    private static final Regex IR_BACKEND_LAMBDA_REGEX;

    private DebuggerUtils() {
    }

    public final boolean getForceRanking() {
        return forceRanking;
    }

    @TestOnly
    public final void setForceRanking(boolean bl) {
        forceRanking = bl;
    }

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project2, @NotNull GlobalSearchScope scope2, @NotNull JvmClassName className, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (KtFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(project2, scope2, className, fileName){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            {
                this.$project = $project;
                this.$scope = $scope;
                this.$className = $className;
                this.$fileName = $fileName;
                super(0);
            }

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
                objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, this.$project);
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName, null);
            }
        }));
    }

    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project2, @NotNull List<? extends GlobalSearchScope> scopes2, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        List<KtFile> files2 = this.findSourceFilesForClass$kotlin_jvm_debugger_core(project2, scopes2, className, fileName, location2 != null, false);
        return this.chooseApplicableFile$kotlin_jvm_debugger_core(files2, location2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtFile> findSourceFilesForClass$kotlin_jvm_debugger_core(@NotNull Project project2, @NotNull List<? extends GlobalSearchScope> scopes2, @NotNull JvmClassName className, @NotNull String fileName, boolean hasLocation, boolean classNameResolvesInline) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return CollectionsKt.emptyList();
        }
        if (DumbService.Companion.isDumb(project2) && FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != DumbModeAccessType.RELIABLE_DATA_ONLY) {
            return CollectionsKt.emptyList();
        }
        FqName fqName2 = className.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameForClassNameWithoutDollars(...)");
        FqName partFqName = fqName2;
        for (GlobalSearchScope globalSearchScope : scopes2) {
            List files2;
            List list2;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.findFilesByNameInPackage(className, fileName, project2, globalSearchScope);
            boolean $i$f$filter = false;
            void var13_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                boolean bl = false;
                if (!(JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)it)) || TargetPlatformKt.isCommon((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List $this$findSourceFilesForClass_u24lambda_u242 = (List)destination$iv$iv;
            boolean bl = false;
            if (classNameResolvesInline) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = $this$findSourceFilesForClass_u24lambda_u242;
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    KtFile it = (KtFile)element$iv$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.isApplicable(it, className)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = $this$findSourceFilesForClass_u24lambda_u242;
            }
            if ((files2 = list2).isEmpty()) continue;
            if (!hasLocation || files2.size() == 1 && !forceRanking) {
                return CollectionsKt.listOf((Object)CollectionsKt.first((List)files2));
            }
            KtFile singleFile2 = (KtFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(partFqName, project2, globalSearchScope, fileName){
                final /* synthetic */ FqName $partFqName;
                final /* synthetic */ Project $project;
                final /* synthetic */ GlobalSearchScope $scope;
                final /* synthetic */ String $fileName;
                {
                    this.$partFqName = $partFqName;
                    this.$project = $project;
                    this.$scope = $scope;
                    this.$fileName = $fileName;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final KtFile invoke() {
                    Object v1;
                    block2: {
                        void $this$singleOrNull$iv;
                        String string = this.$partFqName.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                        Collection<Key> matchingFiles = KotlinFileFacadeFqNameIndex.Helper.get(string, this.$project, this.$scope);
                        Iterable iterable = PackagePartClassUtils.getFilesWithCallables(matchingFiles);
                        String string2 = this.$fileName;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            KtFile it = (KtFile)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)string2)) continue;
                            if (found$iv) {
                                v1 = null;
                                break block2;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v1 = !found$iv ? null : single$iv;
                    }
                    return v1;
                }
            }));
            if (singleFile2 != null) {
                return CollectionsKt.listOf((Object)singleFile2);
            }
            return files2;
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List findSourceFilesForClass$kotlin_jvm_debugger_core$default(DebuggerUtils debuggerUtils, Project project2, List list2, JvmClassName jvmClassName, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return debuggerUtils.findSourceFilesForClass$kotlin_jvm_debugger_core(project2, list2, jvmClassName, string, bl, bl2);
    }

    @Nullable
    public final KtFile chooseApplicableFile$kotlin_jvm_debugger_core(@NotNull List<? extends KtFile> files2, @Nullable Location location2) {
        Object object;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (files2.isEmpty()) {
            return null;
        }
        if (location2 == null || files2.size() == 1 && !forceRanking) {
            return (KtFile)CollectionsKt.first(files2);
        }
        if (Registry.is((String)"kotlin.debugger.analysis.api.file.applicability.checker")) {
            object = FileApplicabilityChecker.INSTANCE.chooseMostApplicableFile(files2, location2);
        } else {
            object = KotlinDebuggerLegacyFacade.Companion.getInstance();
            if (object == null || (object = object.getFileSelector()) == null || (object = object.chooseMostApplicableFile(files2, location2)) == null) {
                object = FileApplicabilityChecker.INSTANCE.chooseMostApplicableFile(files2, location2);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className, String fileName, Project project2, GlobalSearchScope searchScope2) {
        void $this$filterTo$iv$iv;
        FqName fqName2 = className.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getPackageFqName(...)");
        Iterable $this$filter$iv = KotlinPackageIndexUtils.INSTANCE.findFilesWithExactPackage(fqName2, searchScope2, project2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)files2, (Comparator)JavaElementFinder.Companion.byClasspathComparator(searchScope2));
    }

    @NotNull
    public final List<KtFile> tryFindFileByClassNameAndFileName$kotlin_jvm_debugger_core(@NotNull Project project2, @NotNull JvmClassName className, @NotNull String sourceName2, @NotNull List<? extends GlobalSearchScope> scopes2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)sourceName2, (String)"sourceName");
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        String string = className.getFqNameForClassNameWithoutDollars().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fqn2 = string;
        for (GlobalSearchScope globalSearchScope : scopes2) {
            KtFile file2;
            PsiClass psiClass2;
            if (PositionManagerImpl.findClass((Project)project2, (String)fqn2, (GlobalSearchScope)globalSearchScope, (boolean)false) == null) continue;
            PsiFile psiFile2 = psiClass2.getContainingFile();
            KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile2 == null || !Intrinsics.areEqual((Object)(file2 = ktFile2).getName(), (Object)sourceName2)) continue;
            return CollectionsKt.listOf((Object)file2);
        }
        for (GlobalSearchScope globalSearchScope : scopes2) {
            PsiFile[] files2;
            Intrinsics.checkNotNullExpressionValue((Object)FilenameIndex.getFilesByName((Project)project2, (String)sourceName2, (GlobalSearchScope)globalSearchScope), (String)"getFilesByName(...)");
            if (files2.length == 0) continue;
            List collectedFiles = new ArrayList();
            int n = files2.length;
            for (int j = 0; j < n; ++j) {
                PsiFile file3 = files2[j];
                if (!(file3 instanceof KtFile) || !this.isApplicable((KtFile)file3, className)) continue;
                collectedFiles.add(file3);
            }
            if (!(!((Collection)collectedFiles).isEmpty())) continue;
            return collectedFiles;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isApplicable(KtFile file2, JvmClassName className) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ClassNameCalculator.INSTANCE.getClassNames(file2).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmNameUtilsKt.fqnToInternalName((String)it));
        }
        List classNames = (List)destination$iv$iv;
        String string = className.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        return DebuggerUtilsKt.isInnerClassOfAny(string, classNames);
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String extension2 = string3;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(extension2);
    }

    @NotNull
    public final String trimIfMangledInBytecode(@NotNull String $this$trimIfMangledInBytecode, boolean isMangledInBytecode) {
        Intrinsics.checkNotNullParameter((Object)$this$trimIfMangledInBytecode, (String)"<this>");
        return isMangledInBytecode ? this.getMethodNameWithoutMangling($this$trimIfMangledInBytecode) : $this$trimIfMangledInBytecode;
    }

    private final String getMethodNameWithoutMangling(String $this$getMethodNameWithoutMangling) {
        return StringsKt.substringBefore$default((String)$this$getMethodNameWithoutMangling, (char)'-', null, (int)2, null);
    }

    public final boolean isGeneratedIrBackendLambdaMethodName(@NotNull String $this$isGeneratedIrBackendLambdaMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedIrBackendLambdaMethodName, (String)"<this>");
        CharSequence charSequence = $this$isGeneratedIrBackendLambdaMethodName;
        return IR_BACKEND_LAMBDA_REGEX.matches(charSequence);
    }

    @Nullable
    public final ClosedRange<Location> getBorders(@NotNull LocalVariable $this$getBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$getBorders, (String)"<this>");
        Range range2 = DebuggerUtilsImpl.getLocalVariableBorders((LocalVariable)$this$getBorders);
        if (range2 == null) {
            return null;
        }
        Range range3 = range2;
        Comparable comparable = range3.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getFrom(...)");
        Comparable comparable2 = range3.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getTo(...)");
        return RangesKt.rangeTo((Comparable)comparable, (Comparable)comparable2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @ApiStatus.Internal
    @NotNull
    public final List<Location> getLocationsOfInlinedLine(@NotNull ReferenceType type2, @NotNull SourcePosition position, @NotNull GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        boolean isInCrossInlineArgument;
        boolean isInInline;
        KtElement ktElement;
        Object element$iv2;
        Project project2;
        int line;
        block8: {
            boolean bl;
            Object v4;
            PsiElement element3;
            block7: {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)sourceSearchScope, (String)"sourceSearchScope");
                line = position.getLine();
                PsiFile psiFile2 = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
                PsiFile file2 = psiFile2;
                Project project3 = position.getFile().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                project2 = project3;
                Integer n = PsiLinesUtilsKt.getLineStartOffset(file2, line);
                if (n == null) {
                    return CollectionsKt.emptyList();
                }
                int lineStartOffset = n;
                PsiElement psiElement2 = file2.findElementAt(lineStartOffset);
                if (psiElement2 == null) {
                    return CollectionsKt.emptyList();
                }
                element3 = psiElement2;
                Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv2 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv2 instanceof KtElement)) continue;
                    v4 = element$iv2;
                    break block7;
                }
                v4 = null;
            }
            KtElement ktElement2 = v4;
            if (ktElement2 == null) {
                return CollectionsKt.emptyList();
            }
            ktElement = ktElement2;
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)element3);
            boolean $i$f$any = false;
            for (Object element$iv2 : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv2;
                boolean bl2 = false;
                if (!(it instanceof KtFunction && ((KtFunction)it).hasModifier(KtTokens.INLINE_KEYWORD))) continue;
                bl = true;
                break block8;
            }
            bl = isInInline = false;
        }
        if (!isInInline && !(isInCrossInlineArgument = this.isInCrossInlineArgument(ktElement))) {
            return CollectionsKt.emptyList();
        }
        String string = position.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        FqName fqName2 = new FqName(type2.name());
        String string2 = type2.sourceName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceName(...)");
        List<Integer> lines = this.inlinedLinesNumbers(line + 1, string, fqName2, string2, project2, sourceSearchScope);
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            List list2 = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (int)it);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"locationsOfLineSync(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isInCrossInlineArgument(KtElement ktElement) {
        Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)ktElement));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isInCrossInlineArgument$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (KtFunction function2 : sequence2) {
            KtFunction ktFunction = function2;
            if (ktFunction instanceof KtFunctionLiteral) {
                KtLambdaExpression lambdaExpression2;
                PsiElement argumentExpression2;
                PsiElement psiElement2 = ((KtFunctionLiteral)function2).getParent();
                KtLambdaExpression ktLambdaExpression2 = psiElement2 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement2 : null;
                if (ktLambdaExpression2 == null || !((argumentExpression2 = (lambdaExpression2 = ktLambdaExpression2).getParent()) instanceof KtValueArgument) || !this.isCrossInlineArgument((KtExpression)lambdaExpression2)) continue;
                return true;
            }
            if (!(ktFunction instanceof KtNamedFunction) || !(((KtNamedFunction)function2).getParent() instanceof KtValueArgument) || !this.isCrossInlineArgument((KtExpression)function2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isCrossInlineArgument(KtExpression argumentExpression2) {
        boolean bl;
        void this_$iv$iv;
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)argumentExpression2);
        if (ktExpression == null) {
            return false;
        }
        KtExpression callExpression2 = ktExpression;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)callExpression2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)callExpression2);
        try {
            boolean bl2;
            KaSession $this$isCrossInlineArgument_u24lambda_u247 = analysisSession$iv$iv;
            boolean bl3 = false;
            KaLifetimeOwner kaLifetimeOwner = $this$isCrossInlineArgument_u24lambda_u247.resolveToCall((KtElement)callExpression2);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
                bl2 = false;
            } else {
                KaLifetimeOwner call2 = kaLifetimeOwner;
                KaLifetimeOwner kaLifetimeOwner2 = call2.getArgumentMapping().get(argumentExpression2);
                if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = (KaValueParameterSymbol)kaLifetimeOwner2.getSymbol()) == null) {
                    bl2 = false;
                } else {
                    KaLifetimeOwner parameter = kaLifetimeOwner2;
                    bl2 = ((KaValueParameterSymbol)parameter).isCrossinline();
                }
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)callExpression2);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> inlinedLinesNumbers(int inlineLineNumber, String inlineFileName, FqName destinationTypeFqName, String destinationFileName, Project project2, GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        String string = destinationTypeFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String internalName = JvmNameUtilsKt.fqnToInternalName(string);
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)internalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName jvmClassName2 = jvmClassName;
        KtFile ktFile2 = this.findSourceFileForClassIncludeLibrarySources(project2, sourceSearchScope, jvmClassName2, destinationFileName);
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile2;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        SMAP sMAP = KotlinSourceMapCache.Companion.getInstance(project2).getSourceMap(virtualFile3, jvmClassName2);
        if (sMAP == null) {
            return CollectionsKt.emptyList();
        }
        SMAP sourceMap = sMAP;
        Iterable $this$filter$iv = sourceMap.getFileMappings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)inlineFileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mappingsToInlinedFile = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = mappingsToInlinedFile;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLineMappings();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List mappingIntervals = (List)destination$iv$iv2;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)mappingIntervals), (Function1)((Function1)new Function1<RangeMapping, Boolean>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;
            {
                this.$inlineLineNumber = $inlineLineNumber;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.hasMappingForSource(this.$inlineLineNumber);
            }
        })), (Function1)((Function1)new Function1<RangeMapping, Integer>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;
            {
                this.$inlineLineNumber = $inlineLineNumber;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.mapSourceToDest(this.$inlineLineNumber);
            }
        })), (Function1)inlinedLinesNumbers.3.INSTANCE));
    }

    static {
        IR_BACKEND_LAMBDA_REGEX = new Regex(".+\\$lambda[$-]\\d+");
    }
}

