/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiMethod;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.builder.LightMemberOrigin;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerLegacyFacade;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ActualDeclarationProvider;
import org.jetbrains.kotlin.psi.KotlinDeclarationNavigationPolicy;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0002\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\tH\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\f*\u00020\u0011H\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"getMethodDescriptorInReadActionInSmartMode", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "document", "Lcom/intellij/openapi/editor/Document;", "resolveJvmMethodFromKotlinDeclaration", "Lcom/intellij/psi/PsiMethod;", "fetchNavigationElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "fetchOriginalElement", "getActualJvmDeclaration", "getMethodDescriptor", "getSourceOrigin", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "hasAppropriateKotlinOrigin", "", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFunctionBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n118#2:205\n118#2:206\n20#2,2:207\n48#3:209\n48#3:210\n1#4:211\n*S KotlinDebug\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointKt\n*L\n146#1:205\n184#1:206\n191#1:207,2\n200#1:209\n203#1:210\n*E\n"})
public final class KotlinFunctionBreakpointKt {
    @Nullable
    public static final MethodBreakpoint.MethodDescriptor getMethodDescriptor(@NotNull SourcePosition $this$getMethodDescriptor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$getMethodDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (MethodBreakpoint.MethodDescriptor)DumbService.Companion.getInstance(project2).runReadActionInSmartMode(() -> KotlinFunctionBreakpointKt.getMethodDescriptor$lambda$1(project2, $this$getMethodDescriptor));
    }

    private static final MethodBreakpoint.MethodDescriptor getMethodDescriptorInReadActionInSmartMode(Project project2, SourcePosition sourcePosition2, Document document) {
        PsiMethod psiMethod2 = KotlinFunctionBreakpointKt.resolveJvmMethodFromKotlinDeclaration(project2, sourcePosition2);
        if (psiMethod2 == null) {
            return null;
        }
        PsiMethod method = psiMethod2;
        if (!KotlinFunctionBreakpointKt.hasAppropriateKotlinOrigin(method, sourcePosition2, document)) {
            return null;
        }
        return KotlinFunctionBreakpointKt.getMethodDescriptor(method);
    }

    private static final boolean hasAppropriateKotlinOrigin(PsiMethod $this$hasAppropriateKotlinOrigin, SourcePosition sourcePosition2, Document document) {
        KtLightMethod ktLightMethod;
        PsiMethod $this$safeAs$iv = $this$hasAppropriateKotlinOrigin;
        boolean $i$f$safeAs = false;
        PsiMethod psiMethod2 = $this$safeAs$iv;
        if (!(psiMethod2 instanceof KtLightMethod)) {
            psiMethod2 = null;
        }
        if ((ktLightMethod = (KtLightMethod)psiMethod2) == null || (ktLightMethod = KotlinFunctionBreakpointKt.getSourceOrigin(ktLightMethod)) == null) {
            return true;
        }
        KtLightMethod kotlinOrigin = ktLightMethod;
        int offset2 = kotlinOrigin.getTextOffset();
        return DocumentUtil.isValidOffset((int)offset2, (Document)document) && document.getLineNumber(offset2) >= sourcePosition2.getLine();
    }

    private static final MethodBreakpoint.MethodDescriptor getMethodDescriptor(PsiMethod $this$getMethodDescriptor) {
        MethodBreakpoint.MethodDescriptor methodDescriptor;
        try {
            MethodBreakpoint.MethodDescriptor descriptor2 = new MethodBreakpoint.MethodDescriptor();
            descriptor2.methodName = JVMNameUtil.getJVMMethodName((PsiMethod)$this$getMethodDescriptor);
            descriptor2.methodSignature = JVMNameUtil.getJVMSignature((PsiMethod)$this$getMethodDescriptor);
            descriptor2.isStatic = $this$getMethodDescriptor.hasModifierProperty("static");
        }
        catch (IndexNotReadyException ignored) {
            methodDescriptor = null;
        }
        return methodDescriptor;
    }

    private static final KtDeclaration getSourceOrigin(KtLightMethod $this$getSourceOrigin) {
        LightMemberOrigin lightMemberOrigin = $this$getSourceOrigin.getLightMemberOrigin();
        if (lightMemberOrigin == null) {
            return null;
        }
        LightMemberOrigin lightMemberOrigin2 = lightMemberOrigin;
        KtDeclaration ktDeclaration = lightMemberOrigin2.getAuxiliaryOriginalElement();
        if (ktDeclaration == null && (ktDeclaration = lightMemberOrigin2.getOriginalElement()) == null) {
            return null;
        }
        KtDeclaration originalElement = ktDeclaration;
        KtElement ktElement = KotlinFunctionBreakpointKt.fetchNavigationElement(originalElement);
        KtDeclaration ktDeclaration2 = ktElement instanceof KtDeclaration ? (KtDeclaration)ktElement : null;
        if (ktDeclaration2 == null) {
            return null;
        }
        KtDeclaration sourceOrigin = ktDeclaration2;
        if (sourceOrigin.getContainingFile() instanceof KtClsFile) {
            return null;
        }
        return sourceOrigin;
    }

    private static final PsiMethod resolveJvmMethodFromKotlinDeclaration(Project project2, SourcePosition sourcePosition2) {
        Object v6;
        block8: {
            KtDeclaration ktDeclaration = (KtDeclaration)PositionUtil.getPsiElementAt((Project)project2, KtDeclaration.class, (SourcePosition)sourcePosition2);
            if (ktDeclaration == null) {
                return null;
            }
            KtDeclaration declaration2 = ktDeclaration;
            if (KotlinPsiUtils.isExpectDeclaration(declaration2)) {
                KtDeclaration ktDeclaration2 = KotlinFunctionBreakpointKt.getActualJvmDeclaration(declaration2);
                if (ktDeclaration2 == null) {
                    return null;
                }
                declaration2 = ktDeclaration2;
            }
            if (declaration2 instanceof KtClass) {
                KtPrimaryConstructor constructor2 = ((KtClass)declaration2).getPrimaryConstructor();
                if (constructor2 == null) {
                    Object[] lightClass;
                    KtDeclaration $this$safeAs$iv = declaration2;
                    boolean $i$f$safeAs = false;
                    KtDeclaration ktDeclaration3 = $this$safeAs$iv;
                    if (!(ktDeclaration3 instanceof KtClassOrObject)) {
                        ktDeclaration3 = null;
                    }
                    KtClassOrObject ktClassOrObject = (KtClassOrObject)ktDeclaration3;
                    Object[] objectArray = lightClass = ktClassOrObject != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)ktClassOrObject) : null;
                    return lightClass != null && (objectArray = objectArray.getConstructors()) != null ? (PsiMethod)ArraysKt.firstOrNull((Object[])objectArray) : null;
                }
                declaration2 = (KtDeclaration)constructor2;
            }
            KtElement ktElement = KotlinFunctionBreakpointKt.fetchOriginalElement(declaration2);
            if (ktElement == null) {
                return null;
            }
            KtElement originalDeclaration = ktElement;
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)originalDeclaration);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiMethod)) continue;
                v6 = element$iv;
                break block8;
            }
            v6 = null;
        }
        return v6;
    }

    private static final KtDeclaration getActualJvmDeclaration(KtDeclaration $this$getActualJvmDeclaration) {
        ActualDeclarationProvider actualDeclarationProvider;
        KotlinDebuggerLegacyFacade kotlinDebuggerLegacyFacade = KotlinDebuggerLegacyFacade.Companion.getInstance();
        return kotlinDebuggerLegacyFacade != null && (actualDeclarationProvider = kotlinDebuggerLegacyFacade.getActualDeclarationProvider()) != null ? actualDeclarationProvider.getActualJvmDeclaration($this$getActualJvmDeclaration) : null;
    }

    private static final KtElement fetchNavigationElement(KtDeclaration $this$fetchNavigationElement) {
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy = (KotlinDeclarationNavigationPolicy)(application != null ? application.getService(KotlinDeclarationNavigationPolicy.class) : null);
        return kotlinDeclarationNavigationPolicy != null ? kotlinDeclarationNavigationPolicy.getNavigationElement($this$fetchNavigationElement) : null;
    }

    private static final KtElement fetchOriginalElement(KtDeclaration $this$fetchOriginalElement) {
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy = (KotlinDeclarationNavigationPolicy)(application != null ? application.getService(KotlinDeclarationNavigationPolicy.class) : null);
        return kotlinDeclarationNavigationPolicy != null ? kotlinDeclarationNavigationPolicy.getOriginalElement($this$fetchOriginalElement) : null;
    }

    private static final MethodBreakpoint.MethodDescriptor getMethodDescriptor$lambda$1(Project $project, SourcePosition $this_getMethodDescriptor) {
        Object object;
        MethodBreakpoint.MethodDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$this_getMethodDescriptor, (String)"$this_getMethodDescriptor");
        Document document = PsiDocumentManager.getInstance((Project)$project).getDocument($this_getMethodDescriptor.getFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        MethodBreakpoint.MethodDescriptor methodDescriptor = descriptor2 = KotlinFunctionBreakpointKt.getMethodDescriptorInReadActionInSmartMode($project, $this_getMethodDescriptor, document2);
        if (methodDescriptor != null) {
            MethodBreakpoint.MethodDescriptor methodDescriptor2;
            MethodBreakpoint.MethodDescriptor it = methodDescriptor2 = methodDescriptor;
            boolean bl = false;
            object = it.methodName != null && it.methodSignature != null ? methodDescriptor2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ KtDeclaration access$getActualJvmDeclaration(KtDeclaration $receiver) {
        return KotlinFunctionBreakpointKt.getActualJvmDeclaration($receiver);
    }
}

