/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ThreadReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineFilter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo;", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "coroutineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "(Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;)V", "realThread", "", "getRealThread", "()Ljava/lang/Void;", "checkSameThread", "", "thread", "Lcom/sun/jdi/ThreadReference;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineJobInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineJobInfo.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,43:1\n23#2:44\n*S KotlinDebug\n*F\n+ 1 CoroutineJobInfo.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo\n*L\n21#1:44\n*E\n"})
public final class CoroutineJobInfo
implements LightOrRealThreadInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineFilter coroutineFilter;
    @Nullable
    private final Void realThread;

    public CoroutineJobInfo(@NotNull CoroutineFilter coroutineFilter) {
        Intrinsics.checkNotNullParameter((Object)coroutineFilter, (String)"coroutineFilter");
        this.coroutineFilter = coroutineFilter;
    }

    @Nullable
    public Void getRealThread() {
        return this.realThread;
    }

    public boolean checkSameThread(@NotNull ThreadReference thread, @NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        CoroutineFilter nextCoroutineFilter = CoroutineJobInfo.Companion.getCoroutineFilter(suspendContext);
        CoroutineJobInfo $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineJobInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Check thread filter: need " + this.coroutineFilter + ", current is " + nextCoroutineFilter);
        return nextCoroutineFilter != null && this.coroutineFilter.canRunTo(nextCoroutineFilter);
    }

    private final CoroutineFilter component1() {
        return this.coroutineFilter;
    }

    @NotNull
    public final CoroutineJobInfo copy(@NotNull CoroutineFilter coroutineFilter) {
        Intrinsics.checkNotNullParameter((Object)coroutineFilter, (String)"coroutineFilter");
        return new CoroutineJobInfo(coroutineFilter);
    }

    public static /* synthetic */ CoroutineJobInfo copy$default(CoroutineJobInfo coroutineJobInfo, CoroutineFilter coroutineFilter, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineFilter = coroutineJobInfo.coroutineFilter;
        }
        return coroutineJobInfo.copy(coroutineFilter);
    }

    @NotNull
    public String toString() {
        return "CoroutineJobInfo(coroutineFilter=" + this.coroutineFilter + ")";
    }

    public int hashCode() {
        return this.coroutineFilter.hashCode();
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof CoroutineJobInfo)) {
            return false;
        }
        CoroutineJobInfo coroutineJobInfo = (CoroutineJobInfo)other2;
        return Intrinsics.areEqual((Object)this.coroutineFilter, (Object)coroutineJobInfo.coroutineFilter);
    }

    @JvmStatic
    private static final CoroutineFilter getCoroutineFilter(SuspendContextImpl suspendContext) {
        return CoroutineJobInfo.Companion.getCoroutineFilter(suspendContext);
    }

    @JvmStatic
    @Nullable
    public static final LightOrRealThreadInfo extractJobInfo(@NotNull SuspendContextImpl suspendContext) {
        return Companion.extractJobInfo(suspendContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo$Companion;", "", "()V", "extractJobInfo", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "getCoroutineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "kotlin.jvm-debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCoroutineJobInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineJobInfo.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final CoroutineFilter getCoroutineFilter(SuspendContextImpl suspendContext) {
            StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
            return stackFrameInterceptor != null ? stackFrameInterceptor.extractCoroutineFilter(suspendContext) : null;
        }

        @JvmStatic
        @Nullable
        public final LightOrRealThreadInfo extractJobInfo(@NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            if (!Registry.is((String)"debugger.filter.breakpoints.by.coroutine.id")) {
                return null;
            }
            try {
                CoroutineJobInfo coroutineJobInfo;
                CoroutineFilter coroutineFilter = this.getCoroutineFilter(suspendContext);
                if (coroutineFilter != null) {
                    CoroutineFilter it = coroutineFilter;
                    boolean bl = false;
                    coroutineJobInfo = new CoroutineJobInfo(it);
                } else {
                    coroutineJobInfo = null;
                }
                return coroutineJobInfo;
            }
            catch (Throwable e) {
                DebuggerUtilsImpl.logError((Throwable)e);
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

