/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RealThreadInfo;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.statistics.Engine;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.debugger.statistics.SteppingAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.XSourcePosition;
import com.sun.jdi.Location;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineJobInfo;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u0013\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001c\u0010\u0016\u001a\u00060\u0017R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/DebuggerSteppingHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createRunToCursorCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "ignoreBreakpoints", "", "createStepIntoCommand", "methodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "createStepOutCommand", "createStepOverCommand", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "createStepOverCommandForSuspendSwitch", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepOverCommand;", "nextCallAfterResume", "", "kotlin.jvm-debugger.core"})
public final class DebuggerSteppingHelper {
    @NotNull
    public static final DebuggerSteppingHelper INSTANCE = new DebuggerSteppingHelper();
    @NotNull
    private static final Logger LOG;

    private DebuggerSteppingHelper() {
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable SourcePosition sourcePosition2) {
        DebugProcessImpl debugProcess;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        DebugProcessImpl $this$createStepOverCommand_u24lambda_u240 = debugProcess = debugProcessImpl;
        boolean bl = false;
        return new DebugProcessImpl.ResumeCommand($this$createStepOverCommand_u24lambda_u240, suspendContext, debugProcess, ignoreBreakpoints){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ boolean $ignoreBreakpoints;
            {
                this.$debugProcess = $debugProcess;
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                super($receiver, $suspendContext);
            }

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                Location location2;
                StackFrameProxyImpl frameProxy;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext.getFrameProxy();
                Location location3 = location2 = stackFrameProxyImpl != null ? SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl) : null;
                if (location2 != null) {
                    try {
                        KotlinSteppingCommandProviderKt.getStepOverAction(location2, suspendContext, frameProxy).createCommand(this.$debugProcess, suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
                        return;
                    }
                    catch (Exception e) {
                        DebuggerSteppingHelper.access$getLOG$p().error((Throwable)e);
                    }
                }
                this.$debugProcess.createStepOverCommand(suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.StepOverCommand createStepOverCommandForSuspendSwitch(@NotNull SuspendContextImpl suspendContext, int nextCallAfterResume) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepOverCommandForSuspendSwitch_u24lambda_u241 = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.StepOverCommand($this$createStepOverCommandForSuspendSwitch_u24lambda_u241, suspendContext, nextCallAfterResume){
            final /* synthetic */ int $nextCallAfterResume;
            {
                this.$nextCallAfterResume = $nextCallAfterResume;
                Intrinsics.checkNotNull((Object)$receiver);
                super($receiver, $suspendContext, false, null, -1);
            }

            @NotNull
            public RequestHint getHint(@NotNull SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                MethodFilter methodFilter = this.myMethodFilter;
                RequestHint hint2 = new RequestHint(stepThread, suspendContext, parentHint, this.$nextCallAfterResume, methodFilter){
                    final /* synthetic */ int $nextCallAfterResume;
                    {
                        this.$nextCallAfterResume = $nextCallAfterResume;
                        super($stepThread, $suspendContext, -1, 2, $super_call_param$1, $parentHint);
                    }

                    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
                        boolean bl = stackFrameProxyImpl != null ? DebuggerUtil.isOnSuspensionPoint(stackFrameProxyImpl) : false;
                        if (bl) {
                            Location location2 = context2.getLocation();
                            if (location2 == null) {
                                return super.getNextStepDepth(context2);
                            }
                            Location currentLocation = location2;
                            if (currentLocation.codeIndex() < (long)this.$nextCallAfterResume) {
                                return 2;
                            }
                            if (currentLocation.codeIndex() == (long)this.$nextCallAfterResume) {
                                return 0;
                            }
                        }
                        return super.getNextStepDepth(context2);
                    }
                };
                hint2.setIgnoreFilters(suspendContext.getDebugProcess().getSession().shouldIgnoreSteppingFilters());
                return hint2;
            }

            @NotNull
            public Object createCommandToken() {
                return StatisticsStorage.Companion.createSteppingToken(SteppingAction.STEP_OVER, Engine.KOTLIN);
            }
        };
    }

    public static /* synthetic */ DebugProcessImpl.StepOverCommand createStepOverCommandForSuspendSwitch$default(DebuggerSteppingHelper debuggerSteppingHelper, SuspendContextImpl suspendContextImpl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return debuggerSteppingHelper.createStepOverCommandForSuspendSwitch(suspendContextImpl, n);
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createStepOutCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepOutCommand_u24lambda_u242 = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.ResumeCommand($this$createStepOutCommand_u24lambda_u242, suspendContext, ignoreBreakpoints){
            final /* synthetic */ boolean $ignoreBreakpoints;
            {
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                Intrinsics.checkNotNull((Object)$receiver);
                super($receiver, $suspendContext);
            }

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                Location location2;
                StackFrameProxyImpl frameProxy;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext.getFrameProxy();
                Location location3 = location2 = stackFrameProxyImpl != null ? SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl) : null;
                if (location2 != null) {
                    try {
                        KotlinStepAction kotlinStepAction = KotlinSteppingCommandProviderKt.getStepOutAction(location2, frameProxy);
                        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
                        kotlinStepAction.createCommand(debugProcessImpl, suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
                        return;
                    }
                    catch (Exception e) {
                        DebuggerSteppingHelper.access$getLOG$p().error((Throwable)e);
                    }
                }
                suspendContext.getDebugProcess().createStepOutCommand(suspendContext).contextAction(suspendContext);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createStepIntoCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepIntoCommand_u24lambda_u243 = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.ResumeCommand($this$createStepIntoCommand_u24lambda_u243, suspendContext, methodFilter, ignoreBreakpoints){
            final /* synthetic */ MethodFilter $methodFilter;
            final /* synthetic */ boolean $ignoreBreakpoints;
            {
                this.$methodFilter = $methodFilter;
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                Intrinsics.checkNotNull((Object)$receiver);
                super($receiver, $suspendContext);
            }

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                try {
                    KotlinStepAction.KotlinStepInto kotlinStepInto = new KotlinStepAction.KotlinStepInto(this.$methodFilter);
                    DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
                    Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
                    kotlinStepInto.createCommand(debugProcessImpl, suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
                }
                catch (Exception e) {
                    suspendContext.getDebugProcess().createStepIntoCommand(suspendContext, this.$ignoreBreakpoints, this.$methodFilter).contextAction(suspendContext);
                }
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createRunToCursorCommand(@NotNull SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        DebugProcessImpl debugProcess;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        DebugProcessImpl $this$createRunToCursorCommand_u24lambda_u244 = debugProcess = debugProcessImpl;
        boolean bl = false;
        return (DebugProcessImpl.ResumeCommand)new DebugProcessImpl.RunToCursorCommand($this$createRunToCursorCommand_u24lambda_u244, suspendContext, position, ignoreBreakpoints){
            @NotNull
            private final Lazy<LightOrRealThreadInfo> myThreadFilter;
            {
                this.myThreadFilter = LazyKt.lazy((Function0)((Function0)new Function0<LightOrRealThreadInfo>($suspendContext, this){
                    final /* synthetic */ SuspendContextImpl $suspendContext;
                    final /* synthetic */ createRunToCursorCommand.1.1 this$0;
                    {
                        this.$suspendContext = $suspendContext;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final LightOrRealThreadInfo invoke() {
                        LightOrRealThreadInfo lightOrRealThreadInfo = CoroutineJobInfo.Companion.extractJobInfo(this.$suspendContext);
                        if (lightOrRealThreadInfo == null) {
                            lightOrRealThreadInfo = createRunToCursorCommand.1.1.access$getThreadFilterFromContext$s1330956911(this.this$0, this.$suspendContext);
                        }
                        return lightOrRealThreadInfo;
                    }
                }));
            }

            @NotNull
            public final Lazy<LightOrRealThreadInfo> getMyThreadFilter() {
                return this.myThreadFilter;
            }

            public void contextAction(@NotNull SuspendContextImpl context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!(this.myThreadFilter.getValue() instanceof RealThreadInfo)) {
                    context2.getDebugProcess().getSession().clearSteppingThrough();
                }
                super.contextAction(context2);
            }

            @Nullable
            public LightOrRealThreadInfo getThreadFilterFromContext(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                return (LightOrRealThreadInfo)this.myThreadFilter.getValue();
            }

            public static final /* synthetic */ LightOrRealThreadInfo access$getThreadFilterFromContext$s1330956911(createRunToCursorCommand.1.1 $this, SuspendContextImpl p0) {
                return super.getThreadFilterFromContext(p0);
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(DebuggerSteppingHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

