/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.statistics.Engine;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.debugger.statistics.SteppingAction;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineJobInfo;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepIntoRequestHint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepOutRequestHint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepOverRequestHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ4\u0010\u0010\u001a\u00060\u0011R\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J6\u0010\u0015\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepActionFactory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createKotlinStepIntoCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepIntoCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "methodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "createKotlinStepOverCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepOverCommand;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinMethodFilter;", "stepSize", "", "createStepIntoCommand", "ignoreFilters", "createStepOutCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepOutCommand;", "getThreadFilterFromContextForStepping", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "kotlin.jvm-debugger.core"})
public final class KotlinStepActionFactory {
    @NotNull
    public static final KotlinStepActionFactory INSTANCE = new KotlinStepActionFactory();
    @NotNull
    private static final Logger LOG;

    private KotlinStepActionFactory() {
    }

    @NotNull
    public final DebugProcessImpl.StepOverCommand createKotlinStepOverCommand(@NotNull DebugProcessImpl debugProcess, @Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull KotlinMethodFilter methodFilter, int stepSize) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)methodFilter, (String)"methodFilter");
        DebugProcessImpl $this$createKotlinStepOverCommand_u24lambda_u240 = debugProcess;
        boolean bl = false;
        return new DebugProcessImpl.StepOverCommand($this$createKotlinStepOverCommand_u24lambda_u240, suspendContext, ignoreBreakpoints, methodFilter, stepSize, debugProcess){
            final /* synthetic */ boolean $ignoreBreakpoints;
            final /* synthetic */ KotlinMethodFilter $methodFilter;
            final /* synthetic */ int $stepSize;
            final /* synthetic */ DebugProcessImpl $debugProcess;
            {
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                this.$methodFilter = $methodFilter;
                this.$stepSize = $stepSize;
                this.$debugProcess = $debugProcess;
                super($receiver, $suspendContext, $ignoreBreakpoints, (MethodFilter)$methodFilter, $stepSize);
            }

            @NotNull
            protected String getStatusText() {
                return KotlinDebuggerCoreBundle.message("stepping.over.inline", new Object[0]);
            }

            @Nullable
            public LightOrRealThreadInfo getThreadFilterFromContext(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                LightOrRealThreadInfo lightOrRealThreadInfo = KotlinStepActionFactory.access$getThreadFilterFromContextForStepping(KotlinStepActionFactory.INSTANCE, suspendContext);
                if (lightOrRealThreadInfo == null) {
                    lightOrRealThreadInfo = super.getThreadFilterFromContext(suspendContext);
                }
                return lightOrRealThreadInfo;
            }

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Location location2 = suspendContext.getLocation();
                if (location2 != null) {
                    Location it = location2;
                    boolean bl2 = false;
                    bl = DebuggerUtil.isInSuspendMethod(it);
                } else {
                    bl = false;
                }
                if (bl) {
                    CoroutineBreakpointFacility.INSTANCE.installResumeBreakpointInCurrentMethod(suspendContext);
                    this.applyThreadFilter(this.getThreadFilterFromContext(suspendContext));
                }
                super.contextAction(suspendContext);
            }

            @NotNull
            public RequestHint getHint(@NotNull SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                KotlinStepOverRequestHint hint2 = new KotlinStepOverRequestHint(stepThread, suspendContext, this.$methodFilter, parentHint, this.$stepSize);
                hint2.setResetIgnoreFilters(!this.$debugProcess.getSession().shouldIgnoreSteppingFilters());
                hint2.setRestoreBreakpoints(this.$ignoreBreakpoints);
                try {
                    this.$debugProcess.getSession().setIgnoreStepFiltersFlag(stepThread.frameCount());
                }
                catch (EvaluateException e) {
                    KotlinStepActionFactory.access$getLOG$p().info((Throwable)e);
                }
                return hint2;
            }

            @NotNull
            public Object createCommandToken() {
                return StatisticsStorage.Companion.createSteppingToken(SteppingAction.STEP_OVER, Engine.KOTLIN);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.StepIntoCommand createKotlinStepIntoCommand(@NotNull DebugProcessImpl debugProcess, @Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebugProcessImpl $this$createKotlinStepIntoCommand_u24lambda_u241 = debugProcess;
        boolean bl = false;
        return new DebugProcessImpl.StepIntoCommand($this$createKotlinStepIntoCommand_u24lambda_u241, suspendContext, ignoreBreakpoints, methodFilter, debugProcess){
            final /* synthetic */ MethodFilter $methodFilter;
            final /* synthetic */ DebugProcessImpl $debugProcess;
            {
                this.$methodFilter = $methodFilter;
                this.$debugProcess = $debugProcess;
                super($receiver, $suspendContext, $ignoreBreakpoints, $methodFilter, -2);
            }

            @NotNull
            public RequestHint getHint(@NotNull SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                KotlinStepIntoRequestHint hint2 = new KotlinStepIntoRequestHint(stepThread, suspendContext, this.$methodFilter, parentHint);
                hint2.setResetIgnoreFilters(this.myMethodFilter != null && !this.$debugProcess.getSession().shouldIgnoreSteppingFilters());
                return hint2;
            }

            @Nullable
            public LightOrRealThreadInfo getThreadFilterFromContext(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                LightOrRealThreadInfo lightOrRealThreadInfo = KotlinStepActionFactory.access$getThreadFilterFromContextForStepping(KotlinStepActionFactory.INSTANCE, suspendContext);
                if (lightOrRealThreadInfo == null) {
                    lightOrRealThreadInfo = super.getThreadFilterFromContext(suspendContext);
                }
                return lightOrRealThreadInfo;
            }

            @NotNull
            public Object createCommandToken() {
                return StatisticsStorage.Companion.createSteppingToken(SteppingAction.STEP_INTO, Engine.KOTLIN);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.StepIntoCommand createStepIntoCommand(@NotNull DebugProcessImpl debugProcess, @Nullable SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter methodFilter, int stepSize) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebugProcessImpl $this$createStepIntoCommand_u24lambda_u242 = debugProcess;
        boolean bl = false;
        return new DebugProcessImpl.StepIntoCommand($this$createStepIntoCommand_u24lambda_u242, suspendContext, ignoreFilters, methodFilter, stepSize, debugProcess){
            final /* synthetic */ MethodFilter $methodFilter;
            final /* synthetic */ int $stepSize;
            final /* synthetic */ DebugProcessImpl $debugProcess;
            {
                this.$methodFilter = $methodFilter;
                this.$stepSize = $stepSize;
                this.$debugProcess = $debugProcess;
                super($receiver, $suspendContext, $ignoreFilters, $methodFilter, $stepSize);
            }

            @NotNull
            public RequestHint getHint(@NotNull SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                RequestHint hint2 = new KotlinRequestHint(stepThread, suspendContext, this.$stepSize, 1, this.$methodFilter, parentHint);
                hint2.setResetIgnoreFilters(this.myMethodFilter != null && !this.$debugProcess.getSession().shouldIgnoreSteppingFilters());
                return hint2;
            }

            @NotNull
            public Object createCommandToken() {
                return StatisticsStorage.Companion.createSteppingToken(SteppingAction.STEP_INTO, Engine.KOTLIN);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.StepOutCommand createStepOutCommand(@NotNull DebugProcessImpl debugProcess, @Nullable SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebugProcessImpl $this$createStepOutCommand_u24lambda_u243 = debugProcess;
        boolean bl = false;
        return new DebugProcessImpl.StepOutCommand($this$createStepOutCommand_u24lambda_u243, suspendContext, debugProcess){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            {
                this.$debugProcess = $debugProcess;
                super($receiver, $suspendContext, -2);
            }

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Location location2 = suspendContext.getLocation();
                if (location2 != null) {
                    Location it = location2;
                    boolean bl2 = false;
                    bl = DebuggerUtil.isInSuspendMethod(it);
                } else {
                    bl = false;
                }
                if (bl) {
                    CoroutineBreakpointFacility.INSTANCE.installResumeBreakpointInCallerMethod(suspendContext);
                    this.applyThreadFilter(this.getThreadFilterFromContext(suspendContext));
                }
                super.contextAction(suspendContext);
            }

            @NotNull
            public RequestHint getHint(@NotNull SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                int n;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                Location location2 = suspendContext.getLocation();
                if (location2 != null) {
                    Location it = location2;
                    boolean bl2 = false;
                    bl = DebuggerUtil.isInSuspendMethod(it);
                } else {
                    bl = false;
                }
                if (bl) {
                    StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
                    n = DebuggerUtil.getLocationOfCoroutineSuspendReturn(stackFrameInterceptor != null ? stackFrameInterceptor.callerLocation(suspendContext) : null);
                } else {
                    n = -1;
                }
                int suspendReturnIndex = n;
                RequestHint hint2 = new KotlinStepOutRequestHint(suspendReturnIndex, stepThread, suspendContext, -1, 3, null, parentHint);
                hint2.setIgnoreFilters(this.$debugProcess.getSession().shouldIgnoreSteppingFilters());
                return hint2;
            }

            @Nullable
            public LightOrRealThreadInfo getThreadFilterFromContext(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                LightOrRealThreadInfo lightOrRealThreadInfo = KotlinStepActionFactory.access$getThreadFilterFromContextForStepping(KotlinStepActionFactory.INSTANCE, suspendContext);
                if (lightOrRealThreadInfo == null) {
                    lightOrRealThreadInfo = super.getThreadFilterFromContext(suspendContext);
                }
                return lightOrRealThreadInfo;
            }

            @NotNull
            public Object createCommandToken() {
                return StatisticsStorage.Companion.createSteppingToken(SteppingAction.STEP_OUT, Engine.KOTLIN);
            }
        };
    }

    private final LightOrRealThreadInfo getThreadFilterFromContextForStepping(SuspendContextImpl suspendContext) {
        Location location2 = suspendContext.getLocation();
        if (location2 != null && DebuggerUtil.isInSuspendMethod(location2)) {
            return CoroutineJobInfo.Companion.extractJobInfo(suspendContext);
        }
        return null;
    }

    public static final /* synthetic */ LightOrRealThreadInfo access$getThreadFilterFromContextForStepping(KotlinStepActionFactory $this, SuspendContextImpl suspendContext) {
        return $this.getThreadFilterFromContextForStepping(suspendContext);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(KotlinStepActionFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

