/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOutRequestHint;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHint;", "returnAfterSuspendIndex", "", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "stepSize", "depth", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "Lcom/intellij/debugger/engine/RequestHint;", "(ILcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;IILcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "getNextStepDepth", "context", "kotlin.jvm-debugger.core"})
public final class KotlinStepOutRequestHint
extends KotlinRequestHint {
    private final int returnAfterSuspendIndex;

    public KotlinStepOutRequestHint(int returnAfterSuspendIndex, @NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, int stepSize, int depth2, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        super(stepThread, suspendContext, stepSize, depth2, filter2, parentHint);
        this.returnAfterSuspendIndex = returnAfterSuspendIndex;
    }

    @Override
    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Location currentLocation = context2.getLocation();
        if (currentLocation != null) {
            if (currentLocation.codeIndex() < (long)this.returnAfterSuspendIndex) {
                return 2;
            }
            if (currentLocation.codeIndex() == (long)this.returnAfterSuspendIndex) {
                return -100;
            }
        }
        return super.getNextStepDepth(context2);
    }
}

