/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ2\u0010\f\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0012\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0012\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0017\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0017\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProvider;", "Lcom/intellij/debugger/impl/JvmSteppingCommandProvider;", "()V", "getRunToCursorCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "ignoreBreakpoints", "", "getStepIntoCommand", "ignoreFilters", "smartStepFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "stepSize", "", "getStepOutCommand", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "debugContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getStepOverCommand", "kotlin.jvm-debugger.core"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = KotlinSteppingCommandProviderKt.access$getSourcePosition(suspendContext);
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (!(sourcePosition3.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition3);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepIntoCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = KotlinSteppingCommandProviderKt.access$getSourcePosition(suspendContext);
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (!(sourcePosition3.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getRunToCursorCommand(@Nullable SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        if (!Registry.is((String)"debugger.filter.breakpoints.by.coroutine.id")) {
            return null;
        }
        return DebuggerSteppingHelper.INSTANCE.createRunToCursorCommand(suspendContext, position, ignoreBreakpoints);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepIntoCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        return DebuggerSteppingHelper.INSTANCE.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return DebuggerSteppingHelper.INSTANCE.createStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition2);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOutCommand(@NotNull SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debugContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)debugContext, (String)"debugContext");
        SourcePosition sourcePosition2 = debugContext.getSourcePosition();
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"getSourcePosition(...)");
        return this.getStepOutCommand(suspendContext, sourcePosition2);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = suspendContext.getDebugProcess().getDebuggerContext().getSourcePosition();
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (!(sourcePosition3.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepOutCommand(suspendContext, sourcePosition3);
    }

    private final DebugProcessImpl.ResumeCommand getStepOutCommand(SuspendContextImpl suspendContext, SourcePosition sourcePosition2) {
        if (sourcePosition2.getLine() < 0) {
            return null;
        }
        return DebuggerSteppingHelper.INSTANCE.createStepOutCommand(suspendContext, true);
    }
}

