/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XNamedValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CompleteCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolder;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxysKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder;", "", "()V", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineFrameBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();
    private static final int PRE_FETCH_FRAME_COUNT = 5;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u001e\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$H\u0002J\u0018\u0010%\u001a\u0004\u0018\u00010\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180$H\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J(\u0010(\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0$\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0$0)2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180$\u0012\u0004\u0012\u00020\u00140)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion;", "", "()V", "PRE_FETCH_FRAME_COUNT", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "build", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion$CoroutineFrameItemLists;", "coroutine", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "preflightFrame", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutinePreflightFrame;", "withPreFrames", "", "buildRealStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "buildStackFrameForActive", "coroutineExitFrame", "extractContinuation", "Lcom/sun/jdi/ObjectReference;", "mode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendExitMode;", "getLVTContinuation", "getThisContinuation", "isFirstSuspendFrame", "frameIndex", "frames", "", "lookForTheFollowingFrame", "theFollowingFrames", "lookupContinuation", "restoredStackTrace", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "CoroutineFrameItemLists", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineFrameBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineFrameBuilder.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1569#2,11:219\n1864#2,2:230\n1866#2:233\n1580#2:234\n748#2,10:235\n731#2,4:245\n735#2,5:250\n1#3:232\n1#3:249\n*S KotlinDebug\n*F\n+ 1 CoroutineFrameBuilder.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion\n*L\n69#1:219,11\n69#1:230,2\n69#1:233\n69#1:234\n85#1:235,10\n96#1:245,4\n96#1:250,5\n69#1:232\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @Nullable
        public final CoroutineFrameItemLists build(@NotNull CoroutineInfoData coroutine, @NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)coroutine, (String)"coroutine");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            return coroutine.isRunning() ? this.buildStackFrameForActive(coroutine, suspendContext) : (coroutine.isSuspended() ? new CoroutineFrameItemLists(coroutine.getContinuationStackFrames(), coroutine.getCreationStackFrames()) : null);
        }

        private final CoroutineFrameItemLists buildStackFrameForActive(CoroutineInfoData coroutine, SuspendContextImpl suspendContext) {
            ThreadReference threadReference = coroutine.getActiveThread();
            if (threadReference == null) {
                return null;
            }
            ThreadReference activeThread = threadReference;
            List coroutineStackFrameList = new ArrayList();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = new ThreadReferenceProxyImpl(suspendContext.getDebugProcess().getVirtualMachineProxy(), activeThread);
            List list2 = threadReferenceProxyImpl.forceFrames();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"forceFrames(...)");
            List realFrames = list2;
            for (StackFrameProxyImpl runningStackFrameProxy : realFrames) {
                RunningCoroutineStackFrameItem it;
                Intrinsics.checkNotNull((Object)runningStackFrameProxy);
                CoroutinePreflightFrame preflightStackFrame = this.coroutineExitFrame(runningStackFrameProxy, suspendContext);
                if (preflightStackFrame != null) {
                    StackFrameProxyImpl stackFrameProxyImpl = preflightStackFrame.getStackFrameProxy();
                    Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getStackFrameProxy(...)");
                    RunningCoroutineStackFrameItem runningCoroutineStackFrameItem = this.buildRealStackFrameItem(stackFrameProxyImpl);
                    if (runningCoroutineStackFrameItem != null) {
                        it = runningCoroutineStackFrameItem;
                        boolean bl = false;
                        coroutineStackFrameList.add(it);
                    }
                    CoroutineFrameItemLists coroutineFrameLists = org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder$Companion.build$default(this, preflightStackFrame, suspendContext, false, 4, null);
                    coroutineStackFrameList.addAll((Collection)coroutineFrameLists.getFrames());
                    return new CoroutineFrameItemLists(coroutineStackFrameList, coroutine.getCreationStackFrames());
                }
                if (this.buildRealStackFrameItem(runningStackFrameProxy) == null) continue;
                boolean bl = false;
                coroutineStackFrameList.add(it);
            }
            return new CoroutineFrameItemLists(coroutineStackFrameList, coroutine.getCreationStackFrames());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CoroutineFrameItemLists build(@NotNull CoroutinePreflightFrame preflightFrame, @NotNull SuspendContextImpl suspendContext, boolean withPreFrames) {
            Intrinsics.checkNotNullParameter((Object)((Object)preflightFrame), (String)"preflightFrame");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            List stackFrames = new ArrayList();
            List restoredStackTrace = (List)this.restoredStackTrace(preflightFrame).component1();
            stackFrames.addAll(restoredStackTrace);
            if (withPreFrames) {
                void $this$mapIndexedNotNullTo$iv$iv;
                void $this$mapIndexedNotNull$iv;
                List<StackFrameProxyImpl> framesLeft = preflightFrame.getThreadPreCoroutineFrames();
                Iterable iterable = framesLeft;
                List list2 = stackFrames;
                boolean $i$f$mapIndexedNotNull = false;
                void var9_10 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    RunningCoroutineStackFrameItem it$iv$iv;
                    void element$iv$iv;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl = false;
                    StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)element$iv$iv;
                    boolean bl2 = false;
                    if ((RunningCoroutineStackFrameItem)((Object)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<RunningCoroutineStackFrameItem>(stackFrameProxyImpl){
                        final /* synthetic */ StackFrameProxyImpl $stackFrameProxyImpl;
                        {
                            this.$stackFrameProxyImpl = $stackFrameProxyImpl;
                            super(0);
                        }

                        @Nullable
                        public final RunningCoroutineStackFrameItem invoke() {
                            return org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder$Companion.access$buildRealStackFrameItem(CoroutineFrameBuilder.Companion, this.$stackFrameProxyImpl);
                        }
                    })) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2.addAll((List)destination$iv$iv);
            }
            return new CoroutineFrameItemLists(stackFrames, preflightFrame.getCoroutineInfoData().getCreationStackFrames());
        }

        public static /* synthetic */ CoroutineFrameItemLists build$default(Companion companion, CoroutinePreflightFrame coroutinePreflightFrame, SuspendContextImpl suspendContextImpl, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.build(coroutinePreflightFrame, suspendContextImpl, bl);
        }

        private final Pair<List<CoroutineStackFrameItem>, List<XNamedValue>> restoredStackTrace(CoroutinePreflightFrame preflightFrame) {
            List list2;
            boolean bl;
            CoroutineStackFrameItem it;
            Location preflightFrameLocation = preflightFrame.getStackFrameProxy().location();
            List<CoroutineStackFrameItem> coroutineStackFrame = preflightFrame.getCoroutineInfoData().getContinuationStackFrames();
            StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)CollectionsKt.firstOrNull(preflightFrame.getThreadPreCoroutineFrames());
            Location preCoroutineTopFrameLocation = stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null;
            List variablesRemovedFromTopRestoredFrame = new ArrayList();
            Iterable $this$dropWhile$iv = coroutineStackFrame;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (CoroutineStackFrameItem)((Object)item$iv);
                boolean bl2 = false;
                boolean $this$restoredStackTrace_u24lambda_u244_u24lambda_u243 = bl = CoroutineUtilsKt.isFilterFromTop(it.getLocation(), preflightFrameLocation);
                boolean bl3 = false;
                if ($this$restoredStackTrace_u24lambda_u244_u24lambda_u243) {
                    variablesRemovedFromTopRestoredFrame.addAll((Collection)it.getSpilledVariables());
                }
                if (bl) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List stripTopStackTrace = list$iv;
            List variablesRemovedFromBottomRestoredFrame = new ArrayList();
            if (preCoroutineTopFrameLocation == null) {
                list2 = stripTopStackTrace;
            } else {
                List $this$dropLastWhile$iv = stripTopStackTrace;
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        it = (CoroutineStackFrameItem)((Object)iterator$iv.previous());
                        boolean bl4 = false;
                        boolean $this$restoredStackTrace_u24lambda_u246_u24lambda_u245 = bl = CoroutineUtilsKt.isFilterFromBottom(it.getLocation(), preCoroutineTopFrameLocation);
                        boolean bl5 = false;
                        variablesRemovedFromBottomRestoredFrame.addAll((Collection)it.getSpilledVariables());
                        if (bl) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
            }
            List restoredFrames = list2;
            return new Pair((Object)restoredFrames, (Object)variablesRemovedFromBottomRestoredFrame);
        }

        private final RunningCoroutineStackFrameItem buildRealStackFrameItem(StackFrameProxyImpl frame) {
            Location location2 = frame.location();
            if (location2 == null) {
                return null;
            }
            Location location3 = location2;
            return !CoroutineUtilsKt.safeCoroutineExitPointLineNumber(location3) ? new RunningCoroutineStackFrameItem(CoroutineStackFrameProxysKt.safeSkipCoroutineStackFrameProxy(frame), location3, null, 4, null) : null;
        }

        @Nullable
        public final CoroutinePreflightFrame coroutineExitFrame(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            return (CoroutinePreflightFrame)((Object)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<CoroutinePreflightFrame>(suspendContext, frame){
                final /* synthetic */ SuspendContextImpl $suspendContext;
                final /* synthetic */ StackFrameProxyImpl $frame;
                {
                    this.$suspendContext = $suspendContext;
                    this.$frame = $frame;
                    super(0);
                }

                @Nullable
                public final CoroutinePreflightFrame invoke() {
                    return CoroutineFrameBuilder.Companion.lookupContinuation(this.$suspendContext, this.$frame);
                }
            }));
        }

        @Nullable
        public final CoroutinePreflightFrame lookupContinuation(@NotNull SuspendContextImpl suspendContext, @NotNull StackFrameProxyImpl frame) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            SuspendExitMode mode = CoroutineUtilsKt.getSuspendExitMode(frame);
            if (!mode.isCoroutineFound()) {
                return null;
            }
            Pair<List<StackFrameProxyImpl>, Boolean> pair = this.theFollowingFrames(frame);
            List theFollowingFrames = (List)pair.component1();
            boolean isFirstSuspendFrame = (Boolean)pair.component2();
            if (mode.isSuspendMethodParameter()) {
                if (!((Collection)theFollowingFrames).isEmpty()) {
                    if (this.lookForTheFollowingFrame(theFollowingFrames) == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            ObjectReference objectReference = this.extractContinuation(frame, mode);
            if (objectReference == null) {
                return null;
            }
            ObjectReference continuation2 = objectReference;
            if (CoroutineUtilsKt.threadAndContextSupportsEvaluation(suspendContext, frame)) {
                DefaultExecutionContext context2 = new DefaultExecutionContext(suspendContext, frame);
                ContinuationHolder continuationHolder = ContinuationHolder.Companion.instance(context2);
                CompleteCoroutineInfoData completeCoroutineInfoData = continuationHolder.extractCoroutineInfoData(continuation2);
                if (completeCoroutineInfoData == null) {
                    return null;
                }
                CompleteCoroutineInfoData coroutineInfo = completeCoroutineInfoData;
                return new CoroutinePreflightFrame(coroutineInfo, frame, theFollowingFrames, mode, isFirstSuspendFrame, coroutineInfo.getTopFrameVariables());
            }
            return null;
        }

        private final StackFrameProxyImpl lookForTheFollowingFrame(List<? extends StackFrameProxyImpl> theFollowingFrames) {
            int n = Integer.min(5, theFollowingFrames.size());
            for (int i2 = 0; i2 < n; ++i2) {
                StackFrameProxyImpl nextFrame = theFollowingFrames.get(i2);
                if (CoroutineUtilsKt.getSuspendExitMode(nextFrame) == SuspendExitMode.NONE) continue;
                return nextFrame;
            }
            return null;
        }

        private final ObjectReference getLVTContinuation(StackFrameProxyImpl frame) {
            StackFrameProxyImpl stackFrameProxyImpl = frame;
            return stackFrameProxyImpl != null ? CoroutineUtilsKt.continuationVariableValue(stackFrameProxyImpl) : null;
        }

        private final ObjectReference getThisContinuation(StackFrameProxyImpl frame) {
            StackFrameProxyImpl stackFrameProxyImpl = frame;
            return stackFrameProxyImpl != null ? CoroutineUtilsKt.thisVariableValue(stackFrameProxyImpl) : null;
        }

        private final Pair<List<StackFrameProxyImpl>, Boolean> theFollowingFrames(StackFrameProxyImpl frame) {
            List list2 = frame.threadProxy().frames();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"frames(...)");
            List frames = list2;
            int indexOfCurrentFrame = frames.indexOf(frame);
            if (indexOfCurrentFrame >= 0) {
                int indexOfGetCoroutineSuspended = CoroutineUtilsKt.hasGetCoroutineSuspended(frames);
                if (indexOfGetCoroutineSuspended < 0 && frames.size() > indexOfCurrentFrame + 1) {
                    return new Pair((Object)CollectionsKt.drop((Iterable)frames, (int)(indexOfCurrentFrame + 1)), (Object)this.isFirstSuspendFrame(indexOfCurrentFrame, frames));
                }
            } else {
                this.getLog().error("Frame isn't found on the thread stack.");
            }
            return new Pair((Object)CollectionsKt.emptyList(), (Object)true);
        }

        private final ObjectReference extractContinuation(StackFrameProxyImpl frame, SuspendExitMode mode) {
            return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1 -> this.getThisContinuation(frame);
                case 2 -> this.getLVTContinuation(frame);
                default -> null;
            };
        }

        private final boolean isFirstSuspendFrame(int frameIndex, List<? extends StackFrameProxyImpl> frames) {
            int index = frameIndex;
            while (index > 0) {
                StackFrameProxyImpl frame;
                if (CoroutineUtilsKt.getSuspendExitMode(frame = frames.get(--index)) == SuspendExitMode.NONE) {
                    return true;
                }
                if (this.extractContinuation(frame, CoroutineUtilsKt.getSuspendExitMode(frame)) == null) continue;
                return false;
            }
            return true;
        }

        public static final /* synthetic */ RunningCoroutineStackFrameItem access$buildRealStackFrameItem(Companion $this, StackFrameProxyImpl frame) {
            return $this.buildRealStackFrameItem(frame);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion$CoroutineFrameItemLists;", "", "frames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "creationFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "(Ljava/util/List;Ljava/util/List;)V", "getCreationFrames", "()Ljava/util/List;", "getFrames", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
        public static final class CoroutineFrameItemLists {
            @NotNull
            private final List<CoroutineStackFrameItem> frames;
            @NotNull
            private final List<CreationCoroutineStackFrameItem> creationFrames;

            public CoroutineFrameItemLists(@NotNull List<? extends CoroutineStackFrameItem> frames, @NotNull List<CreationCoroutineStackFrameItem> creationFrames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
                this.frames = frames;
                this.creationFrames = creationFrames;
            }

            @NotNull
            public final List<CoroutineStackFrameItem> getFrames() {
                return this.frames;
            }

            @NotNull
            public final List<CreationCoroutineStackFrameItem> getCreationFrames() {
                return this.creationFrames;
            }

            @NotNull
            public final List<CoroutineStackFrameItem> component1() {
                return this.frames;
            }

            @NotNull
            public final List<CreationCoroutineStackFrameItem> component2() {
                return this.creationFrames;
            }

            @NotNull
            public final CoroutineFrameItemLists copy(@NotNull List<? extends CoroutineStackFrameItem> frames, @NotNull List<CreationCoroutineStackFrameItem> creationFrames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
                return new CoroutineFrameItemLists(frames, creationFrames);
            }

            public static /* synthetic */ CoroutineFrameItemLists copy$default(CoroutineFrameItemLists coroutineFrameItemLists, List list2, List list3, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = coroutineFrameItemLists.frames;
                }
                if ((n & 2) != 0) {
                    list3 = coroutineFrameItemLists.creationFrames;
                }
                return coroutineFrameItemLists.copy(list2, list3);
            }

            @NotNull
            public String toString() {
                return "CoroutineFrameItemLists(frames=" + this.frames + ", creationFrames=" + this.creationFrames + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.frames).hashCode();
                result2 = result2 * 31 + ((Object)this.creationFrames).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof CoroutineFrameItemLists)) {
                    return false;
                }
                CoroutineFrameItemLists coroutineFrameItemLists = (CoroutineFrameItemLists)other2;
                if (!Intrinsics.areEqual(this.frames, coroutineFrameItemLists.frames)) {
                    return false;
                }
                return Intrinsics.areEqual(this.creationFrames, coroutineFrameItemLists.creationFrames);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SuspendExitMode.values().length];
                try {
                    nArray[SuspendExitMode.SUSPEND_LAMBDA.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SuspendExitMode.SUSPEND_METHOD_PARAMETER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

