/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextTuner;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilder;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK2CodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "()V", "createCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createPresentationCodeFragment", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluatorBuilder;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "isContextAccepted", "", "contextElement", "kotlin.jvm-debugger.evaluation"})
public final class KotlinK2CodeFragmentFactory
extends CodeFragmentFactory {
    @NotNull
    public JavaCodeFragment createCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiElement contextElement = CodeFragmentContextTuner.Companion.getInstance().tuneContextElement(context2);
        String string = item.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return (JavaCodeFragment)new KtBlockCodeFragment(project2, "fragment.kt", (CharSequence)string, item.getImports(), contextElement);
    }

    @NotNull
    public JavaCodeFragment createPresentationCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.createCodeFragment(item, context2, project2);
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        PsiElement psiElement2 = contextElement;
        return Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getLanguage() : null), (Object)KotlinFileType.INSTANCE.getLanguage());
    }

    @NotNull
    public KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    public KotlinEvaluatorBuilder getEvaluatorBuilder() {
        return KotlinEvaluatorBuilder.INSTANCE;
    }
}

