/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ,\u0010\u001d\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J,\u0010\u001f\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 \u00b2\u0006\f\u0010!\u001a\u0004\u0018\u00010\"X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer;", "", "targets", "", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Ljava/util/List;Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "functionCounter", "", "", "", "targetWasVisited", "", "getUnvisitedTargets", "matchesBySignature", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "owner", "signature", "primaryConstructorMatches", "Lorg/jetbrains/kotlin/psi/KtClass;", "name", "visitInlineFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitOrdinaryFunction", "matches", "currentCount", "shouldBeVisited", "kotlin.jvm-debugger.core-fe10", "lightClassMethod", "Lcom/intellij/psi/PsiMethod;"})
@SourceDebugExtension(value={"SMAP\nKotlinSmartStepTargetFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmartStepTargetFilterer.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n28#2,2:162\n28#2,2:179\n36#3,8:164\n36#3,8:181\n350#4,7:172\n777#4:189\n788#4:190\n1864#4,2:191\n789#4,2:193\n1866#4:195\n791#4:196\n*S KotlinDebug\n*F\n+ 1 KotlinSmartStepTargetFilterer.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer\n*L\n35#1:162,2\n90#1:179,2\n35#1:164,8\n90#1:181,8\n40#1:172,7\n97#1:189\n97#1:190\n97#1:191,2\n97#1:193,2\n97#1:195\n97#1:196\n*E\n"})
public final class KotlinSmartStepTargetFilterer {
    @NotNull
    private final List<KotlinMethodSmartStepTarget> targets;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final Map<String, Integer> functionCounter;
    @NotNull
    private final boolean[] targetWasVisited;

    public KotlinSmartStepTargetFilterer(@NotNull List<KotlinMethodSmartStepTarget> targets, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.targets = targets;
        this.debugProcess = debugProcess;
        this.functionCounter = new LinkedHashMap();
        int n = 0;
        int n2 = this.targets.size();
        boolean[] blArray = new boolean[n2];
        KotlinSmartStepTargetFilterer kotlinSmartStepTargetFilterer = this;
        while (n < n2) {
            int n3 = n++;
            blArray[n3] = false;
        }
        kotlinSmartStepTargetFilterer.targetWasVisited = blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void visitInlineFunction(@NotNull KtNamedFunction function2) {
        int matchedSteppingTargetIndex;
        block7: {
            int n;
            Object $this$visitInlineFunction_u24lambda_u240;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            boolean $i$f$analyze = false;
            Project project2 = ((KtElement)function2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)function2);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)function2);
            try {
                $this$visitInlineFunction_u24lambda_u240 = analysisSession$iv$iv;
                boolean bl = false;
                KaFunctionSymbol symbol2 = $this$visitInlineFunction_u24lambda_u240.getSymbol(function2);
                $this$visitInlineFunction_u24lambda_u240 = KotlinMethodSmartStepTarget.Companion.calcLabel((KaSession)$this$visitInlineFunction_u24lambda_u240, symbol2);
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)function2);
            }
            Object label2 = $this$visitInlineFunction_u24lambda_u240;
            int currentCount = KotlinSmartStepTargetFiltererKt.access$increment(this.functionCounter, (String)label2) - 1;
            List<KotlinMethodSmartStepTarget> $this$indexOfFirst$iv = this.targets;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<KotlinMethodSmartStepTarget> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinMethodSmartStepTarget item$iv;
                KotlinMethodSmartStepTarget it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getDeclaration() == function2 && it.getOrdinal() == currentCount) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = matchedSteppingTargetIndex = -1;
        }
        if (matchedSteppingTargetIndex < 0) {
            return;
        }
        this.targetWasVisited[matchedSteppingTargetIndex] = true;
    }

    public final void visitOrdinaryFunction(@NotNull String owner, @NotNull String name2, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        int currentCount = KotlinSmartStepTargetFiltererKt.access$increment(this.functionCounter, owner + "." + name2 + signature) - 1;
        Iterator<KotlinMethodSmartStepTarget> iterator2 = this.targets.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            KotlinMethodSmartStepTarget target2 = iterator2.next();
            if (!this.shouldBeVisited(target2, owner, name2, signature, currentCount)) continue;
            this.targetWasVisited[i2] = true;
            break;
        }
    }

    private final boolean shouldBeVisited(KotlinMethodSmartStepTarget $this$shouldBeVisited, String owner, String name2, String signature, int currentCount) {
        String actualName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(name2, $this$shouldBeVisited.getMethodInfo().isNameMangledInBytecode());
        String updatedSignature = $this$shouldBeVisited.getMethodInfo().isInlineClassMember() ? KotlinSmartStepTargetFiltererKt.access$getSignatureWithoutFirstArgument(signature) : signature;
        return this.matches($this$shouldBeVisited, owner, actualName, updatedSignature, currentCount);
    }

    private final boolean matches(KotlinMethodSmartStepTarget $this$matches, String owner, String name2, String signature, int currentCount) {
        if (Intrinsics.areEqual((Object)$this$matches.getMethodInfo().getName(), (Object)name2) && $this$matches.getOrdinal() == currentCount) {
            KtDeclaration ktDeclaration = $this$matches.getDeclaration();
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration declaration2 = ktDeclaration;
            if (declaration2 instanceof KtClass) {
                return this.primaryConstructorMatches((KtClass)declaration2, owner, name2, signature);
            }
            Lazy lightClassMethod$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiMethod>(declaration2){
                final /* synthetic */ KtDeclaration $declaration;
                {
                    this.$declaration = $declaration;
                    super(0);
                }

                @Nullable
                public final PsiMethod invoke() {
                    return KotlinSmartStepTargetFiltererKt.access$getLightClassMethod(this.$declaration);
                }
            }));
            if ($this$matches.getMethodInfo().isInlineClassMember() || KotlinSmartStepTargetFilterer.matches$lambda$2((Lazy<? extends PsiMethod>)lightClassMethod$delegate) == null) {
                return this.matchesBySignature(declaration2, owner, signature);
            }
            PsiMethod psiMethod2 = KotlinSmartStepTargetFilterer.matches$lambda$2((Lazy<? extends PsiMethod>)lightClassMethod$delegate);
            Intrinsics.checkNotNull((Object)psiMethod2);
            return KotlinSmartStepTargetFiltererKt.access$matches(psiMethod2, owner, name2, signature, this.debugProcess);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean primaryConstructorMatches(KtClass declaration2, String owner, String name2, String signature) {
        if (!Intrinsics.areEqual((Object)name2, (Object)"<init>")) return false;
        if (!Intrinsics.areEqual((Object)signature, (Object)"()V")) return false;
        FqName fqName2 = declaration2.getFqName();
        if (!Intrinsics.areEqual((Object)JvmNameUtilsKt.internalNameToFqn(owner), (Object)(fqName2 != null ? fqName2.asString() : null))) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean matchesBySignature(KtDeclaration declaration2, String owner, String signature) {
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)declaration2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)declaration2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)declaration2);
        try {
            KaFunctionSymbol kaFunctionSymbol;
            KaSession $this$matchesBySignature_u24lambda_u243 = analysisSession$iv$iv;
            boolean bl = false;
            KaDeclarationSymbol kaDeclarationSymbol = $this$matchesBySignature_u24lambda_u243.getSymbol(declaration2);
            if ((kaDeclarationSymbol instanceof KaFunctionSymbol ? (KaFunctionSymbol)kaDeclarationSymbol : null) == null) {
                boolean bl2 = false;
                return bl2;
            }
            KaFunctionSymbol symbol2 = kaFunctionSymbol;
            boolean bl3 = Intrinsics.areEqual((Object)owner, (Object)JvmNameUtilKt.getJvmInternalClassName($this$matchesBySignature_u24lambda_u243, symbol2)) && Intrinsics.areEqual((Object)signature, (Object)KotlinSmartStepTargetFiltererKt.access$getJvmSignature(symbol2, $this$matchesBySignature_u24lambda_u243));
            return bl3;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)declaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinMethodSmartStepTarget> getUnvisitedTargets() {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv = this.targets;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            KotlinMethodSmartStepTarget cfr_ignored_0 = (KotlinMethodSmartStepTarget)element$iv$iv;
            int i2 = index$iv$iv;
            boolean bl2 = false;
            if (!(!this.targetWasVisited[i2])) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PsiMethod matches$lambda$2(Lazy<? extends PsiMethod> $lightClassMethod$delegate) {
        Lazy<? extends PsiMethod> lazy = $lightClassMethod$delegate;
        return (PsiMethod)lazy.getValue();
    }
}

