/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.scopes.KaScope;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertyAccessorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfoKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfoKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodReferenceSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor$createKotlinLambdaInfo$;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor$findDelegatedMethod$;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitorKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\\B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J6\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J)\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u00020\u001f\u00a2\u0006\u0002\u0010$J+\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u00020\u001f\u00a2\u0006\u0002\u0010&J\u001c\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u001b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020!H\u0002R\u00020\u001f\u00a2\u0006\u0002\u00100J!\u00101\u001a\u00020\u00122\u0006\u0010/\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002R\u00020\u001f\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020(H\u0002J\u0018\u0010:\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u0014H\u0002J!\u0010<\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010/\u001a\u000202H\u0002R\u00020\u001f\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\n2\u0006\u0010\u0013\u001a\u000207H\u0016J\u0010\u0010E\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\n2\u0006\u00109\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020YH\u0016J\f\u0010Z\u001a\u00020,*\u00020[H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "lines", "Lcom/intellij/util/Range;", "", "consumer", "Lcom/intellij/util/containers/OrderedSet;", "Lcom/intellij/debugger/actions/SmartStepTarget;", "(Lcom/intellij/util/Range;Lcom/intellij/util/containers/OrderedSet;)V", "append", "", "target", "appendPropertyFilter", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "label", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkLineRangeFits", "", "lineRange", "Lkotlin/ranges/IntRange;", "countExistingMethodCalls", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "createJavaLambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "methodSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "argumentSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiMethod;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;)Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "createKotlinLambdaInfo", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;)Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "findDelegatedMethod", "Lorg/jetbrains/kotlin/psi/KtFunction;", "delegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "targetType", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor$KtNameReferenceExpressionUsage;", "getFunctionDeclaration", "Lcom/intellij/psi/PsiElement;", "symbol", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;)Lcom/intellij/psi/PsiElement;", "propertyAccessLabel", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol;", "propertyAccessSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Ljava/lang/String;", "recordCallableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "recordFunction", "function", "recordFunctionCall", "highlightExpression", "recordProperty", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol;)Z", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallableReferenceExpression", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "computeTargetType", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "KtNameReferenceExpressionUsage", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nSmartStepTargetVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartStepTargetVisitor.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n28#2,2:408\n28#2,2:419\n28#2,2:459\n28#2,2:469\n36#3,8:410\n36#3,8:421\n36#3,8:461\n36#3,7:471\n43#3:481\n473#4:418\n473#4:429\n381#4,11:430\n1747#5,3:441\n800#5,11:444\n1774#5,4:455\n1747#5,3:478\n1#6:482\n*S KotlinDebug\n*F\n+ 1 SmartStepTargetVisitor.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor\n*L\n60#1:408,2\n207#1:419,2\n322#1:459,2\n333#1:469,2\n60#1:410,8\n207#1:421,8\n322#1:461,8\n333#1:471,7\n333#1:481\n149#1:418\n241#1:429\n242#1:430,11\n251#1:441,3\n262#1:444,11\n262#1:455,4\n336#1:478,3\n*E\n"})
public final class SmartStepTargetVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Range<Integer> lines;
    @NotNull
    private final OrderedSet<SmartStepTarget> consumer;

    public SmartStepTargetVisitor(@NotNull Range<Integer> lines, @NotNull OrderedSet<SmartStepTarget> consumer) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.lines = lines;
        this.consumer = consumer;
    }

    private final void append(SmartStepTarget target2) {
        ((Collection)this.consumer).add(target2);
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)lambdaExpression2))) {
            KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            this.recordFunction((KtFunction)ktFunctionLiteral);
        }
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)function2)) && !this.recordFunction((KtFunction)function2)) {
            super.visitNamedFunction(function2);
        }
    }

    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)expression2)) && !this.recordCallableReference(expression2)) {
            super.visitCallableReferenceExpression(expression2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean recordCallableReference(KtCallableReferenceExpression expression2) {
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)expression2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression2);
        try {
            KaSymbol kaSymbol;
            KaSession $this$recordCallableReference_u24lambda_u240 = analysisSession$iv$iv;
            boolean bl = false;
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
            if ($this$recordCallableReference_u24lambda_u240.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression)) == null) {
                boolean bl2 = false;
                return bl2;
            }
            KaSymbol symbol2 = kaSymbol;
            if (symbol2 instanceof KaPropertySymbol) {
                boolean bl3 = this.recordProperty($this$recordCallableReference_u24lambda_u240, (KtExpression)expression2, (KaPropertySymbol)symbol2);
                return bl3;
            }
            if (symbol2 instanceof KaNamedFunctionSymbol) {
                PsiElement psiElement2;
                if (symbol2.getPsi() == null) {
                    boolean bl4 = false;
                    return bl4;
                }
                PsiElement declaration2 = psiElement2;
                if (declaration2 instanceof PsiMethod) {
                    this.append((SmartStepTarget)new MethodSmartStepTarget((PsiMethod)declaration2, null, (PsiElement)expression2, true, this.lines));
                    boolean bl5 = true;
                    return bl5;
                }
                if (declaration2 instanceof KtNamedFunction) {
                    String label2 = KotlinMethodSmartStepTarget.Companion.calcLabel($this$recordCallableReference_u24lambda_u240, (KaDeclarationSymbol)symbol2);
                    this.append(new KotlinMethodReferenceSmartStepTarget(this.lines, expression2, label2, (KtDeclarationWithBody)declaration2, CallableMemberInfoKt.CallableMemberInfo$default($this$recordCallableReference_u24lambda_u240, (KaFunctionSymbol)symbol2, 0, null, 12, null)));
                    boolean bl6 = true;
                    return bl6;
                }
            }
            boolean bl7 = false;
            return bl7;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression2);
        }
    }

    private final boolean recordProperty(KaSession $context_receiver_0, KtExpression expression2, KaPropertySymbol symbol2) {
        KtNameReferenceExpressionUsage targetType;
        KtNameReferenceExpression ktNameReferenceExpression = expression2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)expression2 : null;
        KtNameReferenceExpressionUsage ktNameReferenceExpressionUsage = targetType = ktNameReferenceExpression != null ? this.computeTargetType(ktNameReferenceExpression) : null;
        if (symbol2 instanceof KaSyntheticJavaPropertySymbol) {
            KtNameReferenceExpressionUsage ktNameReferenceExpressionUsage2 = targetType;
            KaNamedFunctionSymbol kaNamedFunctionSymbol = switch (ktNameReferenceExpressionUsage2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ktNameReferenceExpressionUsage2.ordinal()]) {
                case -1, 1, 2 -> ((KaSyntheticJavaPropertySymbol)symbol2).getJavaGetterSymbol();
                case 3 -> ((KaSyntheticJavaPropertySymbol)symbol2).getJavaSetterSymbol();
                default -> throw new NoWhenBranchMatchedException();
            };
            if (kaNamedFunctionSymbol == null) {
                return false;
            }
            KaNamedFunctionSymbol propertyAccessSymbol = kaNamedFunctionSymbol;
            PsiElement declaration2 = propertyAccessSymbol.getPsi();
            if (declaration2 instanceof PsiMethod) {
                this.append((SmartStepTarget)new MethodSmartStepTarget((PsiMethod)declaration2, null, (PsiElement)expression2, true, this.lines));
                return true;
            }
            return false;
        }
        KtNameReferenceExpressionUsage ktNameReferenceExpressionUsage3 = targetType;
        KaPropertyAccessorSymbol kaPropertyAccessorSymbol = switch (ktNameReferenceExpressionUsage3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ktNameReferenceExpressionUsage3.ordinal()]) {
            case -1, 1, 2 -> symbol2.getGetter();
            case 3 -> symbol2.getSetter();
            default -> throw new NoWhenBranchMatchedException();
        };
        if (kaPropertyAccessorSymbol == null) {
            return false;
        }
        KaPropertyAccessorSymbol propertyAccessSymbol = kaPropertyAccessorSymbol;
        if (propertyAccessSymbol.isDefault()) {
            return false;
        }
        if (symbol2.isDelegatedProperty()) {
            PsiElement psiElement2 = symbol2.getPsi();
            KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
            if (ktProperty == null) {
                return false;
            }
            KtProperty property2 = ktProperty;
            KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
            if (ktPropertyDelegate == null) {
                return false;
            }
            KtPropertyDelegate delegate = ktPropertyDelegate;
            KtFunction ktFunction = this.findDelegatedMethod(delegate, targetType);
            if (ktFunction == null) {
                return false;
            }
            KtFunction delegatedMethod = ktFunction;
            KaDeclarationSymbol kaDeclarationSymbol = $context_receiver_0.getSymbol((KtDeclaration)delegatedMethod);
            KaFunctionSymbol kaFunctionSymbol = kaDeclarationSymbol instanceof KaFunctionSymbol ? (KaFunctionSymbol)kaDeclarationSymbol : null;
            if (kaFunctionSymbol == null) {
                return false;
            }
            KaFunctionSymbol delegatedSymbol = kaFunctionSymbol;
            CallableMemberInfo methodInfo = CallableMemberInfoKt.CallableMemberInfo$default($context_receiver_0, delegatedSymbol, this.countExistingMethodCalls((KtDeclaration)delegatedMethod), null, 8, null);
            String label2 = this.propertyAccessLabel($context_receiver_0, symbol2, delegatedSymbol);
            this.appendPropertyFilter(methodInfo, (KtDeclarationWithBody)delegatedMethod, label2, expression2, this.lines);
            return true;
        }
        PsiElement delegatedMethod = propertyAccessSymbol.getPsi();
        KtDeclaration ktDeclaration = delegatedMethod instanceof KtDeclaration ? (KtDeclaration)delegatedMethod : null;
        if (ktDeclaration == null) {
            return false;
        }
        KtDeclaration property3 = ktDeclaration;
        if (property3 instanceof KtPropertyAccessor && ((KtPropertyAccessor)property3).hasBody()) {
            Name name2;
            if (targetType == KtNameReferenceExpressionUsage.PROPERTY_SETTER) {
                name2 = $context_receiver_0.getJavaSetterName(symbol2);
                if (name2 == null) {
                    return false;
                }
            } else {
                name2 = $context_receiver_0.getJavaGetterName(symbol2);
            }
            Name methodName = name2;
            KaFunctionSymbol kaFunctionSymbol = propertyAccessSymbol;
            int n = this.countExistingMethodCalls(property3);
            String string = methodName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            CallableMemberInfo methodInfo = CallableMemberInfoKt.CallableMemberInfo($context_receiver_0, kaFunctionSymbol, n, string);
            String label3 = this.propertyAccessLabel($context_receiver_0, symbol2, propertyAccessSymbol);
            this.appendPropertyFilter(methodInfo, (KtDeclarationWithBody)property3, label3, expression2, this.lines);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunction findDelegatedMethod(KtPropertyDelegate delegate, KtNameReferenceExpressionUsage targetType) {
        void $this$filterIsInstance$iv;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)delegate));
        if (ktReference == null) {
            return null;
        }
        KtReference reference2 = ktReference;
        String expectedMethodName = targetType == KtNameReferenceExpressionUsage.PROPERTY_SETTER ? "setValue" : "getValue";
        ResolveResult[] resolveResultArray = reference2.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])resolveResultArray), (Function1)findDelegatedMethod.1.INSTANCE), (Function1)findDelegatedMethod.2.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findDelegatedMethod$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (KtFunction)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)sequence3, (Function1)((Function1)new Function1<KtFunction, Boolean>(expectedMethodName){
            final /* synthetic */ String $expectedMethodName;
            {
                this.$expectedMethodName = $expectedMethodName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$expectedMethodName);
            }
        })));
    }

    private final String propertyAccessLabel(KaSession $context_receiver_0, KaPropertySymbol symbol2, KaDeclarationSymbol propertyAccessSymbol) {
        return symbol2.getName() + "." + KotlinMethodSmartStepTarget.Companion.calcLabel($context_receiver_0, propertyAccessSymbol);
    }

    private final KtNameReferenceExpressionUsage computeTargetType(KtNameReferenceExpression $this$computeTargetType) {
        PsiElement psiElement2 = $this$computeTargetType.getParent();
        KtQualifiedExpression ktQualifiedExpression = psiElement2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement2 : null;
        KtExpression potentialLeftHandSide = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$this$computeTargetType;
        PsiElement psiElement3 = potentialLeftHandSide.getParent();
        KtBinaryExpression ktBinaryExpression = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
        if (ktBinaryExpression == null) {
            return KtNameReferenceExpressionUsage.PROPERTY_GETTER;
        }
        KtBinaryExpression binaryExpr = ktBinaryExpression;
        return Intrinsics.areEqual((Object)binaryExpr.getOperationToken(), (Object)KtTokens.EQ) ? KtNameReferenceExpressionUsage.PROPERTY_SETTER : KtNameReferenceExpressionUsage.UNKNOWN;
    }

    private final void appendPropertyFilter(CallableMemberInfo methodInfo, KtDeclarationWithBody declaration2, String label2, KtExpression expression2, Range<Integer> lines) {
        if (expression2 instanceof KtCallableReferenceExpression) {
            this.append(new KotlinMethodReferenceSmartStepTarget(lines, (KtCallableReferenceExpression)expression2, label2, declaration2, methodInfo));
        } else {
            int ordinal = this.countExistingMethodCalls((KtDeclaration)declaration2);
            this.append(new KotlinMethodSmartStepTarget(lines, (PsiElement)expression2, label2, (KtDeclaration)declaration2, ordinal, methodInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean recordFunction(KtFunction function2) {
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)function2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)function2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)function2);
        try {
            KotlinLambdaInfo kotlinLambdaInfo;
            KotlinLambdaInfo kotlinLambdaInfo2;
            Pair<KaFunctionSymbol, KaValueParameterSymbol> pair;
            KaSession $this$recordFunction_u24lambda_u241 = analysisSession$iv$iv;
            boolean bl = false;
            if (InlineUtilsKt.getCallExpressionSymbol($this$recordFunction_u24lambda_u241, (KtExpression)function2) == null) {
                boolean bl2 = false;
                return bl2;
            }
            Pair<KaFunctionSymbol, KaValueParameterSymbol> pair2 = pair;
            KaFunctionSymbol methodSymbol = (KaFunctionSymbol)pair2.component1();
            KaValueParameterSymbol argumentSymbol = (KaValueParameterSymbol)pair2.component2();
            PsiElement declaration2 = methodSymbol.getPsi();
            PsiElement psiElement2 = declaration2;
            if (psiElement2 instanceof PsiMethod) {
                kotlinLambdaInfo2 = this.createJavaLambdaInfo($this$recordFunction_u24lambda_u241, (PsiMethod)declaration2, methodSymbol, argumentSymbol);
            } else if (psiElement2 instanceof KtDeclaration) {
                kotlinLambdaInfo2 = this.createKotlinLambdaInfo($this$recordFunction_u24lambda_u241, (KtDeclaration)declaration2, methodSymbol, argumentSymbol);
            } else {
                boolean bl3 = false;
                return bl3;
            }
            if (kotlinLambdaInfo2 == null) {
                boolean bl4 = false;
                return bl4;
            }
            KotlinLambdaInfo lambdaInfo = kotlinLambdaInfo;
            this.append(new KotlinLambdaSmartStepTarget(function2, declaration2, this.lines, lambdaInfo));
            boolean bl5 = true;
            return bl5;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)function2);
        }
    }

    private final KotlinLambdaInfo createJavaLambdaInfo(KaSession $context_receiver_0, PsiMethod declaration2, KaFunctionSymbol methodSymbol, KaValueParameterSymbol argumentSymbol) {
        int callerMethodOrdinal = this.countExistingMethodCalls(declaration2);
        return KotlinLambdaInfoKt.KotlinLambdaInfo$default($context_receiver_0, methodSymbol, argumentSymbol, callerMethodOrdinal, false, null, false, false, 224, null);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinLambdaInfo createKotlinLambdaInfo(KaSession $context_receiver_0, KtDeclaration declaration2, KaFunctionSymbol methodSymbol, KaValueParameterSymbol argumentSymbol) {
        KotlinLambdaInfo kotlinLambdaInfo;
        int callerMethodOrdinal = this.countExistingMethodCalls(declaration2);
        if ($context_receiver_0.isFunctionalInterface(argumentSymbol.getReturnType())) {
            Object v2;
            block11: {
                void $this$singleOrNull$iv;
                Sequence $this$filterIsInstance$iv;
                KaClassSymbol kaClassSymbol = $context_receiver_0.getExpandedSymbol(argumentSymbol.getReturnType());
                if (kaClassSymbol == null) {
                    return null;
                }
                KaClassSymbol samClassSymbol = kaClassSymbol;
                KaScope scope2 = $context_receiver_0.getMemberScope(samClassSymbol);
                Sequence sequence2 = KaScope.getCallableSymbols$default(scope2, null, 1, null);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)createKotlinLambdaInfo$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = sequence3;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KaNamedFunctionSymbol it = (KaNamedFunctionSymbol)element$iv;
                    boolean bl = false;
                    if (!(it.getModality() == KaSymbolModality.ABSTRACT)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block11;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            KaNamedFunctionSymbol kaNamedFunctionSymbol = v2;
            if (kaNamedFunctionSymbol == null) {
                return null;
            }
            KaNamedFunctionSymbol funMethodSymbol = kaNamedFunctionSymbol;
            boolean bl = CallableMemberInfoKt.containsInlineClassInValueArguments($context_receiver_0, funMethodSymbol);
            boolean $this$singleOrNull$iv = funMethodSymbol.isSuspend();
            String string = funMethodSymbol.getName().asString();
            Intrinsics.checkNotNull((Object)string);
            kotlinLambdaInfo = KotlinLambdaInfoKt.KotlinLambdaInfo($context_receiver_0, methodSymbol, argumentSymbol, callerMethodOrdinal, bl, string, true, $this$singleOrNull$iv);
        } else {
            boolean bl;
            KaFunctionType kaFunctionType;
            Object object = argumentSymbol.getReturnType();
            KaFunctionType kaFunctionType2 = kaFunctionType = object instanceof KaFunctionType ? (KaFunctionType)object : null;
            if (kaFunctionType != null && (object = kaFunctionType.getParameterTypes()) != null) {
                boolean bl2;
                block12: {
                    void $this$any$iv;
                    Iterable iterable = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KaType it = (KaType)element$iv;
                            boolean bl3 = false;
                            KaClassSymbol kaClassSymbol = $context_receiver_0.getExpandedSymbol(it);
                            boolean bl4 = kaClassSymbol != null ? JvmNameUtilKt.isInlineClass($context_receiver_0, kaClassSymbol) : false;
                            if (!bl4) continue;
                            bl2 = true;
                            break block12;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = false;
            }
            boolean isNameMangledInBytecode = bl;
            kotlinLambdaInfo = KotlinLambdaInfoKt.KotlinLambdaInfo$default($context_receiver_0, methodSymbol, argumentSymbol, callerMethodOrdinal, isNameMangledInBytecode, null, false, false, 224, null);
        }
        return kotlinLambdaInfo;
    }

    private final int countExistingMethodCalls(KtDeclaration declaration2) {
        return SequencesKt.count(SmartStepTargetVisitorKt.targetsWithDeclaration((Collection)this.consumer, declaration2));
    }

    /*
     * WARNING - void declaration
     */
    private final int countExistingMethodCalls(PsiMethod psiMethod2) {
        int n;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = (Iterable)this.consumer;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MethodSmartStepTarget)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                MethodSmartStepTarget it = (MethodSmartStepTarget)element$iv;
                boolean bl = false;
                if (!(psiMethod2 == it.getMethod()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
    }

    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitForExpression(@NotNull KtForExpression expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getLoopRange();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getSubjectExpression();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitArrayAccessExpression(expression2);
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)expression2))) {
            this.recordFunctionCall((KtExpression)expression2, (KtExpression)expression2);
        }
    }

    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitUnaryExpression(expression2);
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)expression2))) {
            KtExpression ktExpression = (KtExpression)expression2;
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
            this.recordFunctionCall(ktExpression, (KtExpression)ktSimpleNameExpression);
        }
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitBinaryExpression(expression2);
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)expression2))) {
            KtExpression ktExpression = (KtExpression)expression2;
            KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
            this.recordFunctionCall(ktExpression, (KtExpression)ktOperationReferenceExpression);
        }
    }

    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitCallExpression(expression2);
        KtExpression calleeExpression2 = expression2.getCalleeExpression();
        if (calleeExpression2 != null && this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)expression2))) {
            this.recordFunctionCall((KtExpression)expression2, calleeExpression2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.checkLineRangeFits(KotlinSteppingCommandProviderKt.getLineRange((PsiElement)expression2))) {
            boolean $i$f$analyze = false;
            Project project2 = ((KtElement)expression2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression2);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression2);
            try {
                KaPropertySymbol kaPropertySymbol;
                KaVariableAccessCall kaVariableAccessCall;
                KaSuccessCallInfo kaSuccessCallInfo;
                KaSession $this$visitSimpleNameExpression_u24lambda_u245 = analysisSession$iv$iv;
                boolean bl = false;
                KaCallInfo kaCallInfo = $this$visitSimpleNameExpression_u24lambda_u245.resolveToCall((KtElement)expression2);
                if ((kaCallInfo instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)kaCallInfo : null) == null) {
                    return;
                }
                KaSuccessCallInfo resolvedCall2 = kaSuccessCallInfo;
                KaCall kaCall = resolvedCall2.getCall();
                if ((kaCall instanceof KaVariableAccessCall ? (KaVariableAccessCall)kaCall : null) == null) {
                    return;
                }
                KaVariableAccessCall variableAccessCall = kaVariableAccessCall;
                Object s = KaPartiallyAppliedSymbolKt.getSymbol(variableAccessCall.getPartiallyAppliedSymbol());
                if ((s instanceof KaPropertySymbol ? (KaPropertySymbol)s : null) == null) {
                    return;
                }
                KaPropertySymbol symbol2 = kaPropertySymbol;
                boolean bl2 = this.recordProperty($this$visitSimpleNameExpression_u24lambda_u245, (KtExpression)expression2, symbol2);
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression2);
            }
        }
        super.visitSimpleNameExpression(expression2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void recordFunctionCall(KtExpression expression2, KtExpression highlightExpression) {
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)expression2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression2);
        try {
            PsiElement declaration2;
            KaFunctionSymbol symbol2;
            KaSession $this$recordFunctionCall_u24lambda_u247;
            block25: {
                block26: {
                    boolean bl;
                    block23: {
                        $this$recordFunctionCall_u24lambda_u247 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        KaLifetimeOwner kaLifetimeOwner = $this$recordFunctionCall_u24lambda_u247.resolveToCall((KtElement)expression2);
                        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
                            return;
                        }
                        KaLifetimeOwner resolvedCall2 = kaLifetimeOwner;
                        symbol2 = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(resolvedCall2.getPartiallyAppliedSymbol());
                        Iterable $this$any$iv = symbol2.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                KaAnnotation it = (KaAnnotation)element$iv;
                                boolean bl3 = false;
                                ClassId classId = it.getClassId();
                                if (!Intrinsics.areEqual((Object)(classId != null ? SignatureBuildingComponentsKt.getInternalName((ClassId)classId) : null), (Object)"kotlin/internal/IntrinsicConstEvaluation")) continue;
                                bl = true;
                                break block23;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                    declaration2 = this.getFunctionDeclaration($this$recordFunctionCall_u24lambda_u247, symbol2);
                    if (declaration2 instanceof PsiMethod) {
                        this.append((SmartStepTarget)new MethodSmartStepTarget((PsiMethod)declaration2, null, (PsiElement)highlightExpression, false, this.lines));
                        return;
                    }
                    if (declaration2 != null) break block25;
                    if (!(symbol2 instanceof KaNamedFunctionSymbol)) break block26;
                    if (((KaNamedFunctionSymbol)symbol2).isBuiltinFunctionInvoke()) break block25;
                }
                return;
            }
            PsiElement psiElement2 = declaration2;
            if (!(psiElement2 == null ? true : psiElement2 instanceof KtDeclaration)) {
                return;
            }
            if (symbol2 instanceof KaConstructorSymbol && ((KaConstructorSymbol)symbol2).isPrimary() && declaration2 instanceof KtClass && ((KtClass)declaration2).getAnonymousInitializers().isEmpty()) {
                return;
            }
            if (declaration2 instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)declaration2)) {
                return;
            }
            String callLabel = KotlinMethodSmartStepTarget.Companion.calcLabel($this$recordFunctionCall_u24lambda_u247, symbol2);
            String label2 = symbol2 instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol2).isBuiltinFunctionInvoke() && highlightExpression instanceof KtSimpleNameExpression ? ((KtSimpleNameExpression)highlightExpression).getText() + "." + callLabel : callLabel;
            PsiElement psiElement3 = declaration2;
            int ordinal = psiElement3 == null ? 0 : this.countExistingMethodCalls((KtDeclaration)psiElement3);
            this.append(new KotlinMethodSmartStepTarget(this.lines, (PsiElement)highlightExpression, label2, (KtDeclaration)declaration2, ordinal, CallableMemberInfoKt.CallableMemberInfo$default($this$recordFunctionCall_u24lambda_u247, symbol2, ordinal, null, 8, null)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression2);
        }
    }

    private final PsiElement getFunctionDeclaration(KaSession $context_receiver_0, KaFunctionSymbol symbol2) {
        PsiElement psiElement2;
        block4: {
            if (symbol2 instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol2).isBuiltinFunctionInvoke()) {
                return null;
            }
            PsiElement psiElement3 = symbol2.getPsi();
            if (psiElement3 != null) {
                PsiElement it = psiElement3;
                boolean bl = false;
                return it;
            }
            if (!(symbol2 instanceof KaNamedFunctionSymbol)) {
                return null;
            }
            for (KaCallableSymbol it : $context_receiver_0.getAllOverriddenSymbols(symbol2)) {
                boolean bl = false;
                PsiElement psiElement4 = it.getPsi();
                if (psiElement4 == null) continue;
                psiElement2 = psiElement4;
                break block4;
            }
            psiElement2 = null;
        }
        return psiElement2;
    }

    private final boolean checkLineRangeFits(IntRange lineRange) {
        return lineRange != null && this.lines.isWithin((Comparable)Integer.valueOf(lineRange.getFirst())) && this.lines.isWithin((Comparable)Integer.valueOf(lineRange.getLast()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor$KtNameReferenceExpressionUsage;", "", "(Ljava/lang/String;I)V", "PROPERTY_GETTER", "PROPERTY_SETTER", "UNKNOWN", "kotlin.jvm-debugger.core-fe10"})
    private static final class KtNameReferenceExpressionUsage
    extends Enum<KtNameReferenceExpressionUsage> {
        public static final /* enum */ KtNameReferenceExpressionUsage PROPERTY_GETTER = new KtNameReferenceExpressionUsage();
        public static final /* enum */ KtNameReferenceExpressionUsage PROPERTY_SETTER = new KtNameReferenceExpressionUsage();
        public static final /* enum */ KtNameReferenceExpressionUsage UNKNOWN = new KtNameReferenceExpressionUsage();
        private static final /* synthetic */ KtNameReferenceExpressionUsage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KtNameReferenceExpressionUsage[] values() {
            return (KtNameReferenceExpressionUsage[])$VALUES.clone();
        }

        public static KtNameReferenceExpressionUsage valueOf(String value2) {
            return Enum.valueOf(KtNameReferenceExpressionUsage.class, value2);
        }

        @NotNull
        public static EnumEntries<KtNameReferenceExpressionUsage> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = ktNameReferenceExpressionUsageArray = new KtNameReferenceExpressionUsage[]{KtNameReferenceExpressionUsage.PROPERTY_GETTER, KtNameReferenceExpressionUsage.PROPERTY_SETTER, KtNameReferenceExpressionUsage.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtNameReferenceExpressionUsage.values().length];
            try {
                nArray[KtNameReferenceExpressionUsage.PROPERTY_GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtNameReferenceExpressionUsage.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtNameReferenceExpressionUsage.PROPERTY_SETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

