/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleScriptListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptFileChangeListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;", "watcher", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptListener;", "buildRootsManager", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "(Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptListener;Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;)V", "changedFiles", "", "", "getChangedFiles", "()Ljava/util/List;", "apply", "", "init", "isProcessRecursively", "", "isRelevant", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "updateFile", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleScriptListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptListener.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptFileChangeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1855#2,2:96\n*S KotlinDebug\n*F\n+ 1 GradleScriptListener.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptFileChangeListener\n*L\n88#1:96,2\n*E\n"})
final class GradleScriptFileChangeListener
implements VirtualFileChangesListener {
    @NotNull
    private final GradleScriptListener watcher;
    @NotNull
    private final GradleBuildRootsManager buildRootsManager;
    @NotNull
    private final List<String> changedFiles;

    public GradleScriptFileChangeListener(@NotNull GradleScriptListener watcher, @NotNull GradleBuildRootsManager buildRootsManager) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter((Object)buildRootsManager, (String)"buildRootsManager");
        this.watcher = watcher;
        this.buildRootsManager = buildRootsManager;
        this.changedFiles = new ArrayList();
    }

    @NotNull
    public final List<String> getChangedFiles() {
        return this.changedFiles;
    }

    public boolean isProcessRecursively() {
        return true;
    }

    public void init() {
        this.changedFiles.clear();
    }

    public boolean isRelevant(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return this.buildRootsManager.maybeAffectedGradleProjectFile(string);
    }

    public void updateFile(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.changedFiles.add(string);
    }

    public void apply() {
        Function2<String, Long, Unit> fileChangesProcessor2 = this.watcher.getFileChangesProcessor();
        Iterable $this$forEach$iv = this.changedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile f2;
            String it = (String)element$iv;
            boolean bl = false;
            if (LocalFileSystem.getInstance().findFileByPath(it) == null) continue;
            boolean bl2 = false;
            String string = f2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.watcher.fileChanged(string, f2.getTimeStamp());
            String string2 = f2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            fileChangesProcessor2.invoke((Object)string2, (Object)f2.getTimeStamp());
        }
    }
}

