/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.scripting.KotlinBaseScriptingBundle;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinSupportAvailability;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.highlighter.ScriptingSupportAvailabilityKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptingSupportAvailability;", "Lorg/jetbrains/kotlin/idea/codeinsight/utils/KotlinSupportAvailability;", "()V", "isSupported", "", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "name", "", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptingSupportAvailability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingSupportAvailability.kt\norg/jetbrains/kotlin/idea/highlighter/ScriptingSupportAvailability\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1747#2,3:27\n*S KotlinDebug\n*F\n+ 1 ScriptingSupportAvailability.kt\norg/jetbrains/kotlin/idea/highlighter/ScriptingSupportAvailability\n*L\n24#1:27,3\n*E\n"})
public final class ScriptingSupportAvailability
implements KotlinSupportAvailability {
    @Override
    @NotNull
    public String name() {
        return KotlinBaseScriptingBundle.message("scripting.support.availability.name", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(@NotNull KtElement ktElement) {
        Function1 it;
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        PsiFile psiFile2 = ktElement.getContainingFile();
        if (!(psiFile2 instanceof KtFile)) return true;
        KtFile ktFile2 = (KtFile)psiFile2;
        if (ktFile2 == null) {
            return true;
        }
        KtFile ktFile3 = ktFile2;
        if (!ktFile3.isScript()) {
            return true;
        }
        if (!Registry.is((String)"kotlin.k2.scripting.enabled", (boolean)true)) {
            Project project2 = ktFile3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (KotlinScriptingSettings.Companion.getInstance(project2).getShowK2SupportWarning()) return false;
        }
        Iterable $this$any$iv = ScriptingSupportAvailabilityKt.getSupportedScriptPredicates();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Function1)element$iv;
            boolean bl = false;
        } while (!((Boolean)it.invoke((Object)ktFile3)).booleanValue());
        return true;
    }
}

