/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressableWarningProblemGroupKt;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressionChecker;
import org.jetbrains.kotlin.idea.inspections.suppress.RemoveRedundantSuppression;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u000f\u001a\u00020\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/suppress/KotlinInspectionSuppressor;", "Lcom/intellij/codeInspection/InspectionSuppressor;", "Lcom/intellij/codeInspection/RedundantSuppressionDetector;", "()V", "createRemoveRedundantSuppressionFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "toolId", "", "getHighlightingRange", "Lcom/intellij/openapi/util/TextRange;", "elementWithSuppression", "Lcom/intellij/psi/PsiElement;", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "getSuppressionIds", "isSuppressedFor", "", "isSuppressionFor", "place", "suppressionIds", "", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nKotlinInspectionSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInspectionSuppressor.kt\norg/jetbrains/kotlin/idea/inspections/suppress/KotlinInspectionSuppressor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n37#3,2:101\n188#4:103\n1#5:104\n*S KotlinDebug\n*F\n+ 1 KotlinInspectionSuppressor.kt\norg/jetbrains/kotlin/idea/inspections/suppress/KotlinInspectionSuppressor\n*L\n26#1:97\n26#1:98,3\n38#1:101,2\n44#1:103\n*E\n"})
public final class KotlinInspectionSuppressor
implements InspectionSuppressor,
RedundantSuppressionDetector {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element3, @NotNull String toolId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        if (element3 == null) {
            Intrinsics.checkNotNullExpressionValue((Object)SuppressQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        Iterable $this$map$iv = KotlinSuppressableWarningProblemGroupKt.createSuppressWarningActions(element3, Severity.WARNING, toolId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SuppressIntentionAction suppressIntentionAction = (SuppressIntentionAction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SuppressQuickFix((SuppressIntentionAction)it){
                final /* synthetic */ SuppressIntentionAction $it;
                {
                    this.$it = $it;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.$it.getFamilyName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamilyName(...)");
                    return string;
                }

                @NotNull
                public String getName() {
                    String string = this.$it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    return string;
                }

                public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    this.$it.invoke(project2, null, descriptor2.getPsiElement());
                }

                public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    return this.$it.isAvailable(project2, null, context2);
                }

                public boolean isSuppressAll() {
                    return this.$it.isSuppressAll();
                }
            });
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SuppressQuickFix[0]);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element3, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return KotlinSuppressionChecker.Companion.getInstance().isSuppressedFor(element3, toolId);
    }

    @Nullable
    public String getSuppressionIds(@NotNull PsiElement element3) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Collection $this$ifNotEmpty$iv = this.suppressionIds(element3);
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$getSuppressionIds_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            string = CollectionsKt.joinToString$default((Iterable)$this$getSuppressionIds_u24lambda_u241, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final List<String> suppressionIds(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof KtAnnotated)) {
            return CollectionsKt.emptyList();
        }
        List list2 = KotlinPsiHeuristics.findSuppressedEntities((KtAnnotated)element3);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return new RemoveRedundantSuppression(toolId);
    }

    public boolean isSuppressionFor(@NotNull PsiElement elementWithSuppression, @NotNull PsiElement place, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)elementWithSuppression, (String)"elementWithSuppression");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return elementWithSuppression == place || PsiTreeUtilKt.isAncestor((PsiElement)elementWithSuppression, (PsiElement)place, (boolean)false);
    }

    @Nullable
    public TextRange getHighlightingRange(@NotNull PsiElement elementWithSuppression, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)elementWithSuppression, (String)"elementWithSuppression");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        KtAnnotated ktAnnotated = elementWithSuppression instanceof KtAnnotated ? (KtAnnotated)elementWithSuppression : null;
        if (ktAnnotated == null) {
            return null;
        }
        KtAnnotated annotated = ktAnnotated;
        KtAnnotationEntry ktAnnotationEntry = KotlinPsiHeuristics.findSuppressAnnotation(annotated);
        if (ktAnnotationEntry == null) {
            return null;
        }
        KtAnnotationEntry suppressAnnotationEntry = ktAnnotationEntry;
        Integer n = StringUtil.indexOfIgnoreCase((String)suppressAnnotationEntry.getText(), (String)toolId, (int)0);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return null;
        }
        int index = n2;
        return new TextRange(index, index + toolId.length()).shiftRight(TextRangeUtilsKt.textRangeIn((PsiElement)suppressAnnotationEntry, (PsiElement)annotated).getStartOffset());
    }
}

