/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R,\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertCollectionConstructorToFunction;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "functionMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
public final class ConvertCollectionConstructorToFunction
extends SelfTargetingIntention<KtCallExpression> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final HashMap<String, String> functionMap;

    public ConvertCollectionConstructorToFunction() {
        super(KtCallExpression.class, KotlinBundle.lazyMessage((String)"convert.collection.constructor.to.function", (Object[])new Object[0]), null, 4, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"java.util.ArrayList.<init>", (Object)"arrayListOf"), TuplesKt.to((Object)"kotlin.collections.ArrayList.<init>", (Object)"arrayListOf"), TuplesKt.to((Object)"java.util.HashMap.<init>", (Object)"hashMapOf"), TuplesKt.to((Object)"kotlin.collections.HashMap.<init>", (Object)"hashMapOf"), TuplesKt.to((Object)"java.util.HashSet.<init>", (Object)"hashSetOf"), TuplesKt.to((Object)"kotlin.collections.HashSet.<init>", (Object)"hashSetOf"), TuplesKt.to((Object)"java.util.LinkedHashMap.<init>", (Object)"linkedMapOf"), TuplesKt.to((Object)"kotlin.collections.LinkedHashMap.<init>", (Object)"linkedMapOf"), TuplesKt.to((Object)"java.util.LinkedHashSet.<init>", (Object)"linkedSetOf"), TuplesKt.to((Object)"kotlin.collections.LinkedHashSet.<init>", (Object)"linkedSetOf")};
        this.functionMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Object object = ResolutionUtils.resolveToCall$default((KtElement)element3, null, 1, null);
        if (object == null || (object = object.getResultingDescriptor()) == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
            return false;
        }
        Object fq = object;
        return this.functionMap.containsKey(fq) && element3.getValueArguments().size() == 0;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Object object = ResolutionUtils.resolveToCall$default((KtElement)element3, null, 1, null);
            if (object == null || (object = object.getResultingDescriptor()) == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
                return;
            }
            Object fq = object;
            String string = this.functionMap.get(fq);
            if (string == null) {
                return;
            }
            String toCall = string;
            KtExpression ktExpression = element3.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression callee = ktExpression;
            Project project2 = element3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            callee.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createExpression(toCall));
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element3));
            if (ktQualifiedExpression == null) break block3;
            ktQualifiedExpression.replace((PsiElement)element3);
        }
    }
}

