/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchingState;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.SequenceTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatch;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatcher;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/MapTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/SequenceTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "indexVariable", "mapping", "Lorg/jetbrains/kotlin/psi/KtExpression;", "mapNotNull", "", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "affectsIndex", "getAffectsIndex", "()Z", "functionName", "", "getIndexVariable", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getInputVariable", "getLoop", "()Lorg/jetbrains/kotlin/psi/KtForExpression;", "getMapNotNull", "getMapping", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "presentation", "getPresentation", "()Ljava/lang/String;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Matcher", "kotlin.idea"})
public final class MapTransformation
implements SequenceTransformation {
    @NotNull
    private final KtForExpression loop;
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @Nullable
    private final KtCallableDeclaration indexVariable;
    @NotNull
    private final KtExpression mapping;
    private final boolean mapNotNull;
    @NotNull
    private final String functionName;

    public MapTransformation(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @Nullable KtCallableDeclaration indexVariable, @NotNull KtExpression mapping, boolean mapNotNull) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)inputVariable, (String)"inputVariable");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        this.loop = loop;
        this.inputVariable = inputVariable;
        this.indexVariable = indexVariable;
        this.mapping = mapping;
        this.mapNotNull = mapNotNull;
        this.functionName = this.indexVariable != null ? (this.mapNotNull ? "mapIndexedNotNull" : "mapIndexed") : (this.mapNotNull ? "mapNotNull" : "map");
    }

    @Override
    @NotNull
    public KtForExpression getLoop() {
        return this.loop;
    }

    @NotNull
    public final KtCallableDeclaration getInputVariable() {
        return this.inputVariable;
    }

    @Nullable
    public final KtCallableDeclaration getIndexVariable() {
        return this.indexVariable;
    }

    @NotNull
    public final KtExpression getMapping() {
        return this.mapping;
    }

    public final boolean getMapNotNull() {
        return this.mapNotNull;
    }

    @Override
    public boolean getAffectsIndex() {
        return this.mapNotNull;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return this.functionName + "{}";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        KtLambdaExpression lambda2 = UtilsKt.generateLambda(this.inputVariable, this.indexVariable, this.mapping, chainedCallGenerator2.getReformat());
        Object[] objectArray = new Object[]{lambda2};
        return ChainedCallGenerator.generate$default(chainedCallGenerator2, this.functionName + "$0:'{}'", objectArray, null, false, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/MapTransformation$Matcher;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatcher;", "()V", "embeddedBreakOrContinuePossible", "", "getEmbeddedBreakOrContinuePossible", "()Z", "indexVariableAllowed", "getIndexVariableAllowed", "match", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatch$Sequence;", "state", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/MatchingState;", "kotlin.idea"})
    public static final class Matcher
    implements TransformationMatcher {
        @NotNull
        public static final Matcher INSTANCE = new Matcher();

        private Matcher() {
        }

        @Override
        public boolean getIndexVariableAllowed() {
            return true;
        }

        @Override
        public boolean getEmbeddedBreakOrContinuePossible() {
            return true;
        }

        @Override
        @Nullable
        public TransformationMatch.Sequence match(@NotNull MatchingState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Object object = CollectionsKt.firstOrNull(state.getStatements());
            KtProperty ktProperty = object instanceof KtProperty ? (KtProperty)object : null;
            if (ktProperty == null) {
                return null;
            }
            KtProperty declaration2 = ktProperty;
            KtExpression ktExpression = declaration2.getInitializer();
            if (ktExpression == null) {
                return null;
            }
            KtExpression initializer2 = ktExpression;
            if (CommonUtilsKt.hasWriteUsages((KtVariableDeclaration)declaration2)) {
                return null;
            }
            List restStatements = CollectionsKt.drop((Iterable)state.getStatements(), (int)1);
            if (initializer2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)initializer2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                KtExpression ktExpression2 = ((KtBinaryExpression)initializer2).getRight();
                KtContinueExpression ktContinueExpression = ktExpression2 instanceof KtContinueExpression ? (KtContinueExpression)ktExpression2 : null;
                if (ktContinueExpression == null) {
                    return null;
                }
                KtContinueExpression continueExpression = ktContinueExpression;
                if (!Intrinsics.areEqual((Object)CommonUtilsKt.targetLoop$default((KtExpressionWithLabel)continueExpression, null, 1, null), (Object)state.getInnerLoop())) {
                    return null;
                }
                KtExpression ktExpression3 = ((KtBinaryExpression)initializer2).getLeft();
                if (ktExpression3 == null) {
                    return null;
                }
                KtExpression mapping = ktExpression3;
                if (UtilsKt.containsEmbeddedBreakOrContinue(mapping)) {
                    return null;
                }
                MapTransformation transformation = state.getIndexVariable() != null && org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.hasUsages(state.getIndexVariable(), (KtElement)mapping) ? new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), mapping, true) : new MapTransformation(state.getOuterLoop(), state.getInputVariable(), null, mapping, true);
                MatchingState newState = MatchingState.copy$default(state, null, null, restStatements, (KtCallableDeclaration)declaration2, null, false, null, false, null, null, null, 2035, null);
                return new TransformationMatch.Sequence(transformation, newState);
            }
            if (UtilsKt.containsEmbeddedBreakOrContinue(initializer2)) {
                return null;
            }
            MapTransformation transformation = state.getIndexVariable() != null && org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.hasUsages(state.getIndexVariable(), (KtElement)initializer2) ? new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), initializer2, false) : new MapTransformation(state.getOuterLoop(), state.getInputVariable(), null, initializer2, false);
            MatchingState newState = MatchingState.copy$default(state, null, null, restStatements, (KtCallableDeclaration)declaration2, null, false, null, false, null, null, null, 2035, null);
            return new TransformationMatch.Sequence(transformation, newState);
        }
    }
}

