/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixFE10;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getFamilyName", "", "getText", "CrossInlineFactory", "CrossInlineSuspendFactory", "NoInlineFactory", "NoInlineSuspendFactory", "kotlin.idea"})
public final class AddInlineModifierFix
extends AddModifierFixFE10 {
    public AddInlineModifierFix(@NotNull KtParameter parameter, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super((KtModifierListOwner)parameter, modifier);
    }

    @Override
    @NotNull
    public String getText() {
        String string;
        String string2;
        KtModifierListOwner element3 = (KtModifierListOwner)this.getElement();
        if (element3 != null) {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)this.getModifier().getValue(), (String)"getValue(...)");
            objectArray[1] = String.valueOf(element3.getName());
            string2 = KotlinBundle.message((String)"fix.add.modifier.inline.parameter.text", (Object[])objectArray);
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.getModifier().getValue(), (String)"getValue(...)");
        return KotlinBundle.message((String)"fix.add.modifier.inline.parameter.family", (Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix$CrossInlineFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class CrossInlineFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final CrossInlineFactory INSTANCE = new CrossInlineFactory();

        private CrossInlineFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 casted = (DiagnosticWithParameters1)Errors.NON_LOCAL_RETURN_NOT_ALLOWED.cast((UnboundDiagnostic)diagnostic);
            Object object = casted.getA();
            KtNameReferenceExpression ktNameReferenceExpression = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression reference2 = ktNameReferenceExpression;
            KtParameter ktParameter = KotlinPsiUtils.findParameterWithName((KtElement)reference2, reference2.getReferencedName());
            if (ktParameter == null) {
                return null;
            }
            KtParameter parameter = ktParameter;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CROSSINLINE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"CROSSINLINE_KEYWORD");
            return new AddInlineModifierFix(parameter, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix$CrossInlineSuspendFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class CrossInlineSuspendFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final CrossInlineSuspendFactory INSTANCE = new CrossInlineSuspendFactory();

        private CrossInlineSuspendFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtParameter ktParameter = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
            if (ktParameter == null) {
                return null;
            }
            KtParameter parameter = ktParameter;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CROSSINLINE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"CROSSINLINE_KEYWORD");
            return new AddInlineModifierFix(parameter, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix$NoInlineFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class NoInlineFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final NoInlineFactory INSTANCE = new NoInlineFactory();

        private NoInlineFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            DiagnosticWithParameters2 diagnosticWithParameters2;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.USAGE_IS_NOT_INLINABLE)) {
                diagnosticWithParameters2 = (DiagnosticWithParameters2)Errors.USAGE_IS_NOT_INLINABLE.cast((UnboundDiagnostic)diagnostic);
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.USAGE_IS_NOT_INLINABLE_WARNING)) {
                diagnosticWithParameters2 = (DiagnosticWithParameters2)Errors.USAGE_IS_NOT_INLINABLE_WARNING.cast((UnboundDiagnostic)diagnostic);
            } else {
                return null;
            }
            DiagnosticWithParameters2 casted = diagnosticWithParameters2;
            Object object = casted.getA();
            KtNameReferenceExpression ktNameReferenceExpression = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression reference2 = ktNameReferenceExpression;
            KtParameter ktParameter = KotlinPsiUtils.findParameterWithName((KtElement)reference2, reference2.getReferencedName());
            if (ktParameter == null) {
                return null;
            }
            KtParameter parameter = ktParameter;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"NOINLINE_KEYWORD");
            return new AddInlineModifierFix(parameter, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix$NoInlineSuspendFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class NoInlineSuspendFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final NoInlineSuspendFactory INSTANCE = new NoInlineSuspendFactory();

        private NoInlineSuspendFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtParameter ktParameter = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
            if (ktParameter == null) {
                return null;
            }
            KtParameter parameter = ktParameter;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"NOINLINE_KEYWORD");
            return new AddInlineModifierFix(parameter, ktModifierKeywordToken);
        }
    }
}

