/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinPsiUpdateModCommandAction;
import org.jetbrains.kotlin.idea.quickfix.StarProjectionUtils;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinPsiUpdateModCommandAction$ElementBased;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "", "element", "argumentCount", "", "(Lorg/jetbrains/kotlin/psi/KtUserType;I)V", "getFamilyName", "", "invoke", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtUserType;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddStarProjectionsFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddStarProjectionsFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,36:1\n19#2:37\n*S KotlinDebug\n*F\n+ 1 AddStarProjectionsFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix\n*L\n26#1:37\n*E\n"})
public final class AddStarProjectionsFix
extends KotlinPsiUpdateModCommandAction.ElementBased<KtUserType, Unit> {
    private final int argumentCount;

    public AddStarProjectionsFix(@NotNull KtUserType element3, int argumentCount) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3, Unit.INSTANCE);
        this.argumentCount = argumentCount;
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtUserType element3, @NotNull Unit elementContext2, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext2, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        boolean bl = element3.getTypeArguments().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = element3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String typeString2 = StarProjectionUtils.INSTANCE.getTypeNameAndStarProjectionsString(string, this.argumentCount);
        Project project2 = actionContext.project();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtTypeElement $this$sure$iv = psiFactory.createType(typeString2).getTypeElement();
        boolean $i$f$sure = false;
        KtTypeElement ktTypeElement = $this$sure$iv;
        if (ktTypeElement == null) {
            boolean bl2 = false;
            String string2 = "No type element after parsing " + typeString2;
            throw new AssertionError((Object)string2);
        }
        KtTypeElement replacement2 = ktTypeElement;
        element3.replace((PsiElement)replacement2);
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{StarProjectionUtils.INSTANCE.getTypeNameAndStarProjectionsString("", this.argumentCount)};
        return KotlinBundle.message((String)"fix.add.star.projection.text", (Object[])objectArray);
    }
}

